/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.EntityAction;
import org.hibernate.cache.CacheKey;
import org.hibernate.cache.entry.CacheEntry;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Versioning;
import org.hibernate.event.EventSource;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PreInsertEvent;
import org.hibernate.event.PreInsertEventListener;
import org.hibernate.persister.entity.EntityPersister;

public final class EntityInsertAction
extends EntityAction {
    private Object[] state;
    private Object version;
    private Object cacheEntry;

    public EntityInsertAction(Serializable serializable, Object[] objectArray, Object object, Object object2, EntityPersister entityPersister, SessionImplementor sessionImplementor) throws HibernateException {
        super(sessionImplementor, serializable, object, entityPersister);
        this.state = objectArray;
        this.version = object2;
    }

    public void execute() throws HibernateException {
        Serializable serializable;
        EntityPersister entityPersister = this.getPersister();
        SessionImplementor sessionImplementor = this.getSession();
        Object object = this.getInstance();
        Serializable serializable2 = this.getId();
        boolean bl = this.preInsert();
        if (!bl) {
            entityPersister.insert(serializable2, this.state, object, sessionImplementor);
            serializable = sessionImplementor.getPersistenceContext().getEntry(object);
            if (serializable == null) {
                throw new AssertionFailure("possible nonthreadsafe access to session");
            }
            ((EntityEntry)serializable).postInsert();
            if (entityPersister.hasInsertGeneratedProperties()) {
                entityPersister.processInsertGeneratedProperties(serializable2, object, this.state, sessionImplementor);
                if (entityPersister.isVersionPropertyGenerated()) {
                    this.version = Versioning.getVersion(this.state, entityPersister);
                }
                ((EntityEntry)serializable).postUpdate(object, this.state, this.version);
            }
        }
        serializable = this.getSession().getFactory();
        if (this.isCachePutEnabled(entityPersister, sessionImplementor)) {
            CacheEntry cacheEntry = new CacheEntry(this.state, entityPersister, entityPersister.hasUninitializedLazyProperties(object, sessionImplementor.getEntityMode()), this.version, sessionImplementor, object);
            this.cacheEntry = entityPersister.getCacheEntryStructure().structure(cacheEntry);
            CacheKey cacheKey = new CacheKey(serializable2, entityPersister.getIdentifierType(), entityPersister.getRootEntityName(), sessionImplementor.getEntityMode(), sessionImplementor.getFactory());
            boolean bl2 = entityPersister.getCache().insert(cacheKey, this.cacheEntry, this.version);
            if (bl2 && serializable.getStatistics().isStatisticsEnabled()) {
                serializable.getStatisticsImplementor().secondLevelCachePut(this.getPersister().getCache().getRegionName());
            }
        }
        this.postInsert();
        if (serializable.getStatistics().isStatisticsEnabled() && !bl) {
            serializable.getStatisticsImplementor().insertEntity(this.getPersister().getEntityName());
        }
    }

    private void postInsert() {
        PostInsertEventListener[] postInsertEventListenerArray = this.getSession().getListeners().getPostInsertEventListeners();
        if (postInsertEventListenerArray.length > 0) {
            PostInsertEvent postInsertEvent = new PostInsertEvent(this.getInstance(), this.getId(), this.state, this.getPersister(), (EventSource)this.getSession());
            for (int i = 0; i < postInsertEventListenerArray.length; ++i) {
                postInsertEventListenerArray[i].onPostInsert(postInsertEvent);
            }
        }
    }

    private void postCommitInsert() {
        PostInsertEventListener[] postInsertEventListenerArray = this.getSession().getListeners().getPostCommitInsertEventListeners();
        if (postInsertEventListenerArray.length > 0) {
            PostInsertEvent postInsertEvent = new PostInsertEvent(this.getInstance(), this.getId(), this.state, this.getPersister(), (EventSource)this.getSession());
            for (int i = 0; i < postInsertEventListenerArray.length; ++i) {
                postInsertEventListenerArray[i].onPostInsert(postInsertEvent);
            }
        }
    }

    private boolean preInsert() {
        PreInsertEventListener[] preInsertEventListenerArray = this.getSession().getListeners().getPreInsertEventListeners();
        boolean bl = false;
        if (preInsertEventListenerArray.length > 0) {
            PreInsertEvent preInsertEvent = new PreInsertEvent(this.getInstance(), this.getId(), this.state, this.getPersister(), this.getSession());
            for (int i = 0; i < preInsertEventListenerArray.length; ++i) {
                bl = preInsertEventListenerArray[i].onPreInsert(preInsertEvent) || bl;
            }
        }
        return bl;
    }

    public void afterTransactionCompletion(boolean bl) throws HibernateException {
        EntityPersister entityPersister = this.getPersister();
        if (bl && this.isCachePutEnabled(entityPersister, this.getSession())) {
            CacheKey cacheKey = new CacheKey(this.getId(), entityPersister.getIdentifierType(), entityPersister.getRootEntityName(), this.getSession().getEntityMode(), this.getSession().getFactory());
            boolean bl2 = entityPersister.getCache().afterInsert(cacheKey, this.cacheEntry, this.version);
            if (bl2 && this.getSession().getFactory().getStatistics().isStatisticsEnabled()) {
                this.getSession().getFactory().getStatisticsImplementor().secondLevelCachePut(this.getPersister().getCache().getRegionName());
            }
        }
        this.postCommitInsert();
    }

    protected boolean hasPostCommitEventListeners() {
        return this.getSession().getListeners().getPostCommitInsertEventListeners().length > 0;
    }

    private boolean isCachePutEnabled(EntityPersister entityPersister, SessionImplementor sessionImplementor) {
        return entityPersister.hasCache() && !entityPersister.isCacheInvalidationRequired() && sessionImplementor.getCacheMode().isPutEnabled();
    }
}

