/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.EntityAction;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheKey;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.event.PostDeleteEvent;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PreDeleteEvent;
import org.hibernate.event.PreDeleteEventListener;
import org.hibernate.persister.entity.EntityPersister;

public final class EntityDeleteAction
extends EntityAction {
    private final Object version;
    private CacheConcurrencyStrategy.SoftLock lock;
    private final boolean isCascadeDeleteEnabled;
    private final Object[] state;

    public EntityDeleteAction(Serializable serializable, Object[] objectArray, Object object, Object object2, EntityPersister entityPersister, boolean bl, SessionImplementor sessionImplementor) {
        super(sessionImplementor, serializable, object2, entityPersister);
        this.version = object;
        this.isCascadeDeleteEnabled = bl;
        this.state = objectArray;
    }

    public void execute() throws HibernateException {
        PersistenceContext persistenceContext;
        EntityEntry entityEntry;
        CacheKey cacheKey;
        Serializable serializable = this.getId();
        EntityPersister entityPersister = this.getPersister();
        SessionImplementor sessionImplementor = this.getSession();
        Object object = this.getInstance();
        boolean bl = this.preDelete();
        Object object2 = this.version;
        if (entityPersister.isVersionPropertyGenerated()) {
            object2 = entityPersister.getVersion(object, sessionImplementor.getEntityMode());
        }
        if (entityPersister.hasCache()) {
            cacheKey = new CacheKey(serializable, entityPersister.getIdentifierType(), entityPersister.getRootEntityName(), sessionImplementor.getEntityMode(), sessionImplementor.getFactory());
            this.lock = entityPersister.getCache().lock(cacheKey, object2);
        } else {
            cacheKey = null;
        }
        if (!this.isCascadeDeleteEnabled && !bl) {
            entityPersister.delete(serializable, object2, object, sessionImplementor);
        }
        if ((entityEntry = (persistenceContext = sessionImplementor.getPersistenceContext()).removeEntry(object)) == null) {
            throw new AssertionFailure("possible nonthreadsafe access to session");
        }
        entityEntry.postDelete();
        EntityKey entityKey = new EntityKey(entityEntry.getId(), entityEntry.getPersister(), sessionImplementor.getEntityMode());
        persistenceContext.removeEntity(entityKey);
        persistenceContext.removeProxy(entityKey);
        if (entityPersister.hasCache()) {
            entityPersister.getCache().evict(cacheKey);
        }
        this.postDelete();
        if (this.getSession().getFactory().getStatistics().isStatisticsEnabled() && !bl) {
            this.getSession().getFactory().getStatisticsImplementor().deleteEntity(this.getPersister().getEntityName());
        }
    }

    private boolean preDelete() {
        PreDeleteEventListener[] preDeleteEventListenerArray = this.getSession().getListeners().getPreDeleteEventListeners();
        boolean bl = false;
        if (preDeleteEventListenerArray.length > 0) {
            PreDeleteEvent preDeleteEvent = new PreDeleteEvent(this.getInstance(), this.getId(), this.state, this.getPersister());
            for (int i = 0; i < preDeleteEventListenerArray.length; ++i) {
                bl = preDeleteEventListenerArray[i].onPreDelete(preDeleteEvent) || bl;
            }
        }
        return bl;
    }

    private void postDelete() {
        PostDeleteEventListener[] postDeleteEventListenerArray = this.getSession().getListeners().getPostDeleteEventListeners();
        if (postDeleteEventListenerArray.length > 0) {
            PostDeleteEvent postDeleteEvent = new PostDeleteEvent(this.getInstance(), this.getId(), this.state, this.getPersister(), (EventSource)this.getSession());
            for (int i = 0; i < postDeleteEventListenerArray.length; ++i) {
                postDeleteEventListenerArray[i].onPostDelete(postDeleteEvent);
            }
        }
    }

    private void postCommitDelete() {
        PostDeleteEventListener[] postDeleteEventListenerArray = this.getSession().getListeners().getPostCommitDeleteEventListeners();
        if (postDeleteEventListenerArray.length > 0) {
            PostDeleteEvent postDeleteEvent = new PostDeleteEvent(this.getInstance(), this.getId(), this.state, this.getPersister(), (EventSource)this.getSession());
            for (int i = 0; i < postDeleteEventListenerArray.length; ++i) {
                postDeleteEventListenerArray[i].onPostDelete(postDeleteEvent);
            }
        }
    }

    public void afterTransactionCompletion(boolean bl) throws HibernateException {
        if (this.getPersister().hasCache()) {
            CacheKey cacheKey = new CacheKey(this.getId(), this.getPersister().getIdentifierType(), this.getPersister().getRootEntityName(), this.getSession().getEntityMode(), this.getSession().getFactory());
            this.getPersister().getCache().release(cacheKey, this.lock);
        }
        this.postCommitDelete();
    }

    protected boolean hasPostCommitEventListeners() {
        return this.getSession().getListeners().getPostCommitDeleteEventListeners().length > 0;
    }
}

