/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.action.DelayedPostInsertIdentifier;
import org.hibernate.action.Executable;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.util.StringHelper;

public abstract class EntityAction
implements Executable,
Serializable,
Comparable {
    private final SessionImplementor session;
    private final Serializable id;
    private final Object instance;
    private final String entityName;
    private transient EntityPersister persister;

    protected EntityAction(SessionImplementor sessionImplementor, Serializable serializable, Object object, EntityPersister entityPersister) {
        this.session = sessionImplementor;
        this.id = serializable;
        this.persister = entityPersister;
        this.instance = object;
        this.entityName = entityPersister.getEntityName();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.persister = this.session.getFactory().getEntityPersister(this.entityName);
    }

    public final Serializable[] getPropertySpaces() {
        return this.persister.getPropertySpaces();
    }

    protected final SessionImplementor getSession() {
        return this.session;
    }

    protected final Serializable getId() {
        if (this.id instanceof DelayedPostInsertIdentifier) {
            return this.session.getPersistenceContext().getEntry(this.instance).getId();
        }
        return this.id;
    }

    protected final EntityPersister getPersister() {
        return this.persister;
    }

    protected final Object getInstance() {
        return this.instance;
    }

    public void beforeExecutions() {
        throw new AssertionFailure("beforeExecutions() called for non-collection action");
    }

    public boolean hasAfterTransactionCompletion() {
        return this.persister.hasCache() || this.hasPostCommitEventListeners();
    }

    protected abstract boolean hasPostCommitEventListeners();

    public String toString() {
        return StringHelper.unqualify(this.getClass().getName()) + MessageHelper.infoString(this.entityName, this.id);
    }

    public int compareTo(Object object) {
        EntityAction entityAction = (EntityAction)object;
        int n = this.entityName.compareTo(entityAction.entityName);
        if (n != 0) {
            return n;
        }
        return this.persister.getIdentifierType().compare(this.id, entityAction.id, this.session.getEntityMode());
    }
}

