/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.CollectionAction;
import org.hibernate.cache.CacheException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;

public final class CollectionUpdateAction
extends CollectionAction {
    private final boolean emptySnapshot;

    public CollectionUpdateAction(PersistentCollection persistentCollection, CollectionPersister collectionPersister, Serializable serializable, boolean bl, SessionImplementor sessionImplementor) throws CacheException {
        super(collectionPersister, persistentCollection, serializable, sessionImplementor);
        this.emptySnapshot = bl;
    }

    public void execute() throws HibernateException {
        Serializable serializable = this.getKey();
        SessionImplementor sessionImplementor = this.getSession();
        CollectionPersister collectionPersister = this.getPersister();
        PersistentCollection persistentCollection = this.getCollection();
        boolean bl = collectionPersister.isAffectedByEnabledFilters(sessionImplementor);
        if (!persistentCollection.wasInitialized()) {
            if (!persistentCollection.hasQueuedOperations()) {
                throw new AssertionFailure("no queued adds");
            }
        } else if (!bl && persistentCollection.empty()) {
            if (!this.emptySnapshot) {
                collectionPersister.remove(serializable, sessionImplementor);
            }
        } else if (persistentCollection.needsRecreate(collectionPersister)) {
            if (bl) {
                throw new HibernateException("cannot recreate collection while filter is enabled: " + MessageHelper.collectionInfoString(collectionPersister, serializable, collectionPersister.getFactory()));
            }
            if (!this.emptySnapshot) {
                collectionPersister.remove(serializable, sessionImplementor);
            }
            collectionPersister.recreate(persistentCollection, serializable, sessionImplementor);
        } else {
            collectionPersister.deleteRows(persistentCollection, serializable, sessionImplementor);
            collectionPersister.updateRows(persistentCollection, serializable, sessionImplementor);
            collectionPersister.insertRows(persistentCollection, serializable, sessionImplementor);
        }
        this.getSession().getPersistenceContext().getCollectionEntry(persistentCollection).afterAction(persistentCollection);
        this.evict();
        if (this.getSession().getFactory().getStatistics().isStatisticsEnabled()) {
            this.getSession().getFactory().getStatisticsImplementor().updateCollection(this.getPersister().getRole());
        }
    }
}

