/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.action.CollectionAction;
import org.hibernate.cache.CacheException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;

public final class CollectionRemoveAction
extends CollectionAction {
    private boolean emptySnapshot;

    public CollectionRemoveAction(PersistentCollection persistentCollection, CollectionPersister collectionPersister, Serializable serializable, boolean bl, SessionImplementor sessionImplementor) throws CacheException {
        super(collectionPersister, persistentCollection, serializable, sessionImplementor);
        this.emptySnapshot = bl;
    }

    public void execute() throws HibernateException {
        PersistentCollection persistentCollection;
        if (!this.emptySnapshot) {
            this.getPersister().remove(this.getKey(), this.getSession());
        }
        if ((persistentCollection = this.getCollection()) != null) {
            this.getSession().getPersistenceContext().getCollectionEntry(persistentCollection).afterAction(persistentCollection);
        }
        this.evict();
        if (this.getSession().getFactory().getStatistics().isStatisticsEnabled()) {
            this.getSession().getFactory().getStatisticsImplementor().removeCollection(this.getPersister().getRole());
        }
    }
}

