/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.action.CollectionAction;
import org.hibernate.cache.CacheException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;

public final class CollectionRecreateAction
extends CollectionAction {
    public CollectionRecreateAction(PersistentCollection persistentCollection, CollectionPersister collectionPersister, Serializable serializable, SessionImplementor sessionImplementor) throws CacheException {
        super(collectionPersister, persistentCollection, serializable, sessionImplementor);
    }

    public void execute() throws HibernateException {
        PersistentCollection persistentCollection = this.getCollection();
        this.getPersister().recreate(persistentCollection, this.getKey(), this.getSession());
        this.getSession().getPersistenceContext().getCollectionEntry(persistentCollection).afterAction(persistentCollection);
        this.evict();
        if (this.getSession().getFactory().getStatistics().isStatisticsEnabled()) {
            this.getSession().getFactory().getStatisticsImplementor().recreateCollection(this.getPersister().getRole());
        }
    }
}

