/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.hibernate.action.DelayedPostInsertIdentifier;
import org.hibernate.action.Executable;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheKey;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.util.StringHelper;

public abstract class CollectionAction
implements Executable,
Serializable,
Comparable {
    private transient CollectionPersister persister;
    private final Serializable key;
    private Serializable finalKey;
    private final SessionImplementor session;
    private CacheConcurrencyStrategy.SoftLock lock;
    private final String collectionRole;
    private final PersistentCollection collection;

    public CollectionAction(CollectionPersister collectionPersister, PersistentCollection persistentCollection, Serializable serializable, SessionImplementor sessionImplementor) throws CacheException {
        this.persister = collectionPersister;
        this.session = sessionImplementor;
        this.key = serializable;
        this.collectionRole = collectionPersister.getRole();
        this.collection = persistentCollection;
    }

    protected PersistentCollection getCollection() {
        return this.collection;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.persister = this.session.getFactory().getCollectionPersister(this.collectionRole);
    }

    public void afterTransactionCompletion(boolean bl) throws CacheException {
        if (this.persister.hasCache()) {
            CacheKey cacheKey = new CacheKey(this.key, this.persister.getKeyType(), this.persister.getRole(), this.session.getEntityMode(), this.session.getFactory());
            this.persister.getCache().release(cacheKey, this.lock);
        }
    }

    public boolean hasAfterTransactionCompletion() {
        return this.persister.hasCache();
    }

    public Serializable[] getPropertySpaces() {
        return this.persister.getCollectionSpaces();
    }

    protected final CollectionPersister getPersister() {
        return this.persister;
    }

    protected final Serializable getKey() {
        this.finalKey = this.key;
        if (this.key instanceof DelayedPostInsertIdentifier) {
            this.finalKey = this.session.getPersistenceContext().getEntry(this.collection.getOwner()).getId();
            if (this.finalKey == this.key) {
                // empty if block
            }
        }
        return this.finalKey;
    }

    protected final SessionImplementor getSession() {
        return this.session;
    }

    public final void beforeExecutions() throws CacheException {
        if (this.persister.hasCache()) {
            CacheKey cacheKey = new CacheKey(this.key, this.persister.getKeyType(), this.persister.getRole(), this.session.getEntityMode(), this.session.getFactory());
            this.lock = this.persister.getCache().lock(cacheKey, null);
        }
    }

    protected final void evict() throws CacheException {
        if (this.persister.hasCache()) {
            CacheKey cacheKey = new CacheKey(this.key, this.persister.getKeyType(), this.persister.getRole(), this.session.getEntityMode(), this.session.getFactory());
            this.persister.getCache().evict(cacheKey);
        }
    }

    public String toString() {
        return StringHelper.unqualify(this.getClass().getName()) + MessageHelper.infoString(this.collectionRole, this.key);
    }

    public int compareTo(Object object) {
        CollectionAction collectionAction = (CollectionAction)object;
        int n = this.collectionRole.compareTo(collectionAction.collectionRole);
        if (n != 0) {
            return n;
        }
        return this.persister.getKeyType().compare(this.key, collectionAction.key, this.session.getEntityMode());
    }
}

