/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.action.Executable;
import org.hibernate.cache.OptimisticTreeCacheProvider;
import org.hibernate.cache.TreeCacheProvider;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Queryable;

public class BulkOperationCleanupAction
implements Executable,
Serializable {
    private final SessionImplementor session;
    private final Set affectedEntityNames = new HashSet();
    private final Set affectedCollectionRoles = new HashSet();
    private final Serializable[] spaces;

    public BulkOperationCleanupAction(SessionImplementor sessionImplementor, Queryable[] queryableArray) {
        int n;
        this.session = sessionImplementor;
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        for (n = 0; n < queryableArray.length; ++n) {
            Set set;
            if (queryableArray[n].hasCache()) {
                this.affectedEntityNames.add(queryableArray[n].getEntityName());
            }
            if ((set = sessionImplementor.getFactory().getCollectionRolesByEntityParticipant(queryableArray[n].getEntityName())) != null) {
                this.affectedCollectionRoles.addAll(set);
            }
            for (int i = 0; i < queryableArray[n].getQuerySpaces().length; ++i) {
                arrayList.add(queryableArray[n].getQuerySpaces()[i]);
            }
        }
        this.spaces = new Serializable[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            this.spaces[n] = (Serializable)arrayList.get(n);
        }
    }

    public BulkOperationCleanupAction(SessionImplementor sessionImplementor, Set set) {
        this.session = sessionImplementor;
        HashSet<Serializable> hashSet = new HashSet<Serializable>(set);
        SessionFactoryImplementor sessionFactoryImplementor = sessionImplementor.getFactory();
        Iterator iterator = sessionFactoryImplementor.getAllClassMetadata().entrySet().iterator();
        while (iterator.hasNext()) {
            Set set2;
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            EntityPersister entityPersister = sessionFactoryImplementor.getEntityPersister(string);
            Serializable[] serializableArray = entityPersister.getQuerySpaces();
            if (!this.affectedEntity(set, serializableArray)) continue;
            if (entityPersister.hasCache()) {
                this.affectedEntityNames.add(entityPersister.getEntityName());
            }
            if ((set2 = sessionImplementor.getFactory().getCollectionRolesByEntityParticipant(entityPersister.getEntityName())) != null) {
                this.affectedCollectionRoles.addAll(set2);
            }
            for (int i = 0; i < serializableArray.length; ++i) {
                hashSet.add(serializableArray[i]);
            }
        }
        this.spaces = hashSet.toArray(new Serializable[hashSet.size()]);
    }

    private boolean affectedEntity(Set set, Serializable[] serializableArray) {
        if (set == null || set.isEmpty()) {
            return true;
        }
        for (int i = 0; i < serializableArray.length; ++i) {
            if (!set.contains(serializableArray[i])) continue;
            return true;
        }
        return false;
    }

    public void init() {
        this.evictEntityRegions();
        this.evictCollectionRegions();
    }

    public boolean hasAfterTransactionCompletion() {
        return true;
    }

    public void afterTransactionCompletion(boolean bl) throws HibernateException {
        if (this.session.getFactory().getSettings().getCacheProvider() instanceof OptimisticTreeCacheProvider || this.session.getFactory().getSettings().getCacheProvider() instanceof TreeCacheProvider) {
            return;
        }
        this.evictEntityRegions();
        this.evictCollectionRegions();
    }

    public Serializable[] getPropertySpaces() {
        return this.spaces;
    }

    public void beforeExecutions() throws HibernateException {
    }

    public void execute() throws HibernateException {
    }

    private void evictEntityRegions() {
        if (this.affectedEntityNames != null) {
            Iterator iterator = this.affectedEntityNames.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.session.getFactory().evictEntity(string);
            }
        }
    }

    private void evictCollectionRegions() {
        if (this.affectedCollectionRoles != null) {
            Iterator iterator = this.affectedCollectionRoles.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.session.getFactory().evictCollection(string);
            }
        }
    }
}

