/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public final class LockMode
implements Serializable {
    private final int level;
    private final String name;
    private static final Map INSTANCES = new HashMap();
    public static final LockMode NONE = new LockMode(0, "NONE");
    public static final LockMode READ = new LockMode(5, "READ");
    public static final LockMode UPGRADE = new LockMode(10, "UPGRADE");
    public static final LockMode UPGRADE_NOWAIT = new LockMode(10, "UPGRADE_NOWAIT");
    public static final LockMode WRITE = new LockMode(10, "WRITE");
    public static final LockMode FORCE = new LockMode(15, "FORCE");

    private LockMode(int n, String string) {
        this.level = n;
        this.name = string;
    }

    public String toString() {
        return this.name;
    }

    public boolean greaterThan(LockMode lockMode) {
        return this.level > lockMode.level;
    }

    public boolean lessThan(LockMode lockMode) {
        return this.level < lockMode.level;
    }

    private Object readResolve() {
        return LockMode.parse(this.name);
    }

    public static LockMode parse(String string) {
        return (LockMode)INSTANCES.get(string);
    }

    static {
        INSTANCES.put(LockMode.NONE.name, NONE);
        INSTANCES.put(LockMode.READ.name, READ);
        INSTANCES.put(LockMode.UPGRADE.name, UPGRADE);
        INSTANCES.put(LockMode.UPGRADE_NOWAIT.name, UPGRADE_NOWAIT);
        INSTANCES.put(LockMode.WRITE.name, WRITE);
        INSTANCES.put(LockMode.FORCE.name, FORCE);
    }
}

