/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Iterator;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.HibernateIterator;
import org.hibernate.intercept.FieldInterceptionHelper;
import org.hibernate.lob.BlobImpl;
import org.hibernate.lob.ClobImpl;
import org.hibernate.lob.SerializableBlob;
import org.hibernate.lob.SerializableClob;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.type.AnyType;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.BigIntegerType;
import org.hibernate.type.BinaryType;
import org.hibernate.type.BlobType;
import org.hibernate.type.BooleanType;
import org.hibernate.type.ByteType;
import org.hibernate.type.CalendarDateType;
import org.hibernate.type.CalendarType;
import org.hibernate.type.CharArrayType;
import org.hibernate.type.CharacterArrayType;
import org.hibernate.type.CharacterType;
import org.hibernate.type.ClassType;
import org.hibernate.type.ClobType;
import org.hibernate.type.CompositeCustomType;
import org.hibernate.type.CurrencyType;
import org.hibernate.type.CustomType;
import org.hibernate.type.DateType;
import org.hibernate.type.DoubleType;
import org.hibernate.type.FloatType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.LocaleType;
import org.hibernate.type.LongType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.NullableType;
import org.hibernate.type.SerializableType;
import org.hibernate.type.ShortType;
import org.hibernate.type.StringType;
import org.hibernate.type.TextType;
import org.hibernate.type.TimeType;
import org.hibernate.type.TimeZoneType;
import org.hibernate.type.TimestampType;
import org.hibernate.type.TrueFalseType;
import org.hibernate.type.Type;
import org.hibernate.type.WrapperBinaryType;
import org.hibernate.type.YesNoType;
import org.hibernate.usertype.CompositeUserType;

public final class Hibernate {
    public static final NullableType LONG = new LongType();
    public static final NullableType SHORT = new ShortType();
    public static final NullableType INTEGER = new IntegerType();
    public static final NullableType BYTE = new ByteType();
    public static final NullableType FLOAT = new FloatType();
    public static final NullableType DOUBLE = new DoubleType();
    public static final NullableType CHARACTER = new CharacterType();
    public static final NullableType STRING = new StringType();
    public static final NullableType TIME = new TimeType();
    public static final NullableType DATE = new DateType();
    public static final NullableType TIMESTAMP = new TimestampType();
    public static final NullableType BOOLEAN = new BooleanType();
    public static final NullableType TRUE_FALSE = new TrueFalseType();
    public static final NullableType YES_NO = new YesNoType();
    public static final NullableType BIG_DECIMAL = new BigDecimalType();
    public static final NullableType BIG_INTEGER = new BigIntegerType();
    public static final NullableType BINARY = new BinaryType();
    public static final NullableType WRAPPER_BINARY = new WrapperBinaryType();
    public static final NullableType CHAR_ARRAY = new CharArrayType();
    public static final NullableType CHARACTER_ARRAY = new CharacterArrayType();
    public static final NullableType TEXT = new TextType();
    public static final Type BLOB = new BlobType();
    public static final Type CLOB = new ClobType();
    public static final NullableType CALENDAR = new CalendarType();
    public static final NullableType CALENDAR_DATE = new CalendarDateType();
    public static final NullableType LOCALE = new LocaleType();
    public static final NullableType CURRENCY = new CurrencyType();
    public static final NullableType TIMEZONE = new TimeZoneType();
    public static final NullableType CLASS = new ClassType();
    public static final NullableType SERIALIZABLE = new SerializableType(Serializable.class);
    public static final Type OBJECT = new AnyType();

    private Hibernate() {
        throw new UnsupportedOperationException();
    }

    public static Type serializable(Class clazz) {
        return new SerializableType(clazz);
    }

    public static Type any(Type type, Type type2) {
        return new AnyType(type, type2);
    }

    public static Type entity(Class clazz) {
        return new ManyToOneType(clazz.getName());
    }

    public static Type entity(String string) {
        return new ManyToOneType(string);
    }

    public static Type custom(Class clazz) throws HibernateException {
        return Hibernate.custom(clazz, null);
    }

    public static Type custom(Class clazz, String[] stringArray, String[] stringArray2) throws HibernateException {
        Properties properties = new Properties();
        for (int i = 0; i < stringArray.length; ++i) {
            properties.setProperty(stringArray[i], stringArray2[i]);
        }
        return Hibernate.custom(clazz, properties);
    }

    public static Type custom(Class clazz, Properties properties) throws HibernateException {
        if (CompositeUserType.class.isAssignableFrom(clazz)) {
            CompositeCustomType compositeCustomType = new CompositeCustomType(clazz, properties);
            return compositeCustomType;
        }
        CustomType customType = new CustomType(clazz, properties);
        return customType;
    }

    public static void initialize(Object object) throws HibernateException {
        if (object == null) {
            return;
        }
        if (object instanceof HibernateProxy) {
            ((HibernateProxy)object).getHibernateLazyInitializer().initialize();
        } else if (object instanceof PersistentCollection) {
            ((PersistentCollection)object).forceInitialization();
        }
    }

    public static boolean isInitialized(Object object) {
        if (object instanceof HibernateProxy) {
            return !((HibernateProxy)object).getHibernateLazyInitializer().isUninitialized();
        }
        if (object instanceof PersistentCollection) {
            return ((PersistentCollection)object).wasInitialized();
        }
        return true;
    }

    public static Class getClass(Object object) {
        if (object instanceof HibernateProxy) {
            return ((HibernateProxy)object).getHibernateLazyInitializer().getImplementation().getClass();
        }
        return object.getClass();
    }

    public static Blob createBlob(byte[] byArray) {
        return new SerializableBlob(new BlobImpl(byArray));
    }

    public static Blob createBlob(InputStream inputStream, int n) {
        return new SerializableBlob(new BlobImpl(inputStream, n));
    }

    public static Blob createBlob(InputStream inputStream) throws IOException {
        return new SerializableBlob(new BlobImpl(inputStream, inputStream.available()));
    }

    public static Clob createClob(String string) {
        return new SerializableClob(new ClobImpl(string));
    }

    public static Clob createClob(Reader reader, int n) {
        return new SerializableClob(new ClobImpl(reader, n));
    }

    public static void close(Iterator iterator) throws HibernateException {
        if (!(iterator instanceof HibernateIterator)) {
            throw new IllegalArgumentException("not a Hibernate iterator");
        }
        ((HibernateIterator)iterator).close();
    }

    public static boolean isPropertyInitialized(Object object, String string) {
        Object object2;
        Object object3;
        if (object instanceof HibernateProxy) {
            object3 = ((HibernateProxy)object).getHibernateLazyInitializer();
            if (object3.isUninitialized()) {
                return false;
            }
            object2 = object3.getImplementation();
        } else {
            object2 = object;
        }
        if (FieldInterceptionHelper.isInstrumented(object2)) {
            object3 = FieldInterceptionHelper.extractFieldInterceptor(object2);
            return object3 == null || object3.isInitialized(string);
        }
        return true;
    }
}

