/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public final class FlushMode
implements Serializable {
    private static final Map INSTANCES = new HashMap();
    private final int level;
    private final String name;
    public static final FlushMode NEVER = new FlushMode(0, "NEVER");
    public static final FlushMode MANUAL = new FlushMode(0, "MANUAL");
    public static final FlushMode COMMIT = new FlushMode(5, "COMMIT");
    public static final FlushMode AUTO = new FlushMode(10, "AUTO");
    public static final FlushMode ALWAYS = new FlushMode(20, "ALWAYS");

    private FlushMode(int n, String string) {
        this.level = n;
        this.name = string;
    }

    public String toString() {
        return this.name;
    }

    public boolean lessThan(FlushMode flushMode) {
        return this.level < flushMode.level;
    }

    public static boolean isManualFlushMode(FlushMode flushMode) {
        return FlushMode.MANUAL.level == flushMode.level;
    }

    private Object readResolve() {
        return INSTANCES.get(this.name);
    }

    public static FlushMode parse(String string) {
        return (FlushMode)INSTANCES.get(string);
    }

    static {
        INSTANCES.put(FlushMode.NEVER.name, NEVER);
        INSTANCES.put(FlushMode.MANUAL.name, MANUAL);
        INSTANCES.put(FlushMode.AUTO.name, AUTO);
        INSTANCES.put(FlushMode.ALWAYS.name, ALWAYS);
        INSTANCES.put(FlushMode.COMMIT.name, COMMIT);
    }
}

