/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading.tomcat;

import java.lang.instrument.ClassFileTransformer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.catalina.loader.ResourceEntry;
import org.apache.catalina.loader.WebappClassLoader;
import org.springframework.instrument.classloading.WeavingTransformer;

public class TomcatInstrumentableClassLoader
extends WebappClassLoader {
    private final WeavingTransformer weavingTransformer;

    public TomcatInstrumentableClassLoader() {
        this.weavingTransformer = new WeavingTransformer();
    }

    public TomcatInstrumentableClassLoader(ClassLoader classLoader) {
        super(classLoader);
        this.weavingTransformer = new WeavingTransformer(classLoader);
    }

    public void addTransformer(ClassFileTransformer classFileTransformer) {
        this.weavingTransformer.addTransformer(classFileTransformer);
    }

    public ClassLoader getThrowawayClassLoader() {
        WebappClassLoader webappClassLoader = new WebappClassLoader();
        TomcatInstrumentableClassLoader.shallowCopyFieldState((Object)this, webappClassLoader);
        return webappClassLoader;
    }

    protected ResourceEntry findResourceInternal(String string, String string2) {
        ResourceEntry resourceEntry = super.findResourceInternal(string, string2);
        if (resourceEntry != null && resourceEntry.binaryContent != null && string2.endsWith(".class")) {
            byte[] byArray = this.weavingTransformer.transformIfNecessary(string, resourceEntry.binaryContent);
            resourceEntry.binaryContent = byArray;
        }
        return resourceEntry;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(((Object)((Object)this)).getClass().getName());
        stringBuilder.append("\r\n");
        stringBuilder.append(super.toString());
        return stringBuilder.toString();
    }

    private static void shallowCopyFieldState(Object object, Object object2) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException("Source for field copy cannot be null");
        }
        if (object2 == null) {
            throw new IllegalArgumentException("Destination for field copy cannot be null");
        }
        Class clazz = TomcatInstrumentableClassLoader.findCommonAncestor(object.getClass(), object2.getClass());
        do {
            Field[] fieldArray = clazz.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers()) || field.getName().equals("resourceEntries")) continue;
                try {
                    field.setAccessible(true);
                    Object object3 = field.get(object);
                    field.set(object2, object3);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IllegalStateException("Shouldn't be illegal to access field '" + fieldArray[i].getName() + "': " + illegalAccessException);
                }
            }
        } while ((clazz = clazz.getSuperclass()) != null && clazz != Object.class);
    }

    private static Class findCommonAncestor(Class clazz, Class clazz2) throws IllegalArgumentException {
        Class clazz3;
        for (clazz3 = clazz; clazz3 != Object.class || clazz3 != null; clazz3 = clazz3.getSuperclass()) {
            if (!clazz3.isAssignableFrom(clazz2)) continue;
            return clazz3;
        }
        for (clazz3 = clazz2; clazz3 != Object.class || clazz3 != null; clazz3 = clazz3.getSuperclass()) {
            if (!clazz3.isAssignableFrom(clazz)) continue;
            return clazz3;
        }
        return null;
    }
}

