/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;

public class WeavingTransformer {
    private final ClassLoader classLoader;
    private final List<ClassFileTransformer> transformers = new ArrayList<ClassFileTransformer>();

    public WeavingTransformer() {
        this(null);
    }

    public WeavingTransformer(ClassLoader classLoader) {
        this.classLoader = classLoader != null ? classLoader : this.getDefaultClassLoader();
    }

    public void addTransformer(ClassFileTransformer classFileTransformer) {
        if (classFileTransformer == null) {
            throw new IllegalArgumentException("Transformer must not be null");
        }
        this.transformers.add(classFileTransformer);
    }

    public byte[] transformIfNecessary(String string, byte[] byArray) {
        String string2 = string.replace(".", "/");
        return this.transformIfNecessary(string, string2, byArray, null);
    }

    public byte[] transformIfNecessary(String string, String string2, byte[] byArray, ProtectionDomain protectionDomain) {
        byte[] byArray2 = byArray;
        for (ClassFileTransformer classFileTransformer : this.transformers) {
            try {
                byte[] byArray3 = classFileTransformer.transform(this.classLoader, string2, null, protectionDomain, byArray2);
                if (byArray3 == null) continue;
                byArray2 = byArray3;
            }
            catch (IllegalClassFormatException illegalClassFormatException) {
                throw new IllegalStateException("Class file transformation failed", illegalClassFormatException);
            }
        }
        return byArray2;
    }

    protected ClassLoader getDefaultClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        return classLoader;
    }
}

