/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.resourcepool;

import com.mchange.v2.async.AsynchronousRunner;
import com.mchange.v2.async.CarefulRunnableQueue;
import com.mchange.v2.async.Queuable;
import com.mchange.v2.async.RunnableQueue;
import com.mchange.v2.async.ThreadPoolAsynchronousRunner;
import com.mchange.v2.resourcepool.BasicResourcePool;
import com.mchange.v2.resourcepool.ResourcePool;
import com.mchange.v2.resourcepool.ResourcePoolException;
import com.mchange.v2.resourcepool.ResourcePoolFactory;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;

public class BasicResourcePoolFactory
extends ResourcePoolFactory {
    int start = -1;
    int min = 1;
    int max = 12;
    int inc = 3;
    int retry_attempts = -1;
    int retry_delay = 1000;
    long idle_resource_test_period = -1L;
    long max_age = -1L;
    long max_idle_time = -1L;
    long excess_max_idle_time = -1L;
    long destroy_overdue_resc_time = -1L;
    long expiration_enforcement_delay = -1L;
    boolean break_on_acquisition_failure = true;
    boolean debug_store_checkout_stacktrace = false;
    AsynchronousRunner taskRunner;
    boolean taskRunner_is_external;
    RunnableQueue asyncEventQueue;
    boolean asyncEventQueue_is_external;
    Timer timer;
    boolean timer_is_external;
    int default_num_task_threads;
    Set liveChildren;

    public static BasicResourcePoolFactory createNoEventSupportInstance(int n) {
        return BasicResourcePoolFactory.createNoEventSupportInstance(null, null, n);
    }

    public static BasicResourcePoolFactory createNoEventSupportInstance(AsynchronousRunner asynchronousRunner, Timer timer) {
        return BasicResourcePoolFactory.createNoEventSupportInstance(asynchronousRunner, timer, 3);
    }

    private static BasicResourcePoolFactory createNoEventSupportInstance(AsynchronousRunner asynchronousRunner, Timer timer, int n) {
        return new BasicResourcePoolFactory(asynchronousRunner, timer, n, true);
    }

    BasicResourcePoolFactory() {
        this(null, null, null);
    }

    BasicResourcePoolFactory(AsynchronousRunner asynchronousRunner, RunnableQueue runnableQueue, Timer timer) {
        this(asynchronousRunner, runnableQueue, timer, 3);
    }

    BasicResourcePoolFactory(int n) {
        this(null, null, null, n);
    }

    BasicResourcePoolFactory(AsynchronousRunner asynchronousRunner, Timer timer, int n, boolean bl) {
        this(asynchronousRunner, null, timer, n);
        if (bl) {
            this.asyncEventQueue_is_external = true;
        }
    }

    BasicResourcePoolFactory(AsynchronousRunner asynchronousRunner, RunnableQueue runnableQueue, Timer timer, int n) {
        this.taskRunner = asynchronousRunner;
        this.taskRunner_is_external = asynchronousRunner != null;
        this.asyncEventQueue = runnableQueue;
        this.asyncEventQueue_is_external = runnableQueue != null;
        this.timer = timer;
        this.timer_is_external = timer != null;
        this.default_num_task_threads = n;
    }

    private void createThreadResources() {
        if (!this.taskRunner_is_external) {
            this.taskRunner = new ThreadPoolAsynchronousRunner(this.default_num_task_threads, true);
            if (!this.asyncEventQueue_is_external) {
                this.asyncEventQueue = ((Queuable)this.taskRunner).asRunnableQueue();
            }
        }
        if (!this.asyncEventQueue_is_external) {
            this.asyncEventQueue = new CarefulRunnableQueue(true, false);
        }
        if (!this.timer_is_external) {
            this.timer = new Timer(true);
        }
        this.liveChildren = new HashSet();
    }

    private void destroyThreadResources() {
        if (!this.taskRunner_is_external) {
            this.taskRunner.close();
            this.taskRunner = null;
        }
        if (!this.asyncEventQueue_is_external) {
            this.asyncEventQueue.close();
            this.asyncEventQueue = null;
        }
        if (!this.timer_is_external) {
            this.timer.cancel();
            this.timer = null;
        }
        this.liveChildren = null;
    }

    synchronized void markBroken(BasicResourcePool basicResourcePool) {
        if (this.liveChildren != null) {
            this.liveChildren.remove(basicResourcePool);
            if (this.liveChildren.isEmpty()) {
                this.destroyThreadResources();
            }
        }
    }

    public synchronized void setStart(int n) throws ResourcePoolException {
        this.start = n;
    }

    public synchronized int getStart() throws ResourcePoolException {
        return this.start;
    }

    public synchronized void setMin(int n) throws ResourcePoolException {
        this.min = n;
    }

    public synchronized int getMin() throws ResourcePoolException {
        return this.min;
    }

    public synchronized void setMax(int n) throws ResourcePoolException {
        this.max = n;
    }

    public synchronized int getMax() throws ResourcePoolException {
        return this.max;
    }

    public synchronized void setIncrement(int n) throws ResourcePoolException {
        this.inc = n;
    }

    public synchronized int getIncrement() throws ResourcePoolException {
        return this.inc;
    }

    public synchronized void setAcquisitionRetryAttempts(int n) throws ResourcePoolException {
        this.retry_attempts = n;
    }

    public synchronized int getAcquisitionRetryAttempts() throws ResourcePoolException {
        return this.retry_attempts;
    }

    public synchronized void setAcquisitionRetryDelay(int n) throws ResourcePoolException {
        this.retry_delay = n;
    }

    public synchronized int getAcquisitionRetryDelay() throws ResourcePoolException {
        return this.retry_delay;
    }

    public synchronized void setIdleResourceTestPeriod(long l) {
        this.idle_resource_test_period = l;
    }

    public synchronized long getIdleResourceTestPeriod() {
        return this.idle_resource_test_period;
    }

    public synchronized void setResourceMaxAge(long l) throws ResourcePoolException {
        this.max_age = l;
    }

    public synchronized long getResourceMaxAge() throws ResourcePoolException {
        return this.max_age;
    }

    public synchronized void setResourceMaxIdleTime(long l) throws ResourcePoolException {
        this.max_idle_time = l;
    }

    public synchronized long getResourceMaxIdleTime() throws ResourcePoolException {
        return this.max_idle_time;
    }

    public synchronized void setExcessResourceMaxIdleTime(long l) throws ResourcePoolException {
        this.excess_max_idle_time = l;
    }

    public synchronized long getExcessResourceMaxIdleTime() throws ResourcePoolException {
        return this.excess_max_idle_time;
    }

    public synchronized long getDestroyOverdueResourceTime() throws ResourcePoolException {
        return this.destroy_overdue_resc_time;
    }

    public synchronized void setDestroyOverdueResourceTime(long l) throws ResourcePoolException {
        this.destroy_overdue_resc_time = l;
    }

    public synchronized void setExpirationEnforcementDelay(long l) throws ResourcePoolException {
        this.expiration_enforcement_delay = l;
    }

    public synchronized long getExpirationEnforcementDelay() throws ResourcePoolException {
        return this.expiration_enforcement_delay;
    }

    public synchronized void setBreakOnAcquisitionFailure(boolean bl) throws ResourcePoolException {
        this.break_on_acquisition_failure = bl;
    }

    public synchronized boolean getBreakOnAcquisitionFailure() throws ResourcePoolException {
        return this.break_on_acquisition_failure;
    }

    public synchronized void setDebugStoreCheckoutStackTrace(boolean bl) throws ResourcePoolException {
        this.debug_store_checkout_stacktrace = bl;
    }

    public synchronized boolean getDebugStoreCheckoutStackTrace() throws ResourcePoolException {
        return this.debug_store_checkout_stacktrace;
    }

    public synchronized ResourcePool createPool(ResourcePool.Manager manager) throws ResourcePoolException {
        if (this.liveChildren == null) {
            this.createThreadResources();
        }
        BasicResourcePool basicResourcePool = new BasicResourcePool(manager, this.start, this.min, this.max, this.inc, this.retry_attempts, this.retry_delay, this.idle_resource_test_period, this.max_age, this.max_idle_time, this.excess_max_idle_time, this.destroy_overdue_resc_time, this.expiration_enforcement_delay, this.break_on_acquisition_failure, this.debug_store_checkout_stacktrace, this.taskRunner, this.asyncEventQueue, this.timer, this);
        this.liveChildren.add(basicResourcePool);
        return basicResourcePool;
    }
}

