/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.log.log4j;

import com.mchange.v2.log.LogUtils;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.ResourceBundle;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class Log4jMLog
extends MLog {
    static final String CHECK_CLASS = "org.apache.log4j.Logger";
    MLogger global = null;
    static /* synthetic */ Class class$com$mchange$v2$log$log4j$Log4jMLog$Log4jMLogger;

    public Log4jMLog() throws ClassNotFoundException {
        Class.forName(CHECK_CLASS);
    }

    public MLogger getMLogger(String string) {
        Logger logger = Logger.getLogger((String)string);
        return new Log4jMLogger(logger);
    }

    public MLogger getMLogger(Class clazz) {
        Logger logger = Logger.getLogger((Class)clazz);
        return new Log4jMLogger(logger);
    }

    public MLogger getMLogger() {
        Logger logger = Logger.getRootLogger();
        return new Log4jMLogger(logger);
    }

    private static String formatMessage(String string, String string2, Object[] objectArray) {
        String string3;
        if (string2 == null) {
            if (objectArray == null) {
                return "";
            }
            return LogUtils.createParamsList(objectArray);
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string);
        if (resourceBundle != null && (string3 = resourceBundle.getString(string2)) != null) {
            string2 = string3;
        }
        return objectArray == null ? string2 : MessageFormat.format(string2, objectArray);
    }

    private static final class Log4jMLogger
    implements MLogger {
        static final String FQCN = (class$com$mchange$v2$log$log4j$Log4jMLog$Log4jMLogger == null ? (class$com$mchange$v2$log$log4j$Log4jMLog$Log4jMLogger = Log4jMLog.class$("com.mchange.v2.log.log4j.Log4jMLog$Log4jMLogger")) : class$com$mchange$v2$log$log4j$Log4jMLog$Log4jMLogger).getName();
        MLevel myLevel = null;
        volatile Logger logger;

        Log4jMLogger(Logger logger) {
            this.logger = logger;
        }

        private static MLevel guessMLevel(Level level) {
            if (level == null) {
                return null;
            }
            if (level == Level.ALL) {
                return MLevel.ALL;
            }
            if (level == Level.DEBUG) {
                return MLevel.FINEST;
            }
            if (level == Level.ERROR) {
                return MLevel.SEVERE;
            }
            if (level == Level.FATAL) {
                return MLevel.SEVERE;
            }
            if (level == Level.INFO) {
                return MLevel.INFO;
            }
            if (level == Level.OFF) {
                return MLevel.OFF;
            }
            if (level == Level.WARN) {
                return MLevel.WARNING;
            }
            throw new IllegalArgumentException("Unknown level: " + level);
        }

        private static Level level(MLevel mLevel) {
            if (mLevel == null) {
                return null;
            }
            if (mLevel == MLevel.ALL) {
                return Level.ALL;
            }
            if (mLevel == MLevel.CONFIG) {
                return Level.DEBUG;
            }
            if (mLevel == MLevel.FINE) {
                return Level.DEBUG;
            }
            if (mLevel == MLevel.FINER) {
                return Level.DEBUG;
            }
            if (mLevel == MLevel.FINEST) {
                return Level.DEBUG;
            }
            if (mLevel == MLevel.INFO) {
                return Level.INFO;
            }
            if (mLevel == MLevel.INFO) {
                return Level.OFF;
            }
            if (mLevel == MLevel.SEVERE) {
                return Level.ERROR;
            }
            if (mLevel == MLevel.WARNING) {
                return Level.WARN;
            }
            throw new IllegalArgumentException("Unknown MLevel: " + mLevel);
        }

        private static String createMessage(String string, String string2, String string3) {
            StringBuffer stringBuffer = new StringBuffer(511);
            stringBuffer.append("[class: ");
            stringBuffer.append(string);
            stringBuffer.append("; method: ");
            stringBuffer.append(string2);
            if (!string2.endsWith(")")) {
                stringBuffer.append("()");
            }
            stringBuffer.append("] ");
            stringBuffer.append(string3);
            return stringBuffer.toString();
        }

        private static String createMessage(String string, String string2) {
            StringBuffer stringBuffer = new StringBuffer(511);
            stringBuffer.append("[method: ");
            stringBuffer.append(string);
            if (!string.endsWith(")")) {
                stringBuffer.append("()");
            }
            stringBuffer.append("] ");
            stringBuffer.append(string2);
            return stringBuffer.toString();
        }

        public ResourceBundle getResourceBundle() {
            return null;
        }

        public String getResourceBundleName() {
            return null;
        }

        public void setFilter(Object object) throws SecurityException {
            this.warning("setFilter() not supported by MLogger " + this.getClass().getName());
        }

        public Object getFilter() {
            return null;
        }

        private void log(Level level, Object object, Throwable throwable) {
            this.logger.log(FQCN, (Priority)level, object, throwable);
        }

        public void log(MLevel mLevel, String string) {
            this.log(Log4jMLogger.level(mLevel), (Object)string, null);
        }

        public void log(MLevel mLevel, String string, Object object) {
            this.log(Log4jMLogger.level(mLevel), string != null ? MessageFormat.format(string, object) : null, null);
        }

        public void log(MLevel mLevel, String string, Object[] objectArray) {
            this.log(Log4jMLogger.level(mLevel), (Object)(string != null ? MessageFormat.format(string, objectArray) : null), null);
        }

        public void log(MLevel mLevel, String string, Throwable throwable) {
            this.log(Log4jMLogger.level(mLevel), (Object)string, throwable);
        }

        public void logp(MLevel mLevel, String string, String string2, String string3) {
            this.log(Log4jMLogger.level(mLevel), (Object)Log4jMLogger.createMessage(string, string2, string3), null);
        }

        public void logp(MLevel mLevel, String string, String string2, String string3, Object object) {
            this.log(Log4jMLogger.level(mLevel), (Object)Log4jMLogger.createMessage(string, string2, string3 != null ? MessageFormat.format(string3, object) : null), null);
        }

        public void logp(MLevel mLevel, String string, String string2, String string3, Object[] objectArray) {
            this.log(Log4jMLogger.level(mLevel), (Object)Log4jMLogger.createMessage(string, string2, string3 != null ? MessageFormat.format(string3, objectArray) : null), null);
        }

        public void logp(MLevel mLevel, String string, String string2, String string3, Throwable throwable) {
            this.log(Log4jMLogger.level(mLevel), (Object)Log4jMLogger.createMessage(string, string2, string3), throwable);
        }

        public void logrb(MLevel mLevel, String string, String string2, String string3, String string4) {
            this.log(Log4jMLogger.level(mLevel), (Object)Log4jMLogger.createMessage(string, string2, Log4jMLog.formatMessage(string3, string4, null)), null);
        }

        public void logrb(MLevel mLevel, String string, String string2, String string3, String string4, Object object) {
            this.log(Log4jMLogger.level(mLevel), (Object)Log4jMLogger.createMessage(string, string2, Log4jMLog.formatMessage(string3, string4, new Object[]{object})), null);
        }

        public void logrb(MLevel mLevel, String string, String string2, String string3, String string4, Object[] objectArray) {
            this.log(Log4jMLogger.level(mLevel), (Object)Log4jMLogger.createMessage(string, string2, Log4jMLog.formatMessage(string3, string4, objectArray)), null);
        }

        public void logrb(MLevel mLevel, String string, String string2, String string3, String string4, Throwable throwable) {
            this.log(Log4jMLogger.level(mLevel), (Object)Log4jMLogger.createMessage(string, string2, Log4jMLog.formatMessage(string3, string4, null)), throwable);
        }

        public void entering(String string, String string2) {
            this.log(Level.DEBUG, (Object)Log4jMLogger.createMessage(string, string2, "entering method."), null);
        }

        public void entering(String string, String string2, Object object) {
            this.log(Level.DEBUG, (Object)Log4jMLogger.createMessage(string, string2, "entering method... param: " + object.toString()), null);
        }

        public void entering(String string, String string2, Object[] objectArray) {
            this.log(Level.DEBUG, (Object)Log4jMLogger.createMessage(string, string2, "entering method... " + LogUtils.createParamsList(objectArray)), null);
        }

        public void exiting(String string, String string2) {
            this.log(Level.DEBUG, (Object)Log4jMLogger.createMessage(string, string2, "exiting method."), null);
        }

        public void exiting(String string, String string2, Object object) {
            this.log(Level.DEBUG, (Object)Log4jMLogger.createMessage(string, string2, "exiting method... result: " + object.toString()), null);
        }

        public void throwing(String string, String string2, Throwable throwable) {
            this.log(Level.DEBUG, (Object)Log4jMLogger.createMessage(string, string2, "throwing exception... "), throwable);
        }

        public void severe(String string) {
            this.log(Level.ERROR, (Object)string, null);
        }

        public void warning(String string) {
            this.log(Level.WARN, (Object)string, null);
        }

        public void info(String string) {
            this.log(Level.INFO, (Object)string, null);
        }

        public void config(String string) {
            this.log(Level.DEBUG, (Object)string, null);
        }

        public void fine(String string) {
            this.log(Level.DEBUG, (Object)string, null);
        }

        public void finer(String string) {
            this.log(Level.DEBUG, (Object)string, null);
        }

        public void finest(String string) {
            this.log(Level.DEBUG, (Object)string, null);
        }

        public synchronized void setLevel(MLevel mLevel) throws SecurityException {
            this.logger.setLevel(Log4jMLogger.level(mLevel));
            this.myLevel = mLevel;
        }

        public synchronized MLevel getLevel() {
            if (this.myLevel == null) {
                this.myLevel = Log4jMLogger.guessMLevel(this.logger.getLevel());
            }
            return this.myLevel;
        }

        public boolean isLoggable(MLevel mLevel) {
            return this.logger.isEnabledFor((Priority)Log4jMLogger.level(mLevel));
        }

        public String getName() {
            return this.logger.getName();
        }

        public void addHandler(Object object) throws SecurityException {
            if (!(object instanceof Appender)) {
                throw new IllegalArgumentException("The 'handler' " + object + " is not compatible with MLogger " + this);
            }
            this.logger.addAppender((Appender)object);
        }

        public void removeHandler(Object object) throws SecurityException {
            if (!(object instanceof Appender)) {
                throw new IllegalArgumentException("The 'handler' " + object + " is not compatible with MLogger " + this);
            }
            this.logger.removeAppender((Appender)object);
        }

        public Object[] getHandlers() {
            LinkedList linkedList = new LinkedList();
            Enumeration enumeration = this.logger.getAllAppenders();
            while (enumeration.hasMoreElements()) {
                linkedList.add(enumeration.nextElement());
            }
            return linkedList.toArray();
        }

        public void setUseParentHandlers(boolean bl) {
            this.logger.setAdditivity(bl);
        }

        public boolean getUseParentHandlers() {
            return this.logger.getAdditivity();
        }
    }
}

