/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.log.jdk14logging;

import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.util.DoubleWeakHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public final class Jdk14MLog
extends MLog {
    private static String[] UNKNOWN_ARRAY = new String[]{"UNKNOWN_CLASS", "UNKNOWN_METHOD"};
    private static final String CHECK_CLASS = "java.util.logging.Logger";
    private final Map namedLoggerMap = new DoubleWeakHashMap();
    MLogger global = null;

    public Jdk14MLog() throws ClassNotFoundException {
        Class.forName(CHECK_CLASS);
    }

    public synchronized MLogger getMLogger(String string) {
        MLogger mLogger = (MLogger)this.namedLoggerMap.get(string = string.intern());
        if (mLogger == null) {
            Logger logger = Logger.getLogger(string);
            mLogger = new Jdk14MLogger(logger);
            this.namedLoggerMap.put(string, mLogger);
        }
        return mLogger;
    }

    public synchronized MLogger getMLogger(Class clazz) {
        return Jdk14MLog.getLogger(clazz.getName());
    }

    public synchronized MLogger getMLogger() {
        if (this.global == null) {
            this.global = new Jdk14MLogger(LogManager.getLogManager().getLogger("global"));
        }
        return this.global;
    }

    private static String[] findCallingClassAndMethod() {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        int n = stackTraceElementArray.length;
        for (int i = 0; i < n; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            String string = stackTraceElement.getClassName();
            if (string == null || string.startsWith("com.mchange.v2.log.jdk14logging")) continue;
            return new String[]{stackTraceElement.getClassName(), stackTraceElement.getMethodName()};
        }
        return UNKNOWN_ARRAY;
    }

    private static final class Jdk14MLogger
    implements MLogger {
        volatile Logger logger;

        Jdk14MLogger(Logger logger) {
            this.logger = logger;
        }

        private static Level level(MLevel mLevel) {
            return (Level)mLevel.asJdk14Level();
        }

        public ResourceBundle getResourceBundle() {
            return this.logger.getResourceBundle();
        }

        public String getResourceBundleName() {
            return this.logger.getResourceBundleName();
        }

        public void setFilter(Object object) throws SecurityException {
            if (!(object instanceof Filter)) {
                throw new IllegalArgumentException("MLogger.setFilter( ... ) requires a java.util.logging.Filter. This is not enforced by the compiler only to permit building under jdk 1.3");
            }
            this.logger.setFilter((Filter)object);
        }

        public Object getFilter() {
            return this.logger.getFilter();
        }

        public void log(MLevel mLevel, String string) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(mLevel))) {
                return;
            }
            String[] stringArray = Jdk14MLog.findCallingClassAndMethod();
            this.logger.logp(Jdk14MLogger.level(mLevel), stringArray[0], stringArray[1], string);
        }

        public void log(MLevel mLevel, String string, Object object) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(mLevel))) {
                return;
            }
            String[] stringArray = Jdk14MLog.findCallingClassAndMethod();
            this.logger.logp(Jdk14MLogger.level(mLevel), stringArray[0], stringArray[1], string, object);
        }

        public void log(MLevel mLevel, String string, Object[] objectArray) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(mLevel))) {
                return;
            }
            String[] stringArray = Jdk14MLog.findCallingClassAndMethod();
            this.logger.logp(Jdk14MLogger.level(mLevel), stringArray[0], stringArray[1], string, objectArray);
        }

        public void log(MLevel mLevel, String string, Throwable throwable) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(mLevel))) {
                return;
            }
            String[] stringArray = Jdk14MLog.findCallingClassAndMethod();
            this.logger.logp(Jdk14MLogger.level(mLevel), stringArray[0], stringArray[1], string, throwable);
        }

        public void logp(MLevel mLevel, String string, String string2, String string3) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(mLevel))) {
                return;
            }
            if (string == null && string2 == null) {
                String[] stringArray = Jdk14MLog.findCallingClassAndMethod();
                string = stringArray[0];
                string2 = stringArray[1];
            }
            this.logger.logp(Jdk14MLogger.level(mLevel), string, string2, string3);
        }

        public void logp(MLevel mLevel, String string, String string2, String string3, Object object) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(mLevel))) {
                return;
            }
            if (string == null && string2 == null) {
                String[] stringArray = Jdk14MLog.findCallingClassAndMethod();
                string = stringArray[0];
                string2 = stringArray[1];
            }
            this.logger.logp(Jdk14MLogger.level(mLevel), string, string2, string3, object);
        }

        public void logp(MLevel mLevel, String string, String string2, String string3, Object[] objectArray) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(mLevel))) {
                return;
            }
            if (string == null && string2 == null) {
                String[] stringArray = Jdk14MLog.findCallingClassAndMethod();
                string = stringArray[0];
                string2 = stringArray[1];
            }
            this.logger.logp(Jdk14MLogger.level(mLevel), string, string2, string3, objectArray);
        }

        public void logp(MLevel mLevel, String string, String string2, String string3, Throwable throwable) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(mLevel))) {
                return;
            }
            if (string == null && string2 == null) {
                String[] stringArray = Jdk14MLog.findCallingClassAndMethod();
                string = stringArray[0];
                string2 = stringArray[1];
            }
            this.logger.logp(Jdk14MLogger.level(mLevel), string, string2, string3, throwable);
        }

        public void logrb(MLevel mLevel, String string, String string2, String string3, String string4) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(mLevel))) {
                return;
            }
            if (string == null && string2 == null) {
                String[] stringArray = Jdk14MLog.findCallingClassAndMethod();
                string = stringArray[0];
                string2 = stringArray[1];
            }
            this.logger.logrb(Jdk14MLogger.level(mLevel), string, string2, string3, string4);
        }

        public void logrb(MLevel mLevel, String string, String string2, String string3, String string4, Object object) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(mLevel))) {
                return;
            }
            if (string == null && string2 == null) {
                String[] stringArray = Jdk14MLog.findCallingClassAndMethod();
                string = stringArray[0];
                string2 = stringArray[1];
            }
            this.logger.logrb(Jdk14MLogger.level(mLevel), string, string2, string3, string4, object);
        }

        public void logrb(MLevel mLevel, String string, String string2, String string3, String string4, Object[] objectArray) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(mLevel))) {
                return;
            }
            if (string == null && string2 == null) {
                String[] stringArray = Jdk14MLog.findCallingClassAndMethod();
                string = stringArray[0];
                string2 = stringArray[1];
            }
            this.logger.logrb(Jdk14MLogger.level(mLevel), string, string2, string3, string4, objectArray);
        }

        public void logrb(MLevel mLevel, String string, String string2, String string3, String string4, Throwable throwable) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(mLevel))) {
                return;
            }
            if (string == null && string2 == null) {
                String[] stringArray = Jdk14MLog.findCallingClassAndMethod();
                string = stringArray[0];
                string2 = stringArray[1];
            }
            this.logger.logrb(Jdk14MLogger.level(mLevel), string, string2, string3, string4, throwable);
        }

        public void entering(String string, String string2) {
            if (!this.logger.isLoggable(Level.FINER)) {
                return;
            }
            this.logger.entering(string, string2);
        }

        public void entering(String string, String string2, Object object) {
            if (!this.logger.isLoggable(Level.FINER)) {
                return;
            }
            this.logger.entering(string, string2, object);
        }

        public void entering(String string, String string2, Object[] objectArray) {
            if (!this.logger.isLoggable(Level.FINER)) {
                return;
            }
            this.logger.entering(string, string2, objectArray);
        }

        public void exiting(String string, String string2) {
            if (!this.logger.isLoggable(Level.FINER)) {
                return;
            }
            this.logger.exiting(string, string2);
        }

        public void exiting(String string, String string2, Object object) {
            if (!this.logger.isLoggable(Level.FINER)) {
                return;
            }
            this.logger.exiting(string, string2, object);
        }

        public void throwing(String string, String string2, Throwable throwable) {
            if (!this.logger.isLoggable(Level.FINER)) {
                return;
            }
            this.logger.throwing(string, string2, throwable);
        }

        public void severe(String string) {
            if (!this.logger.isLoggable(Level.SEVERE)) {
                return;
            }
            String[] stringArray = Jdk14MLog.findCallingClassAndMethod();
            this.logger.logp(Level.SEVERE, stringArray[0], stringArray[1], string);
        }

        public void warning(String string) {
            if (!this.logger.isLoggable(Level.WARNING)) {
                return;
            }
            String[] stringArray = Jdk14MLog.findCallingClassAndMethod();
            this.logger.logp(Level.WARNING, stringArray[0], stringArray[1], string);
        }

        public void info(String string) {
            if (!this.logger.isLoggable(Level.INFO)) {
                return;
            }
            String[] stringArray = Jdk14MLog.findCallingClassAndMethod();
            this.logger.logp(Level.INFO, stringArray[0], stringArray[1], string);
        }

        public void config(String string) {
            if (!this.logger.isLoggable(Level.CONFIG)) {
                return;
            }
            String[] stringArray = Jdk14MLog.findCallingClassAndMethod();
            this.logger.logp(Level.CONFIG, stringArray[0], stringArray[1], string);
        }

        public void fine(String string) {
            if (!this.logger.isLoggable(Level.FINE)) {
                return;
            }
            String[] stringArray = Jdk14MLog.findCallingClassAndMethod();
            this.logger.logp(Level.FINE, stringArray[0], stringArray[1], string);
        }

        public void finer(String string) {
            if (!this.logger.isLoggable(Level.FINER)) {
                return;
            }
            String[] stringArray = Jdk14MLog.findCallingClassAndMethod();
            this.logger.logp(Level.FINER, stringArray[0], stringArray[1], string);
        }

        public void finest(String string) {
            if (!this.logger.isLoggable(Level.FINEST)) {
                return;
            }
            String[] stringArray = Jdk14MLog.findCallingClassAndMethod();
            this.logger.logp(Level.FINEST, stringArray[0], stringArray[1], string);
        }

        public void setLevel(MLevel mLevel) throws SecurityException {
            this.logger.setLevel(Jdk14MLogger.level(mLevel));
        }

        public MLevel getLevel() {
            return MLevel.fromIntValue(this.logger.getLevel().intValue());
        }

        public boolean isLoggable(MLevel mLevel) {
            return this.logger.isLoggable(Jdk14MLogger.level(mLevel));
        }

        public String getName() {
            return this.logger.getName();
        }

        public void addHandler(Object object) throws SecurityException {
            if (!(object instanceof Handler)) {
                throw new IllegalArgumentException("MLogger.addHandler( ... ) requires a java.util.logging.Handler. This is not enforced by the compiler only to permit building under jdk 1.3");
            }
            this.logger.addHandler((Handler)object);
        }

        public void removeHandler(Object object) throws SecurityException {
            if (!(object instanceof Handler)) {
                throw new IllegalArgumentException("MLogger.removeHandler( ... ) requires a java.util.logging.Handler. This is not enforced by the compiler only to permit building under jdk 1.3");
            }
            this.logger.removeHandler((Handler)object);
        }

        public Object[] getHandlers() {
            return this.logger.getHandlers();
        }

        public void setUseParentHandlers(boolean bl) {
            this.logger.setUseParentHandlers(bl);
        }

        public boolean getUseParentHandlers() {
            return this.logger.getUseParentHandlers();
        }
    }
}

