/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.cfg;

import com.mchange.v2.cfg.MultiPropertiesConfig;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class BasicMultiPropertiesConfig
extends MultiPropertiesConfig {
    String[] rps;
    Map propsByResourcePaths = new HashMap();
    Map propsByPrefixes;
    Properties propsByKey;
    static /* synthetic */ Class class$com$mchange$v2$cfg$MultiPropertiesConfig;
    static /* synthetic */ Class class$com$mchange$v2$cfg$BasicMultiPropertiesConfig;

    public BasicMultiPropertiesConfig(String[] stringArray) {
        this(stringArray, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicMultiPropertiesConfig(String[] stringArray, MLogger mLogger) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if ("/".equals(string)) {
                try {
                    this.propsByResourcePaths.put(string, System.getProperties());
                    arrayList.add(string);
                }
                catch (SecurityException securityException) {
                    if (mLogger != null) {
                        if (!mLogger.isLoggable(MLevel.WARNING)) continue;
                        mLogger.log(MLevel.WARNING, "Read of system Properties blocked -- ignoring any configuration via System properties, and using Empty Properties! (But any configuration via a resource properties files is still okay!)", securityException);
                        continue;
                    }
                    System.err.println("Read of system Properties blocked -- ignoring any configuration via System properties, and using Empty Properties! (But any configuration via a resource properties files is still okay!)");
                    securityException.printStackTrace();
                }
                continue;
            }
            Properties properties = new Properties();
            InputStream inputStream = (class$com$mchange$v2$cfg$MultiPropertiesConfig == null ? BasicMultiPropertiesConfig.class$("com.mchange.v2.cfg.MultiPropertiesConfig") : class$com$mchange$v2$cfg$MultiPropertiesConfig).getResourceAsStream(string);
            if (inputStream != null) {
                try {
                    properties.load(inputStream);
                    this.propsByResourcePaths.put(string, properties);
                    arrayList.add(string);
                    continue;
                }
                catch (IOException iOException) {
                    if (mLogger != null) {
                        if (!mLogger.isLoggable(MLevel.WARNING)) continue;
                        mLogger.log(MLevel.WARNING, "An IOException occurred while loading configuration properties from resource path '" + string + "'.", iOException);
                        continue;
                    }
                    iOException.printStackTrace();
                    continue;
                }
                finally {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        if (mLogger != null) {
                            if (mLogger.isLoggable(MLevel.WARNING)) {
                                mLogger.log(MLevel.WARNING, "An IOException occurred while closing InputStream from resource path '" + string + "'.", iOException);
                            }
                        }
                        iOException.printStackTrace();
                    }
                }
            }
            if (mLogger == null || !mLogger.isLoggable(MLevel.FINE)) continue;
            mLogger.fine("Configuration properties not found at ResourcePath '" + string + "'. [logger name: " + mLogger.getName() + ']');
        }
        this.rps = arrayList.toArray(new String[arrayList.size()]);
        this.propsByPrefixes = Collections.unmodifiableMap(BasicMultiPropertiesConfig.extractPrefixMapFromRsrcPathMap(this.rps, this.propsByResourcePaths));
        this.propsByResourcePaths = Collections.unmodifiableMap(this.propsByResourcePaths);
        this.propsByKey = BasicMultiPropertiesConfig.extractPropsByKey(this.rps, this.propsByResourcePaths);
    }

    private static String extractPrefix(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return null;
        }
        return string.substring(0, n);
    }

    private static Properties findProps(String string, Map map) {
        Properties properties = (Properties)map.get(string);
        return properties;
    }

    private static Properties extractPropsByKey(String[] stringArray, Map map) {
        Properties properties = new Properties();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            Properties properties2 = BasicMultiPropertiesConfig.findProps(string, map);
            if (properties2 == null) {
                System.err.println("Could not find loaded properties for resource path: " + string);
                continue;
            }
            Iterator<Object> iterator = properties2.keySet().iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof String)) {
                    System.err.println((class$com$mchange$v2$cfg$BasicMultiPropertiesConfig == null ? BasicMultiPropertiesConfig.class$("com.mchange.v2.cfg.BasicMultiPropertiesConfig") : class$com$mchange$v2$cfg$BasicMultiPropertiesConfig).getName() + ": " + "Properties object found at resource path " + ("/".equals(string) ? "[system properties]" : "'" + string + "'") + "' contains a key that is not a String: " + object);
                    System.err.println("Skipping...");
                    continue;
                }
                Object object2 = properties2.get(object);
                if (object2 != null && !(object2 instanceof String)) {
                    System.err.println((class$com$mchange$v2$cfg$BasicMultiPropertiesConfig == null ? BasicMultiPropertiesConfig.class$("com.mchange.v2.cfg.BasicMultiPropertiesConfig") : class$com$mchange$v2$cfg$BasicMultiPropertiesConfig).getName() + ": " + "Properties object found at resource path " + ("/".equals(string) ? "[system properties]" : "'" + string + "'") + " contains a value that is not a String: " + object2);
                    System.err.println("Skipping...");
                    continue;
                }
                String string2 = (String)object;
                String string3 = (String)object2;
                properties.put(string2, string3);
            }
        }
        return properties;
    }

    private static Map extractPrefixMapFromRsrcPathMap(String[] stringArray, Map map) {
        HashMap<String, Properties> hashMap = new HashMap<String, Properties>();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            Properties properties = BasicMultiPropertiesConfig.findProps(string, map);
            if (properties == null) {
                System.err.println((class$com$mchange$v2$cfg$BasicMultiPropertiesConfig == null ? BasicMultiPropertiesConfig.class$("com.mchange.v2.cfg.BasicMultiPropertiesConfig") : class$com$mchange$v2$cfg$BasicMultiPropertiesConfig).getName() + " -- Could not find loaded properties for resource path: " + string);
                continue;
            }
            Iterator<Object> iterator = properties.keySet().iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof String)) {
                    System.err.println((class$com$mchange$v2$cfg$BasicMultiPropertiesConfig == null ? BasicMultiPropertiesConfig.class$("com.mchange.v2.cfg.BasicMultiPropertiesConfig") : class$com$mchange$v2$cfg$BasicMultiPropertiesConfig).getName() + ": " + "Properties object found at resource path " + ("/".equals(string) ? "[system properties]" : "'" + string + "'") + "' contains a key that is not a String: " + object);
                    System.err.println("Skipping...");
                    continue;
                }
                String string2 = (String)object;
                String string3 = BasicMultiPropertiesConfig.extractPrefix(string2);
                while (string3 != null) {
                    Properties properties2 = (Properties)hashMap.get(string3);
                    if (properties2 == null) {
                        properties2 = new Properties();
                        hashMap.put(string3, properties2);
                    }
                    properties2.put(string2, properties.get(string2));
                    string3 = BasicMultiPropertiesConfig.extractPrefix(string3);
                }
            }
        }
        return hashMap;
    }

    public String[] getPropertiesResourcePaths() {
        return (String[])this.rps.clone();
    }

    public Properties getPropertiesByResourcePath(String string) {
        Properties properties = (Properties)this.propsByResourcePaths.get(string);
        return properties == null ? new Properties() : properties;
    }

    public Properties getPropertiesByPrefix(String string) {
        Properties properties = (Properties)this.propsByPrefixes.get(string);
        return properties == null ? new Properties() : properties;
    }

    public String getProperty(String string) {
        return this.propsByKey.getProperty(string);
    }
}

