/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.stmt;

import com.mchange.v1.db.sql.StatementUtils;
import com.mchange.v2.async.AsynchronousRunner;
import com.mchange.v2.c3p0.stmt.StatementCacheKey;
import com.mchange.v2.io.IndentedWriter;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.sql.SqlUtils;
import com.mchange.v2.util.ResourceClosedException;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class GooGooStatementCache {
    private static final MLogger logger = MLog.getLogger(GooGooStatementCache.class);
    private static final int DESTROY_NEVER = 0;
    private static final int DESTROY_IF_CHECKED_IN = 1;
    private static final int DESTROY_IF_CHECKED_OUT = 2;
    private static final int DESTROY_ALWAYS = 3;
    ConnectionStatementManager cxnStmtMgr;
    HashMap stmtToKey = new HashMap();
    HashMap keyToKeyRec = new HashMap();
    HashSet checkedOut = new HashSet();
    AsynchronousRunner blockingTaskAsyncRunner;
    HashSet removalPending = new HashSet();

    public GooGooStatementCache(AsynchronousRunner asynchronousRunner) {
        this.blockingTaskAsyncRunner = asynchronousRunner;
        this.cxnStmtMgr = this.createConnectionStatementManager();
    }

    public synchronized int getNumStatements() {
        return this.isClosed() ? -1 : this.countCachedStatements();
    }

    public synchronized int getNumStatementsCheckedOut() {
        return this.isClosed() ? -1 : this.checkedOut.size();
    }

    public synchronized int getNumConnectionsWithCachedStatements() {
        return this.isClosed() ? -1 : this.cxnStmtMgr.getNumConnectionsWithCachedStatements();
    }

    public synchronized String dumpStatementCacheStatus() {
        if (this.isClosed()) {
            return this + "status: Closed.";
        }
        StringWriter stringWriter = new StringWriter(2048);
        IndentedWriter indentedWriter = new IndentedWriter(stringWriter);
        try {
            indentedWriter.print(this);
            indentedWriter.println(" status:");
            indentedWriter.upIndent();
            indentedWriter.println("core stats:");
            indentedWriter.upIndent();
            indentedWriter.print("num cached statements: ");
            indentedWriter.println(this.countCachedStatements());
            indentedWriter.print("num cached statements in use: ");
            indentedWriter.println(this.checkedOut.size());
            indentedWriter.print("num connections with cached statements: ");
            indentedWriter.println(this.cxnStmtMgr.getNumConnectionsWithCachedStatements());
            indentedWriter.downIndent();
            indentedWriter.println("cached statement dump:");
            indentedWriter.upIndent();
            Iterator iterator = this.cxnStmtMgr.connectionSet().iterator();
            while (iterator.hasNext()) {
                Connection connection = (Connection)iterator.next();
                indentedWriter.print(connection);
                indentedWriter.println(':');
                indentedWriter.upIndent();
                Iterator iterator2 = this.cxnStmtMgr.statementSet(connection).iterator();
                while (iterator2.hasNext()) {
                    indentedWriter.println(iterator2.next());
                }
                indentedWriter.downIndent();
            }
            indentedWriter.downIndent();
            indentedWriter.downIndent();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, "Huh? We've seen an IOException writing to s StringWriter?!", iOException);
            }
            return iOException.toString();
        }
    }

    abstract ConnectionStatementManager createConnectionStatementManager();

    public synchronized Object checkoutStatement(Connection connection, Method method, Object[] objectArray) throws SQLException, ResourceClosedException {
        try {
            Object object = null;
            StatementCacheKey statementCacheKey = StatementCacheKey.find(connection, method, objectArray);
            LinkedList linkedList = this.checkoutQueue(statementCacheKey);
            if (linkedList == null || linkedList.isEmpty()) {
                object = this.acquireStatement(connection, method, objectArray);
                if (this.prepareAssimilateNewStatement(connection)) {
                    this.assimilateNewCheckedOutStatement(statementCacheKey, connection, object);
                }
            } else {
                logger.finest(this.getClass().getName() + " ----> CACHE HIT");
                object = linkedList.get(0);
                linkedList.remove(0);
                if (!this.checkedOut.add(object)) {
                    throw new RuntimeException("Internal inconsistency: Checking out a statement marked as already checked out!");
                }
                this.removeStatementFromDeathmarches(object, connection);
            }
            if (logger.isLoggable(MLevel.FINEST)) {
                logger.finest("checkoutStatement: " + this.statsString());
            }
            return object;
        }
        catch (NullPointerException nullPointerException) {
            if (this.checkedOut == null) {
                if (logger.isLoggable(MLevel.FINE)) {
                    logger.log(MLevel.FINE, "A client attempted to work with a closed Statement cache, provoking a NullPointerException. c3p0 recovers, but this should be rare.", nullPointerException);
                }
                throw new ResourceClosedException(nullPointerException);
            }
            throw nullPointerException;
        }
    }

    public synchronized void checkinStatement(Object object) throws SQLException {
        if (this.checkedOut == null) {
            this.synchronousDestroyStatement(object);
            return;
        }
        if (!this.checkedOut.remove(object)) {
            if (!this.ourResource(object)) {
                this.destroyStatement(object);
            }
            return;
        }
        try {
            this.refreshStatement((PreparedStatement)object);
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.INFO)) {
                logger.log(MLevel.INFO, "Problem with checked-in Statement, discarding.", exception);
            }
            this.checkedOut.add(object);
            this.removeStatement(object, 3);
            return;
        }
        StatementCacheKey statementCacheKey = (StatementCacheKey)this.stmtToKey.get(object);
        if (statementCacheKey == null) {
            throw new RuntimeException("Internal inconsistency: A checked-out statement has no key associated with it!");
        }
        LinkedList linkedList = this.checkoutQueue(statementCacheKey);
        linkedList.add(object);
        this.addStatementToDeathmarches(object, statementCacheKey.physicalConnection);
        if (logger.isLoggable(MLevel.FINEST)) {
            logger.finest("checkinStatement(): " + this.statsString());
        }
    }

    public synchronized void checkinAll(Connection connection) throws SQLException {
        Set set = this.cxnStmtMgr.statementSet(connection);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!this.checkedOut.contains(e)) continue;
                this.checkinStatement(e);
            }
        }
        if (logger.isLoggable(MLevel.FINEST)) {
            logger.log(MLevel.FINEST, "checkinAll(): " + this.statsString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll(Connection connection) throws SQLException {
        if (!this.isClosed()) {
            Set set;
            if (logger.isLoggable(MLevel.FINEST)) {
                logger.log(MLevel.FINEST, "ENTER METHOD: closeAll( " + connection + " )! -- num_connections: " + this.cxnStmtMgr.getNumConnectionsWithCachedStatements());
            }
            HashSet hashSet = null;
            Object object = this;
            synchronized (object) {
                set = this.cxnStmtMgr.statementSet(connection);
                if (set != null) {
                    hashSet = new HashSet(set);
                    Iterator iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        this.removeStatement(e, 0);
                    }
                }
            }
            if (hashSet != null) {
                object = hashSet.iterator();
                while (object.hasNext()) {
                    set = object.next();
                    this.synchronousDestroyStatement(set);
                }
            }
            if (logger.isLoggable(MLevel.FINEST)) {
                logger.finest("closeAll(): " + this.statsString());
            }
        }
    }

    public synchronized void close() throws SQLException {
        if (!this.isClosed()) {
            Iterator iterator = this.stmtToKey.keySet().iterator();
            while (iterator.hasNext()) {
                this.synchronousDestroyStatement(iterator.next());
            }
            this.cxnStmtMgr = null;
            this.stmtToKey = null;
            this.keyToKeyRec = null;
            this.checkedOut = null;
        } else if (logger.isLoggable(MLevel.FINE)) {
            logger.log(MLevel.FINE, this + ": duplicate call to close() [not harmful! -- debug only!]", new Exception("DUPLICATE CLOSE DEBUG STACK TRACE."));
        }
    }

    public synchronized boolean isClosed() {
        return this.cxnStmtMgr == null;
    }

    private void destroyStatement(Object object) {
        class StatementCloseTask
        implements Runnable {
            private final /* synthetic */ Object val$pstmt;

            StatementCloseTask(Object object) {
                this.val$pstmt = object;
            }

            public void run() {
                StatementUtils.attemptClose((PreparedStatement)this.val$pstmt);
            }
        }
        StatementCloseTask statementCloseTask = new StatementCloseTask(object);
        this.blockingTaskAsyncRunner.postRunnable(statementCloseTask);
    }

    private void synchronousDestroyStatement(Object object) {
        StatementUtils.attemptClose((PreparedStatement)object);
    }

    abstract boolean prepareAssimilateNewStatement(Connection var1);

    abstract void addStatementToDeathmarches(Object var1, Connection var2);

    abstract void removeStatementFromDeathmarches(Object var1, Connection var2);

    final int countCachedStatements() {
        return this.stmtToKey.size();
    }

    private void assimilateNewCheckedOutStatement(StatementCacheKey statementCacheKey, Connection connection, Object object) {
        this.stmtToKey.put(object, statementCacheKey);
        HashSet hashSet = this.keySet(statementCacheKey);
        if (hashSet == null) {
            this.keyToKeyRec.put(statementCacheKey, new KeyRec());
        } else {
            if (logger.isLoggable(MLevel.INFO)) {
                logger.info("Multiply prepared statement! " + statementCacheKey.stmtText);
            }
            if (logger.isLoggable(MLevel.FINE)) {
                logger.fine("(The same statement has already been prepared by this Connection, and that other instance has not yet been closed, so the statement pool has to prepare a second PreparedStatement object rather than reusing the previously-cached Statement. The new Statement will be cached, in case you frequently need multiple copies of this Statement.)");
            }
        }
        this.keySet(statementCacheKey).add(object);
        this.cxnStmtMgr.addStatementForConnection(object, connection);
        if (logger.isLoggable(MLevel.FINEST)) {
            logger.finest("cxnStmtMgr.statementSet( " + connection + " ).size(): " + this.cxnStmtMgr.statementSet(connection).size());
        }
        this.checkedOut.add(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStatement(Object object, int n) {
        boolean bl;
        boolean bl2;
        Object object2 = this.removalPending;
        synchronized (object2) {
            if (this.removalPending.contains(object)) {
                return;
            }
            this.removalPending.add(object);
        }
        object2 = (StatementCacheKey)this.stmtToKey.remove(object);
        this.removeFromKeySet((StatementCacheKey)object2, object);
        Connection connection = ((StatementCacheKey)object2).physicalConnection;
        boolean bl3 = bl2 = !this.checkedOut.contains(object);
        if (bl2) {
            this.removeStatementFromDeathmarches(object, connection);
            this.removeFromCheckoutQueue((StatementCacheKey)object2, object);
            if ((n & 1) != 0) {
                this.destroyStatement(object);
            }
        } else {
            this.checkedOut.remove(object);
            if ((n & 2) != 0) {
                this.destroyStatement(object);
            }
        }
        if (!(bl = this.cxnStmtMgr.removeStatementForConnection(object, connection)) && logger.isLoggable(MLevel.WARNING)) {
            logger.log(MLevel.WARNING, this + " removed a statement that apparently wasn't in a statement set!!!", new Exception("LOG STACK TRACE"));
        }
        HashSet hashSet = this.removalPending;
        synchronized (hashSet) {
            this.removalPending.remove(object);
        }
    }

    private Object acquireStatement(Connection connection, Method method, Object[] objectArray) throws SQLException {
        try {
            Object[] objectArray2 = new Object[1];
            SQLException[] sQLExceptionArray = new SQLException[1];
            class StmtAcquireTask
            implements Runnable {
                private final /* synthetic */ Object[] val$outHolder;
                private final /* synthetic */ Method val$stmtProducingMethod;
                private final /* synthetic */ Connection val$pConn;
                private final /* synthetic */ Object[] val$args;
                private final /* synthetic */ SQLException[] val$exceptionHolder;

                StmtAcquireTask(Object[] objectArray, Method method, Connection connection, Object[] objectArray2, SQLException[] sQLExceptionArray) {
                    this.val$outHolder = objectArray;
                    this.val$stmtProducingMethod = method;
                    this.val$pConn = connection;
                    this.val$args = objectArray2;
                    this.val$exceptionHolder = sQLExceptionArray;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        this.val$outHolder[0] = this.val$stmtProducingMethod.invoke((Object)this.val$pConn, this.val$args);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Throwable throwable = invocationTargetException.getTargetException();
                        this.val$exceptionHolder[0] = throwable instanceof SQLException ? (SQLException)throwable : SqlUtils.toSQLException(throwable);
                    }
                    catch (Exception exception) {
                        this.val$exceptionHolder[0] = SqlUtils.toSQLException(exception);
                    }
                    finally {
                        GooGooStatementCache gooGooStatementCache = GooGooStatementCache.this;
                        synchronized (gooGooStatementCache) {
                            GooGooStatementCache.this.notifyAll();
                        }
                    }
                }
            }
            StmtAcquireTask stmtAcquireTask = new StmtAcquireTask(objectArray2, method, connection, objectArray, sQLExceptionArray);
            this.blockingTaskAsyncRunner.postRunnable(stmtAcquireTask);
            while (objectArray2[0] == null && sQLExceptionArray[0] == null) {
                this.wait();
            }
            if (sQLExceptionArray[0] != null) {
                throw sQLExceptionArray[0];
            }
            Object object = objectArray2[0];
            return object;
        }
        catch (InterruptedException interruptedException) {
            throw SqlUtils.toSQLException(interruptedException);
        }
    }

    private KeyRec keyRec(StatementCacheKey statementCacheKey) {
        return (KeyRec)this.keyToKeyRec.get(statementCacheKey);
    }

    private HashSet keySet(StatementCacheKey statementCacheKey) {
        KeyRec keyRec = this.keyRec(statementCacheKey);
        return keyRec == null ? null : keyRec.allStmts;
    }

    private boolean removeFromKeySet(StatementCacheKey statementCacheKey, Object object) {
        HashSet hashSet = this.keySet(statementCacheKey);
        boolean bl = hashSet.remove(object);
        if (hashSet.isEmpty() && this.checkoutQueue(statementCacheKey).isEmpty()) {
            this.keyToKeyRec.remove(statementCacheKey);
        }
        return bl;
    }

    private LinkedList checkoutQueue(StatementCacheKey statementCacheKey) {
        KeyRec keyRec = this.keyRec(statementCacheKey);
        return keyRec == null ? null : keyRec.checkoutQueue;
    }

    private boolean removeFromCheckoutQueue(StatementCacheKey statementCacheKey, Object object) {
        LinkedList linkedList = this.checkoutQueue(statementCacheKey);
        boolean bl = linkedList.remove(object);
        if (linkedList.isEmpty() && this.keySet(statementCacheKey).isEmpty()) {
            this.keyToKeyRec.remove(statementCacheKey);
        }
        return bl;
    }

    private boolean ourResource(Object object) {
        return this.stmtToKey.keySet().contains(object);
    }

    private void refreshStatement(PreparedStatement preparedStatement) throws Exception {
        preparedStatement.clearParameters();
    }

    private void printStats() {
        int n = this.countCachedStatements();
        int n2 = this.checkedOut.size();
        int n3 = this.cxnStmtMgr.getNumConnectionsWithCachedStatements();
        int n4 = this.keyToKeyRec.size();
        System.err.print(this.getClass().getName() + " stats -- ");
        System.err.print("total size: " + n);
        System.err.print("; checked out: " + n2);
        System.err.print("; num connections: " + n3);
        System.err.println("; num keys: " + n4);
    }

    private String statsString() {
        int n = this.countCachedStatements();
        int n2 = this.checkedOut.size();
        int n3 = this.cxnStmtMgr.getNumConnectionsWithCachedStatements();
        int n4 = this.keyToKeyRec.size();
        StringBuffer stringBuffer = new StringBuffer(255);
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" stats -- ");
        stringBuffer.append("total size: ");
        stringBuffer.append(n);
        stringBuffer.append("; checked out: ");
        stringBuffer.append(n2);
        stringBuffer.append("; num connections: ");
        stringBuffer.append(n3);
        stringBuffer.append("; num keys: ");
        stringBuffer.append(n4);
        return stringBuffer.toString();
    }

    protected static abstract class ConnectionStatementManager {
        Map cxnToStmtSets = new HashMap();

        protected ConnectionStatementManager() {
        }

        public int getNumConnectionsWithCachedStatements() {
            return this.cxnToStmtSets.size();
        }

        public Set connectionSet() {
            return this.cxnToStmtSets.keySet();
        }

        public Set statementSet(Connection connection) {
            return (Set)this.cxnToStmtSets.get(connection);
        }

        public int getNumStatementsForConnection(Connection connection) {
            Set set = this.statementSet(connection);
            return set == null ? 0 : set.size();
        }

        public void addStatementForConnection(Object object, Connection connection) {
            HashSet<Object> hashSet = this.statementSet(connection);
            if (hashSet == null) {
                hashSet = new HashSet<Object>();
                this.cxnToStmtSets.put(connection, hashSet);
            }
            hashSet.add(object);
        }

        public boolean removeStatementForConnection(Object object, Connection connection) {
            boolean bl;
            Set set = this.statementSet(connection);
            if (set != null) {
                bl = set.remove(object);
                if (set.isEmpty()) {
                    this.cxnToStmtSets.remove(connection);
                }
            } else {
                bl = false;
            }
            return bl;
        }
    }

    protected class Deathmarch {
        TreeMap longsToStmts = new TreeMap();
        HashMap stmtsToLongs = new HashMap();
        long last_long = -1L;

        protected Deathmarch() {
        }

        public void deathmarchStatement(Object object) {
            Long l = (Long)this.stmtsToLongs.get(object);
            if (l != null) {
                throw new RuntimeException("Internal inconsistency: A statement is being double-deathmatched. no checked-out statements should be in a deathmarch already; no already checked-in statement should be deathmarched!");
            }
            l = this.getNextLong();
            this.stmtsToLongs.put(object, l);
            this.longsToStmts.put(l, object);
        }

        public void undeathmarchStatement(Object object) {
            Long l = (Long)this.stmtsToLongs.remove(object);
            if (l == null) {
                throw new RuntimeException("Internal inconsistency: A (not new) checking-out statement is not in deathmarch.");
            }
            Object v = this.longsToStmts.remove(l);
            if (l == null) {
                throw new RuntimeException("Internal inconsistency: A (not new) checking-out statement is not in deathmarch.");
            }
        }

        public boolean cullNext() {
            if (this.longsToStmts.isEmpty()) {
                return false;
            }
            Long l = (Long)this.longsToStmts.firstKey();
            Object v = this.longsToStmts.get(l);
            if (logger.isLoggable(MLevel.FINEST)) {
                logger.finest("CULLING: " + ((StatementCacheKey)GooGooStatementCache.this.stmtToKey.get(v)).stmtText);
            }
            GooGooStatementCache.this.removeStatement(v, 3);
            if (this.contains(v)) {
                throw new RuntimeException("Inconsistency!!! Statement culled from deathmarch failed to be removed by removeStatement( ... )!");
            }
            return true;
        }

        public boolean contains(Object object) {
            return this.stmtsToLongs.keySet().contains(object);
        }

        public int size() {
            return this.longsToStmts.size();
        }

        private Long getNextLong() {
            return new Long(++this.last_long);
        }
    }

    protected final class DeathmarchConnectionStatementManager
    extends ConnectionStatementManager {
        Map cxnsToDms = new HashMap();

        protected DeathmarchConnectionStatementManager() {
        }

        public void addStatementForConnection(Object object, Connection connection) {
            super.addStatementForConnection(object, connection);
            Deathmarch deathmarch = (Deathmarch)this.cxnsToDms.get(connection);
            if (deathmarch == null) {
                deathmarch = new Deathmarch();
                this.cxnsToDms.put(connection, deathmarch);
            }
        }

        public boolean removeStatementForConnection(Object object, Connection connection) {
            boolean bl = super.removeStatementForConnection(object, connection);
            if (bl && this.statementSet(connection) == null) {
                this.cxnsToDms.remove(connection);
            }
            return bl;
        }

        public Deathmarch getDeathmarch(Connection connection) {
            return (Deathmarch)this.cxnsToDms.get(connection);
        }
    }

    private static class KeyRec {
        HashSet allStmts = new HashSet();
        LinkedList checkoutQueue = new LinkedList();

        private KeyRec() {
        }
    }

    protected static final class SimpleConnectionStatementManager
    extends ConnectionStatementManager {
        protected SimpleConnectionStatementManager() {
        }
    }
}

