/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.management;

import com.mchange.v1.lang.ClassUtils;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.mchange.v2.c3p0.DriverManagerDataSource;
import com.mchange.v2.c3p0.PooledDataSource;
import com.mchange.v2.c3p0.WrapperConnectionPoolDataSource;
import com.mchange.v2.c3p0.impl.AbstractPoolBackedDataSource;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.management.ManagementUtils;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;

public class DynamicPooledDataSourceManagerMBean
implements DynamicMBean {
    static final MLogger logger;
    static final Set HIDE_PROPS;
    static final Set HIDE_OPS;
    static final Set FORCE_OPS;
    static final Set FORCE_READ_ONLY_PROPS;
    static final MBeanOperationInfo[] OP_INFS;
    MBeanInfo info = null;
    PooledDataSource pds;
    String mbeanName;
    MBeanServer mbs;
    ConnectionPoolDataSource cpds;
    DataSource unpooledDataSource;
    Map pdsAttrInfos;
    Map cpdsAttrInfos;
    Map unpooledDataSourceAttrInfos;
    PropertyChangeListener pcl = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getNewValue();
            if ("nestedDataSource".equals(string) || "connectionPoolDataSource".equals(string)) {
                DynamicPooledDataSourceManagerMBean.this.reinitialize();
            }
        }
    };
    static final /* synthetic */ boolean $assertionsDisabled;

    public DynamicPooledDataSourceManagerMBean(PooledDataSource pooledDataSource, String string, MBeanServer mBeanServer) throws Exception {
        Exception exception;
        this.pds = pooledDataSource;
        this.mbeanName = string;
        this.mbs = mBeanServer;
        if (!(pooledDataSource instanceof ComboPooledDataSource)) {
            if (pooledDataSource instanceof AbstractPoolBackedDataSource) {
                ((AbstractPoolBackedDataSource)pooledDataSource).addPropertyChangeListener(this.pcl);
            } else {
                logger.warning(this + "managing an unexpected PooledDataSource. Only top-level attributes will be available. PooledDataSource: " + pooledDataSource);
            }
        }
        if ((exception = this.reinitialize()) != null) {
            throw exception;
        }
    }

    private synchronized Exception reinitialize() {
        try {
            Object object;
            MBeanAttributeInfo[] mBeanAttributeInfoArray;
            if (!(this.pds instanceof ComboPooledDataSource) && this.pds instanceof AbstractPoolBackedDataSource) {
                if (this.cpds instanceof WrapperConnectionPoolDataSource) {
                    ((WrapperConnectionPoolDataSource)this.cpds).removePropertyChangeListener(this.pcl);
                }
                this.cpds = null;
                this.unpooledDataSource = null;
                this.cpds = ((AbstractPoolBackedDataSource)this.pds).getConnectionPoolDataSource();
                if (this.cpds instanceof WrapperConnectionPoolDataSource) {
                    this.unpooledDataSource = ((WrapperConnectionPoolDataSource)this.cpds).getNestedDataSource();
                    ((WrapperConnectionPoolDataSource)this.cpds).addPropertyChangeListener(this.pcl);
                }
            }
            this.pdsAttrInfos = DynamicPooledDataSourceManagerMBean.extractAttributeInfos(this.pds);
            this.cpdsAttrInfos = DynamicPooledDataSourceManagerMBean.extractAttributeInfos(this.cpds);
            this.unpooledDataSourceAttrInfos = DynamicPooledDataSourceManagerMBean.extractAttributeInfos(this.unpooledDataSource);
            HashSet hashSet = new HashSet();
            hashSet.addAll(this.pdsAttrInfos.keySet());
            hashSet.addAll(this.cpdsAttrInfos.keySet());
            hashSet.addAll(this.unpooledDataSourceAttrInfos.keySet());
            HashSet hashSet2 = new HashSet();
            Object object2 = hashSet.iterator();
            while (object2.hasNext()) {
                mBeanAttributeInfoArray = (MBeanAttributeInfo[])object2.next();
                object = this.pdsAttrInfos.get(mBeanAttributeInfoArray);
                if (object == null) {
                    object = this.cpdsAttrInfos.get(mBeanAttributeInfoArray);
                }
                if (object == null) {
                    object = this.unpooledDataSourceAttrInfos.get(mBeanAttributeInfoArray);
                }
                hashSet2.add(object);
            }
            object2 = this.getClass().getName();
            mBeanAttributeInfoArray = hashSet2.toArray(new MBeanAttributeInfo[hashSet2.size()]);
            object = new Class[]{PooledDataSource.class, String.class, MBeanServer.class};
            MBeanConstructorInfo[] mBeanConstructorInfoArray = new MBeanConstructorInfo[]{new MBeanConstructorInfo("Constructor from PooledDataSource", this.getClass().getConstructor((Class<?>)object))};
            this.info = new MBeanInfo(this.getClass().getName(), "An MBean to monitor and manage a PooledDataSource", mBeanAttributeInfoArray, mBeanConstructorInfoArray, OP_INFS, null);
            try {
                ObjectName objectName = ObjectName.getInstance(this.mbeanName);
                if (this.mbs.isRegistered(objectName)) {
                    this.mbs.unregisterMBean(objectName);
                    if (logger.isLoggable(MLevel.FINER)) {
                        logger.log(MLevel.FINER, "MBean: " + this.mbeanName + " unregistered, in order to be reregistered after update.");
                    }
                }
                this.mbs.registerMBean(this, objectName);
                if (logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, "MBean: " + this.mbeanName + " registered.");
                }
                return null;
            }
            catch (Exception exception) {
                if (logger.isLoggable(MLevel.WARNING)) {
                    logger.log(MLevel.WARNING, "An Exception occurred while registering/reregistering mbean " + this.mbeanName + ". MBean may not be registered, or may not work properly.", exception);
                }
                return exception;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, "Huh? We can't find our own constructor?? The one we're in?", noSuchMethodException);
            }
            return noSuchMethodException;
        }
    }

    private static MBeanOperationInfo[] extractOpInfs() {
        MBeanParameterInfo mBeanParameterInfo = new MBeanParameterInfo("user", "java.lang.String", "The database username of a pool-owner.");
        MBeanParameterInfo mBeanParameterInfo2 = new MBeanParameterInfo("password", "java.lang.String", "The database password of a pool-owner.");
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[]{mBeanParameterInfo, mBeanParameterInfo2};
        MBeanParameterInfo[] mBeanParameterInfoArray2 = new MBeanParameterInfo[]{};
        Method[] methodArray = PooledDataSource.class.getMethods();
        TreeSet<MBeanOperationInfo> treeSet = new TreeSet<MBeanOperationInfo>(ManagementUtils.OP_INFO_COMPARATOR);
        for (int i = 0; i < methodArray.length; ++i) {
            int n;
            Method method = methodArray[i];
            if (HIDE_OPS.contains(method)) continue;
            String string = method.getName();
            Class<?>[] classArray = method.getParameterTypes();
            if (!FORCE_OPS.contains(string) && (string.startsWith("set") && classArray.length == 1 || (string.startsWith("get") || string.startsWith("is")) && classArray.length == 0)) continue;
            Class<?> clazz = method.getReturnType();
            int n2 = n = clazz == Void.TYPE ? 1 : 0;
            Object object = classArray.length == 2 && classArray[0] == (class$java$lang$String == null ? DynamicPooledDataSourceManagerMBean.class$("java.lang.String") : class$java$lang$String) && classArray[1] == (class$java$lang$String == null ? DynamicPooledDataSourceManagerMBean.class$("java.lang.String") : class$java$lang$String) ? mBeanParameterInfoArray : (classArray.length == 0 ? mBeanParameterInfoArray2 : null);
            MBeanOperationInfo mBeanOperationInfo = object != null ? new MBeanOperationInfo(string, null, (MBeanParameterInfo[])object, clazz.getName(), n) : new MBeanOperationInfo(method.toString(), method);
            treeSet.add(mBeanOperationInfo);
        }
        return treeSet.toArray(new MBeanOperationInfo[treeSet.size()]);
    }

    public synchronized Object getAttribute(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
        try {
            AttrRec attrRec = this.attrRecForAttribute(string);
            if (attrRec == null) {
                throw new AttributeNotFoundException(string);
            }
            MBeanAttributeInfo mBeanAttributeInfo = attrRec.attrInfo;
            if (!mBeanAttributeInfo.isReadable()) {
                throw new IllegalArgumentException(string + " not readable.");
            }
            String string2 = mBeanAttributeInfo.getName();
            String string3 = mBeanAttributeInfo.isIs() ? "is" : "get";
            String string4 = string3 + Character.toUpperCase(string2.charAt(0)) + string2.substring(1);
            Object object = attrRec.target;
            Method method = object.getClass().getMethod(string4, null);
            return method.invoke(object, null);
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "Failed to get requested attribute: " + string, exception);
            }
            throw new MBeanException(exception);
        }
    }

    public synchronized AttributeList getAttributes(String[] stringArray) {
        AttributeList attributeList = new AttributeList();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            try {
                Object object = this.getAttribute(string);
                attributeList.add(new Attribute(string, object));
                continue;
            }
            catch (Exception exception) {
                if (!logger.isLoggable(MLevel.WARNING)) continue;
                logger.log(MLevel.WARNING, "Failed to get requested attribute (for list): " + string, exception);
            }
        }
        return attributeList;
    }

    private AttrRec attrRecForAttribute(String string) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.pdsAttrInfos.containsKey(string)) {
            return new AttrRec(this.pds, (MBeanAttributeInfo)this.pdsAttrInfos.get(string));
        }
        if (this.cpdsAttrInfos.containsKey(string)) {
            return new AttrRec(this.cpds, (MBeanAttributeInfo)this.cpdsAttrInfos.get(string));
        }
        if (this.unpooledDataSourceAttrInfos.containsKey(string)) {
            return new AttrRec(this.unpooledDataSource, (MBeanAttributeInfo)this.unpooledDataSourceAttrInfos.get(string));
        }
        return null;
    }

    public synchronized MBeanInfo getMBeanInfo() {
        if (this.info == null) {
            this.reinitialize();
        }
        return this.info;
    }

    public synchronized Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        try {
            int n = stringArray.length;
            Class[] classArray = new Class[n];
            for (int i = 0; i < n; ++i) {
                classArray[i] = ClassUtils.forName(stringArray[i]);
            }
            Method method = this.pds.getClass().getMethod(string, classArray);
            return method.invoke((Object)this.pds, objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                boolean bl = false;
                if (stringArray.length == 0 && (string.startsWith("get") || (bl = string.startsWith("is")))) {
                    int n = bl ? 2 : 3;
                    String string2 = Character.toLowerCase(string.charAt(n)) + string.substring(n + 1);
                    return this.getAttribute(string2);
                }
                if (stringArray.length == 1 && string.startsWith("set")) {
                    this.setAttribute(new Attribute(Character.toLowerCase(string.charAt(3)) + string.substring(4), objectArray[0]));
                    return null;
                }
                throw new MBeanException(noSuchMethodException);
            }
            catch (Exception exception) {
                throw new MBeanException(exception);
            }
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
    }

    public synchronized void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            AttrRec attrRec;
            String string = attribute.getName();
            if (string == "factoryClassLocation") {
                if (this.pds instanceof ComboPooledDataSource) {
                    ((ComboPooledDataSource)this.pds).setFactoryClassLocation((String)attribute.getValue());
                    return;
                }
                if (this.pds instanceof AbstractPoolBackedDataSource) {
                    String string2 = (String)attribute.getValue();
                    AbstractPoolBackedDataSource abstractPoolBackedDataSource = (AbstractPoolBackedDataSource)this.pds;
                    abstractPoolBackedDataSource.setFactoryClassLocation(string2);
                    ConnectionPoolDataSource connectionPoolDataSource = abstractPoolBackedDataSource.getConnectionPoolDataSource();
                    if (connectionPoolDataSource instanceof WrapperConnectionPoolDataSource) {
                        WrapperConnectionPoolDataSource wrapperConnectionPoolDataSource = (WrapperConnectionPoolDataSource)connectionPoolDataSource;
                        wrapperConnectionPoolDataSource.setFactoryClassLocation(string2);
                        DataSource dataSource = wrapperConnectionPoolDataSource.getNestedDataSource();
                        if (dataSource instanceof DriverManagerDataSource) {
                            ((DriverManagerDataSource)dataSource).setFactoryClassLocation(string2);
                        }
                    }
                    return;
                }
            }
            if ((attrRec = this.attrRecForAttribute(string)) == null) {
                throw new AttributeNotFoundException(string);
            }
            MBeanAttributeInfo mBeanAttributeInfo = attrRec.attrInfo;
            if (!mBeanAttributeInfo.isWritable()) {
                throw new IllegalArgumentException(string + " not writable.");
            }
            Class clazz = ClassUtils.forName(attrRec.attrInfo.getType());
            String string3 = mBeanAttributeInfo.getName();
            String string4 = "set";
            String string5 = string4 + Character.toUpperCase(string3.charAt(0)) + string3.substring(1);
            Object object = attrRec.target;
            Method method = object.getClass().getMethod(string5, clazz);
            method.invoke(object, attribute.getValue());
            if (object != this.pds) {
                if (this.pds instanceof AbstractPoolBackedDataSource) {
                    ((AbstractPoolBackedDataSource)this.pds).resetPoolManager(false);
                } else if (logger.isLoggable(MLevel.WARNING)) {
                    logger.warning("MBean set a nested ConnectionPoolDataSource or DataSource parameter on an unknown PooledDataSource type. Could not reset the pool manager, so the changes may not take effect. c3p0 may need to be updated for PooledDataSource type " + this.pds.getClass() + ".");
                }
            }
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "Failed to set requested attribute: " + attribute, exception);
            }
            throw new MBeanException(exception);
        }
    }

    public synchronized AttributeList setAttributes(AttributeList attributeList) {
        AttributeList attributeList2 = new AttributeList();
        int n = attributeList.size();
        for (int i = 0; i < n; ++i) {
            Attribute attribute = (Attribute)attributeList.get(i);
            try {
                this.setAttribute(attribute);
                attributeList2.add(attribute);
                continue;
            }
            catch (Exception exception) {
                if (!logger.isLoggable(MLevel.WARNING)) continue;
                logger.log(MLevel.WARNING, "Failed to set requested attribute (from list): " + attribute, exception);
            }
        }
        return attributeList2;
    }

    private static Map extractAttributeInfos(Object object) {
        if (object != null) {
            try {
                HashMap<String, MBeanAttributeInfo> hashMap = new HashMap<String, MBeanAttributeInfo>();
                BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass(), Object.class);
                PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
                int n = propertyDescriptorArray.length;
                for (int i = 0; i < n; ++i) {
                    PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                    String string = propertyDescriptor.getName();
                    if (HIDE_PROPS.contains(string)) continue;
                    String string2 = DynamicPooledDataSourceManagerMBean.getDescription(string);
                    Method method = propertyDescriptor.getReadMethod();
                    Method method2 = propertyDescriptor.getWriteMethod();
                    if (FORCE_READ_ONLY_PROPS.contains(string)) {
                        method2 = null;
                    }
                    try {
                        hashMap.put(string, new MBeanAttributeInfo(string, string2, method, method2));
                        continue;
                    }
                    catch (javax.management.IntrospectionException introspectionException) {
                        if (!logger.isLoggable(MLevel.WARNING)) continue;
                        logger.log(MLevel.WARNING, "IntrospectionException while setting up MBean attribute '" + string + "'", introspectionException);
                    }
                }
                return Collections.synchronizedMap(hashMap);
            }
            catch (IntrospectionException introspectionException) {
                if (logger.isLoggable(MLevel.WARNING)) {
                    logger.log(MLevel.WARNING, "IntrospectionException while setting up MBean attributes for " + object, introspectionException);
                }
                return Collections.EMPTY_MAP;
            }
        }
        return Collections.EMPTY_MAP;
    }

    private static String getDescription(String string) {
        return null;
    }

    static {
        $assertionsDisabled = !DynamicPooledDataSourceManagerMBean.class.desiredAssertionStatus();
        logger = MLog.getLogger(DynamicPooledDataSourceManagerMBean.class);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("connectionPoolDataSource");
        hashSet.add("nestedDataSource");
        hashSet.add("reference");
        hashSet.add("connection");
        hashSet.add("password");
        hashSet.add("pooledConnection");
        hashSet.add("properties");
        hashSet.add("logWriter");
        hashSet.add("lastAcquisitionFailureDefaultUser");
        hashSet.add("lastCheckoutFailureDefaultUser");
        hashSet.add("lastCheckinFailureDefaultUser");
        hashSet.add("lastIdleTestFailureDefaultUser");
        hashSet.add("lastConnectionTestFailureDefaultUser");
        HIDE_PROPS = Collections.unmodifiableSet(hashSet);
        Class[] classArray = new Class[]{String.class, String.class};
        HashSet<Method> hashSet2 = new HashSet<Method>();
        try {
            hashSet2.add(PooledDataSource.class.getMethod("close", Boolean.TYPE));
            hashSet2.add(PooledDataSource.class.getMethod("getConnection", classArray));
            hashSet2.add(PooledDataSource.class.getMethod("getLastAcquisitionFailure", classArray));
            hashSet2.add(PooledDataSource.class.getMethod("getLastCheckinFailure", classArray));
            hashSet2.add(PooledDataSource.class.getMethod("getLastCheckoutFailure", classArray));
            hashSet2.add(PooledDataSource.class.getMethod("getLastIdleTestFailure", classArray));
            hashSet2.add(PooledDataSource.class.getMethod("getLastConnectionTestFailure", classArray));
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, "Tried to hide an operation from being exposed by mbean, but failed to find the operation!", exception);
        }
        HIDE_OPS = Collections.unmodifiableSet(hashSet2);
        HashSet<String> hashSet3 = new HashSet<String>();
        hashSet3.add("identityToken");
        FORCE_READ_ONLY_PROPS = Collections.unmodifiableSet(hashSet3);
        HashSet hashSet4 = new HashSet();
        FORCE_OPS = Collections.unmodifiableSet(hashSet4);
        OP_INFS = DynamicPooledDataSourceManagerMBean.extractOpInfs();
    }

    private static class AttrRec {
        Object target;
        MBeanAttributeInfo attrInfo;

        AttrRec(Object object, MBeanAttributeInfo mBeanAttributeInfo) {
            this.target = object;
            this.attrInfo = mBeanAttributeInfo;
        }
    }
}

