/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.management;

import com.mchange.v2.c3p0.PooledDataSource;
import com.mchange.v2.c3p0.management.C3P0RegistryManager;
import com.mchange.v2.c3p0.management.DynamicPooledDataSourceManagerMBean;
import com.mchange.v2.c3p0.management.ManagementCoordinator;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class ActiveManagementCoordinator
implements ManagementCoordinator {
    private static final String C3P0_REGISTRY_NAME = "com.mchange.v2.c3p0:type=C3P0Registry";
    static final MLogger logger = MLog.getLogger(ActiveManagementCoordinator.class);
    MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();

    public void attemptManageC3P0Registry() {
        block4: {
            try {
                ObjectName objectName = new ObjectName(C3P0_REGISTRY_NAME);
                C3P0RegistryManager c3P0RegistryManager = new C3P0RegistryManager();
                if (this.mbs.isRegistered(objectName)) {
                    if (logger.isLoggable(MLevel.WARNING)) {
                        logger.warning("A C3P0Registry mbean is already registered. This probably means that an application using c3p0 was undeployed, but not all PooledDataSources were closed prior to undeployment. This may lead to resource leaks over time. Please take care to close all PooledDataSources.");
                    }
                    this.mbs.unregisterMBean(objectName);
                }
                this.mbs.registerMBean(c3P0RegistryManager, objectName);
            }
            catch (Exception exception) {
                if (!logger.isLoggable(MLevel.WARNING)) break block4;
                logger.log(MLevel.WARNING, "Failed to set up C3P0RegistryManager mBean. [c3p0 will still function normally, but management via JMX may not be possible.]", exception);
            }
        }
    }

    public void attemptUnmanageC3P0Registry() {
        block6: {
            try {
                ObjectName objectName = new ObjectName(C3P0_REGISTRY_NAME);
                if (this.mbs.isRegistered(objectName)) {
                    this.mbs.unregisterMBean(objectName);
                    if (logger.isLoggable(MLevel.FINER)) {
                        logger.log(MLevel.FINER, "C3P0Registry mbean unregistered.");
                    }
                } else if (logger.isLoggable(MLevel.FINE)) {
                    logger.fine("The C3P0Registry mbean was not found in the registry, so could not be unregistered.");
                }
            }
            catch (Exception exception) {
                if (!logger.isLoggable(MLevel.WARNING)) break block6;
                logger.log(MLevel.WARNING, "An Exception occurred while trying to unregister the C3P0RegistryManager mBean." + exception);
            }
        }
    }

    public void attemptManagePooledDataSource(PooledDataSource pooledDataSource) {
        block2: {
            String string = this.getPdsObjectNameStr(pooledDataSource);
            try {
                DynamicPooledDataSourceManagerMBean dynamicPooledDataSourceManagerMBean = new DynamicPooledDataSourceManagerMBean(pooledDataSource, string, this.mbs);
            }
            catch (Exception exception) {
                if (!logger.isLoggable(MLevel.WARNING)) break block2;
                logger.log(MLevel.WARNING, "Failed to set up a PooledDataSourceManager mBean. [" + string + "] " + "[c3p0 will still functioning normally, but management via JMX may not be possible.]", exception);
            }
        }
    }

    public void attemptUnmanagePooledDataSource(PooledDataSource pooledDataSource) {
        block6: {
            String string = this.getPdsObjectNameStr(pooledDataSource);
            try {
                ObjectName objectName = new ObjectName(string);
                if (this.mbs.isRegistered(objectName)) {
                    this.mbs.unregisterMBean(objectName);
                    if (logger.isLoggable(MLevel.FINER)) {
                        logger.log(MLevel.FINER, "MBean: " + string + " unregistered.");
                    }
                } else if (logger.isLoggable(MLevel.FINE)) {
                    logger.fine("The mbean " + string + " was not found in the registry, so could not be unregistered.");
                }
            }
            catch (Exception exception) {
                if (!logger.isLoggable(MLevel.WARNING)) break block6;
                logger.log(MLevel.WARNING, "An Exception occurred while unregistering mBean. [" + string + "] " + exception);
            }
        }
    }

    private String getPdsObjectNameStr(PooledDataSource pooledDataSource) {
        return "com.mchange.v2.c3p0:type=PooledDataSource[" + pooledDataSource.getIdentityToken() + "]";
    }
}

