/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.jboss;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.mchange.v2.c3p0.jboss.C3P0PooledDataSourceMBean;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.beans.PropertyVetoException;
import java.sql.SQLException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;

public class C3P0PooledDataSource
implements C3P0PooledDataSourceMBean {
    private static final MLogger logger = MLog.getLogger(C3P0PooledDataSource.class);
    String jndiName;
    ComboPooledDataSource combods = new ComboPooledDataSource();

    private void rebind() throws NamingException {
        this.rebind(null);
    }

    private void rebind(String string) throws NamingException {
        InitialContext initialContext = new InitialContext();
        if (string != null) {
            initialContext.unbind(string);
        }
        if (this.jndiName != null) {
            Name name = initialContext.getNameParser(this.jndiName).parse(this.jndiName);
            Context context = initialContext;
            int n = name.size() - 1;
            for (int i = 0; i < n; ++i) {
                try {
                    context = context.createSubcontext(name.get(i));
                    continue;
                }
                catch (NameAlreadyBoundException nameAlreadyBoundException) {
                    context = (Context)context.lookup(name.get(i));
                }
            }
            initialContext.rebind(this.jndiName, (Object)this.combods);
        }
    }

    public void setJndiName(String string) throws NamingException {
        String string2 = this.jndiName;
        this.jndiName = string;
        this.rebind(string2);
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public String getDescription() {
        return this.combods.getDescription();
    }

    public void setDescription(String string) throws NamingException {
        this.combods.setDescription(string);
        this.rebind();
    }

    public String getDriverClass() {
        return this.combods.getDriverClass();
    }

    public void setDriverClass(String string) throws PropertyVetoException, NamingException {
        this.combods.setDriverClass(string);
        this.rebind();
    }

    public String getJdbcUrl() {
        return this.combods.getJdbcUrl();
    }

    public void setJdbcUrl(String string) throws NamingException {
        this.combods.setJdbcUrl(string);
        this.rebind();
    }

    public String getUser() {
        return this.combods.getUser();
    }

    public void setUser(String string) throws NamingException {
        this.combods.setUser(string);
        this.rebind();
    }

    public String getPassword() {
        return this.combods.getPassword();
    }

    public void setPassword(String string) throws NamingException {
        this.combods.setPassword(string);
        this.rebind();
    }

    public int getCheckoutTimeout() {
        return this.combods.getCheckoutTimeout();
    }

    public void setCheckoutTimeout(int n) throws NamingException {
        this.combods.setCheckoutTimeout(n);
        this.rebind();
    }

    public int getAcquireIncrement() {
        return this.combods.getAcquireIncrement();
    }

    public void setAcquireIncrement(int n) throws NamingException {
        this.combods.setAcquireIncrement(n);
        this.rebind();
    }

    public int getAcquireRetryAttempts() {
        return this.combods.getAcquireRetryAttempts();
    }

    public void setAcquireRetryAttempts(int n) throws NamingException {
        this.combods.setAcquireRetryAttempts(n);
        this.rebind();
    }

    public int getAcquireRetryDelay() {
        return this.combods.getAcquireRetryDelay();
    }

    public void setAcquireRetryDelay(int n) throws NamingException {
        this.combods.setAcquireRetryDelay(n);
        this.rebind();
    }

    public boolean isAutoCommitOnClose() {
        return this.combods.isAutoCommitOnClose();
    }

    public void setAutoCommitOnClose(boolean bl) throws NamingException {
        this.combods.setAutoCommitOnClose(bl);
        this.rebind();
    }

    public String getConnectionTesterClassName() {
        return this.combods.getConnectionTesterClassName();
    }

    public void setConnectionTesterClassName(String string) throws PropertyVetoException, NamingException {
        this.combods.setConnectionTesterClassName(string);
        this.rebind();
    }

    public String getAutomaticTestTable() {
        return this.combods.getAutomaticTestTable();
    }

    public void setAutomaticTestTable(String string) throws NamingException {
        this.combods.setAutomaticTestTable(string);
        this.rebind();
    }

    public boolean isForceIgnoreUnresolvedTransactions() {
        return this.combods.isForceIgnoreUnresolvedTransactions();
    }

    public void setForceIgnoreUnresolvedTransactions(boolean bl) throws NamingException {
        this.combods.setForceIgnoreUnresolvedTransactions(bl);
        this.rebind();
    }

    public int getIdleConnectionTestPeriod() {
        return this.combods.getIdleConnectionTestPeriod();
    }

    public void setIdleConnectionTestPeriod(int n) throws NamingException {
        this.combods.setIdleConnectionTestPeriod(n);
        this.rebind();
    }

    public int getInitialPoolSize() {
        return this.combods.getInitialPoolSize();
    }

    public void setInitialPoolSize(int n) throws NamingException {
        this.combods.setInitialPoolSize(n);
        this.rebind();
    }

    public int getMaxIdleTime() {
        return this.combods.getMaxIdleTime();
    }

    public void setMaxIdleTime(int n) throws NamingException {
        this.combods.setMaxIdleTime(n);
        this.rebind();
    }

    public int getMaxPoolSize() {
        return this.combods.getMaxPoolSize();
    }

    public void setMaxPoolSize(int n) throws NamingException {
        this.combods.setMaxPoolSize(n);
        this.rebind();
    }

    public int getMaxStatements() {
        return this.combods.getMaxStatements();
    }

    public void setMaxStatements(int n) throws NamingException {
        this.combods.setMaxStatements(n);
        this.rebind();
    }

    public int getMaxStatementsPerConnection() {
        return this.combods.getMaxStatementsPerConnection();
    }

    public void setMaxStatementsPerConnection(int n) throws NamingException {
        this.combods.setMaxStatementsPerConnection(n);
        this.rebind();
    }

    public int getMinPoolSize() {
        return this.combods.getMinPoolSize();
    }

    public void setMinPoolSize(int n) throws NamingException {
        this.combods.setMinPoolSize(n);
        this.rebind();
    }

    public int getPropertyCycle() {
        return this.combods.getPropertyCycle();
    }

    public void setPropertyCycle(int n) throws NamingException {
        this.combods.setPropertyCycle(n);
        this.rebind();
    }

    public boolean isBreakAfterAcquireFailure() {
        return this.combods.isBreakAfterAcquireFailure();
    }

    public void setBreakAfterAcquireFailure(boolean bl) throws NamingException {
        this.combods.setBreakAfterAcquireFailure(bl);
        this.rebind();
    }

    public boolean isTestConnectionOnCheckout() {
        return this.combods.isTestConnectionOnCheckout();
    }

    public void setTestConnectionOnCheckout(boolean bl) throws NamingException {
        this.combods.setTestConnectionOnCheckout(bl);
        this.rebind();
    }

    public boolean isTestConnectionOnCheckin() {
        return this.combods.isTestConnectionOnCheckin();
    }

    public void setTestConnectionOnCheckin(boolean bl) throws NamingException {
        this.combods.setTestConnectionOnCheckin(bl);
        this.rebind();
    }

    public boolean isUsesTraditionalReflectiveProxies() {
        return this.combods.isUsesTraditionalReflectiveProxies();
    }

    public void setUsesTraditionalReflectiveProxies(boolean bl) throws NamingException {
        this.combods.setUsesTraditionalReflectiveProxies(bl);
        this.rebind();
    }

    public String getPreferredTestQuery() {
        return this.combods.getPreferredTestQuery();
    }

    public void setPreferredTestQuery(String string) throws NamingException {
        this.combods.setPreferredTestQuery(string);
        this.rebind();
    }

    public String getDataSourceName() {
        return this.combods.getDataSourceName();
    }

    public void setDataSourceName(String string) throws NamingException {
        this.combods.setDataSourceName(string);
        this.rebind();
    }

    public int getNumHelperThreads() {
        return this.combods.getNumHelperThreads();
    }

    public void setNumHelperThreads(int n) throws NamingException {
        this.combods.setNumHelperThreads(n);
        this.rebind();
    }

    public String getFactoryClassLocation() {
        return this.combods.getFactoryClassLocation();
    }

    public void setFactoryClassLocation(String string) throws NamingException {
        this.combods.setFactoryClassLocation(string);
        this.rebind();
    }

    public int getNumUserPools() throws SQLException {
        return this.combods.getNumUserPools();
    }

    public int getNumConnectionsDefaultUser() throws SQLException {
        return this.combods.getNumConnectionsDefaultUser();
    }

    public int getNumIdleConnectionsDefaultUser() throws SQLException {
        return this.combods.getNumIdleConnectionsDefaultUser();
    }

    public int getNumBusyConnectionsDefaultUser() throws SQLException {
        return this.combods.getNumBusyConnectionsDefaultUser();
    }

    public int getNumUnclosedOrphanedConnectionsDefaultUser() throws SQLException {
        return this.combods.getNumUnclosedOrphanedConnectionsDefaultUser();
    }

    public int getNumConnections(String string, String string2) throws SQLException {
        return this.combods.getNumConnections(string, string2);
    }

    public int getNumIdleConnections(String string, String string2) throws SQLException {
        return this.combods.getNumIdleConnections(string, string2);
    }

    public int getNumBusyConnections(String string, String string2) throws SQLException {
        return this.combods.getNumBusyConnections(string, string2);
    }

    public int getNumUnclosedOrphanedConnections(String string, String string2) throws SQLException {
        return this.combods.getNumUnclosedOrphanedConnections(string, string2);
    }

    public int getNumConnectionsAllUsers() throws SQLException {
        return this.combods.getNumConnectionsAllUsers();
    }

    public int getNumIdleConnectionsAllUsers() throws SQLException {
        return this.combods.getNumIdleConnectionsAllUsers();
    }

    public int getNumBusyConnectionsAllUsers() throws SQLException {
        return this.combods.getNumBusyConnectionsAllUsers();
    }

    public int getNumUnclosedOrphanedConnectionsAllUsers() throws SQLException {
        return this.combods.getNumUnclosedOrphanedConnectionsAllUsers();
    }

    public void softResetDefaultUser() throws SQLException {
        this.combods.softResetDefaultUser();
    }

    public void softReset(String string, String string2) throws SQLException {
        this.combods.softReset(string, string2);
    }

    public void softResetAllUsers() throws SQLException {
        this.combods.softResetAllUsers();
    }

    public void hardReset() throws SQLException {
        this.combods.hardReset();
    }

    public void close() throws SQLException {
        this.combods.close();
    }

    public void create() throws Exception {
    }

    public void start() throws Exception {
        logger.log(MLevel.INFO, "Bound C3P0 PooledDataSource to name ''{0}''. Starting...", this.jndiName);
        this.combods.getNumBusyConnectionsDefaultUser();
    }

    public void stop() {
    }

    public void destroy() {
        try {
            this.combods.close();
            logger.log(MLevel.INFO, "Destroyed C3P0 PooledDataSource with name ''{0}''.", this.jndiName);
        }
        catch (Exception exception) {
            logger.log(MLevel.INFO, "Failed to destroy C3P0 PooledDataSource.", exception);
        }
    }

    public String getConnectionCustomizerClassName() {
        return this.combods.getConnectionCustomizerClassName();
    }

    public float getEffectivePropertyCycle(String string, String string2) throws SQLException {
        return this.combods.getEffectivePropertyCycle(string, string2);
    }

    public float getEffectivePropertyCycleDefaultUser() throws SQLException {
        return this.combods.getEffectivePropertyCycleDefaultUser();
    }

    public int getMaxAdministrativeTaskTime() {
        return this.combods.getMaxAdministrativeTaskTime();
    }

    public int getMaxConnectionAge() {
        return this.combods.getMaxConnectionAge();
    }

    public int getMaxIdleTimeExcessConnections() {
        return this.combods.getMaxIdleTimeExcessConnections();
    }

    public int getUnreturnedConnectionTimeout() {
        return this.combods.getUnreturnedConnectionTimeout();
    }

    public boolean isDebugUnreturnedConnectionStackTraces() {
        return this.combods.isDebugUnreturnedConnectionStackTraces();
    }

    public void setConnectionCustomizerClassName(String string) throws NamingException {
        this.combods.setConnectionCustomizerClassName(string);
        this.rebind();
    }

    public void setDebugUnreturnedConnectionStackTraces(boolean bl) throws NamingException {
        this.combods.setDebugUnreturnedConnectionStackTraces(bl);
        this.rebind();
    }

    public void setMaxAdministrativeTaskTime(int n) throws NamingException {
        this.combods.setMaxAdministrativeTaskTime(n);
        this.rebind();
    }

    public void setMaxConnectionAge(int n) throws NamingException {
        this.combods.setMaxConnectionAge(n);
        this.rebind();
    }

    public void setMaxIdleTimeExcessConnections(int n) throws NamingException {
        this.combods.setMaxIdleTimeExcessConnections(n);
        this.rebind();
    }

    public void setUnreturnedConnectionTimeout(int n) throws NamingException {
        this.combods.setUnreturnedConnectionTimeout(n);
        this.rebind();
    }
}

