/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v1.db.sql.ResultSetUtils;
import com.mchange.v1.db.sql.StatementUtils;
import com.mchange.v2.c3p0.AbstractConnectionTester;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class DefaultConnectionTester
extends AbstractConnectionTester {
    static final MLogger logger = MLog.getLogger(DefaultConnectionTester.class);
    static final int HASH_CODE = DefaultConnectionTester.class.getName().hashCode();
    static final Set INVALID_DB_STATES;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int activeCheckConnection(Connection connection, String string, Throwable[] throwableArray) {
        int n;
        if (string == null) {
            return this.activeCheckConnectionNoQuery(connection, throwableArray);
        }
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            n = 0;
        }
        catch (SQLException sQLException) {
            block13: {
                String string2;
                if (logger.isLoggable(MLevel.FINE)) {
                    logger.log(MLevel.FINE, "Connection " + connection + " failed Connection test with an Exception! [query=" + string + "]", sQLException);
                }
                if (throwableArray != null) {
                    throwableArray[0] = sQLException;
                }
                if (!INVALID_DB_STATES.contains(string2 = sQLException.getSQLState())) break block13;
                if (logger.isLoggable(MLevel.WARNING)) {
                    logger.log(MLevel.WARNING, "SQL State '" + string2 + "' of Exception which occurred during a Connection test (test with query '" + string + "') implies that the database is invalid, " + "and the pool should refill itself with fresh Connections.", sQLException);
                }
                int n2 = -8;
                ResultSetUtils.attemptClose(resultSet);
                StatementUtils.attemptClose(statement);
                return n2;
            }
            int n3 = -1;
            ResultSetUtils.attemptClose(resultSet);
            StatementUtils.attemptClose(statement);
            return n3;
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Connection " + connection + " failed Connection test with an Exception!", exception);
            }
            if (throwableArray != null) {
                throwableArray[0] = exception;
            }
            int n4 = -1;
            {
                catch (Throwable throwable) {
                    ResultSetUtils.attemptClose(resultSet);
                    StatementUtils.attemptClose(statement);
                    throw throwable;
                }
            }
            ResultSetUtils.attemptClose(resultSet);
            StatementUtils.attemptClose(statement);
            return n4;
        }
        ResultSetUtils.attemptClose(resultSet);
        StatementUtils.attemptClose(statement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int statusOnException(Connection connection, Throwable throwable, String string, Throwable[] throwableArray) {
        block12: {
            block13: {
                if (logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, "Testing a Connection in response to an Exception:", throwable);
                }
                if (!(throwable instanceof SQLException)) break block12;
                String string2 = ((SQLException)throwable).getSQLState();
                if (!INVALID_DB_STATES.contains(string2)) break block13;
                if (logger.isLoggable(MLevel.WARNING)) {
                    logger.log(MLevel.WARNING, "SQL State '" + string2 + "' of Exception tested by statusOnException() implies that the database is invalid, " + "and the pool should refill itself with fresh Connections.", throwable);
                }
                int n = -8;
                return n;
            }
            int n = this.activeCheckConnection(connection, string, throwableArray);
            return n;
        }
        try {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Connection test failed because test-provoking Throwable is an unexpected, non-SQLException.", throwable);
            }
            if (throwableArray != null) {
                throwableArray[0] = throwable;
            }
            int n = -1;
            return n;
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Connection " + connection + " failed Connection test with an Exception!", exception);
            }
            if (throwableArray != null) {
                throwableArray[0] = exception;
            }
            int n = -1;
            return n;
        }
    }

    private static String queryInfo(String string) {
        return string == null ? "[using default system-table query]" : "[query=" + string + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int activeCheckConnectionNoQuery(Connection connection, Throwable[] throwableArray) {
        int n;
        ResultSet resultSet = null;
        try {
            resultSet = connection.getMetaData().getTables(null, null, "PROBABLYNOT", new String[]{"TABLE"});
            n = 0;
        }
        catch (SQLException sQLException) {
            block12: {
                String string;
                if (logger.isLoggable(MLevel.FINE)) {
                    logger.log(MLevel.FINE, "Connection " + connection + " failed default system-table Connection test with an Exception!", sQLException);
                }
                if (throwableArray != null) {
                    throwableArray[0] = sQLException;
                }
                if (!INVALID_DB_STATES.contains(string = sQLException.getSQLState())) break block12;
                if (logger.isLoggable(MLevel.WARNING)) {
                    logger.log(MLevel.WARNING, "SQL State '" + string + "' of Exception which occurred during a Connection test (fallback DatabaseMetaData test) implies that the database is invalid, " + "and the pool should refill itself with fresh Connections.", sQLException);
                }
                int n2 = -8;
                ResultSetUtils.attemptClose(resultSet);
                return n2;
            }
            int n3 = -1;
            ResultSetUtils.attemptClose(resultSet);
            return n3;
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Connection " + connection + " failed default system-table Connection test with an Exception!", exception);
            }
            if (throwableArray != null) {
                throwableArray[0] = exception;
            }
            int n4 = -1;
            {
                catch (Throwable throwable) {
                    ResultSetUtils.attemptClose(resultSet);
                    throw throwable;
                }
            }
            ResultSetUtils.attemptClose(resultSet);
            return n4;
        }
        ResultSetUtils.attemptClose(resultSet);
        return n;
    }

    public boolean equals(Object object) {
        return object != null && object.getClass() == DefaultConnectionTester.class;
    }

    public int hashCode() {
        return HASH_CODE;
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("08001");
        hashSet.add("08007");
        INVALID_DB_STATES = Collections.unmodifiableSet(hashSet);
    }
}

