/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v1.db.sql.ConnectionUtils;
import com.mchange.v1.db.sql.ResultSetUtils;
import com.mchange.v1.db.sql.StatementUtils;
import com.mchange.v1.lang.BooleanUtils;
import com.mchange.v2.async.ThreadPoolAsynchronousRunner;
import com.mchange.v2.c3p0.C3P0Registry;
import com.mchange.v2.c3p0.ConnectionCustomizer;
import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.cfg.C3P0Config;
import com.mchange.v2.c3p0.impl.C3P0Defaults;
import com.mchange.v2.c3p0.impl.C3P0ImplUtils;
import com.mchange.v2.c3p0.impl.C3P0PooledConnectionPool;
import com.mchange.v2.c3p0.impl.DbAuth;
import com.mchange.v2.c3p0.impl.IdentityTokenizedCoalesceChecker;
import com.mchange.v2.coalesce.CoalesceChecker;
import com.mchange.v2.coalesce.Coalescer;
import com.mchange.v2.coalesce.CoalescerFactory;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.resourcepool.BasicResourcePoolFactory;
import com.mchange.v2.resourcepool.ResourcePoolFactory;
import com.mchange.v2.sql.SqlUtils;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public final class C3P0PooledConnectionPoolManager {
    private static final MLogger logger = MLog.getLogger(C3P0PooledConnectionPoolManager.class);
    private static final boolean POOL_EVENT_SUPPORT = false;
    private static final CoalesceChecker COALESCE_CHECKER = IdentityTokenizedCoalesceChecker.INSTANCE;
    static final Coalescer COALESCER = CoalescerFactory.createCoalescer(COALESCE_CHECKER, true, false);
    static final int DFLT_NUM_TASK_THREADS_PER_DATA_SOURCE = 3;
    ThreadPoolAsynchronousRunner taskRunner;
    Timer timer;
    ResourcePoolFactory rpfact;
    Map authsToPools;
    final ConnectionPoolDataSource cpds;
    final Map propNamesToReadMethods;
    final Map flatPropertyOverrides;
    final Map userOverrides;
    final DbAuth defaultAuth;
    final String parentDataSourceIdentityToken;
    int num_task_threads = 3;

    public int getThreadPoolSize() {
        return this.taskRunner.getThreadCount();
    }

    public int getThreadPoolNumActiveThreads() {
        return this.taskRunner.getActiveCount();
    }

    public int getThreadPoolNumIdleThreads() {
        return this.taskRunner.getIdleCount();
    }

    public int getThreadPoolNumTasksPending() {
        return this.taskRunner.getPendingTaskCount();
    }

    public String getThreadPoolStackTraces() {
        return this.taskRunner.getStackTraces();
    }

    public String getThreadPoolStatus() {
        return this.taskRunner.getStatus();
    }

    private synchronized void poolsInit() {
        this.timer = new Timer(true);
        int n = this.getMaxAdministrativeTaskTime(null);
        if (n > 0) {
            int n2 = n * 1000;
            this.taskRunner = new ThreadPoolAsynchronousRunner(this.num_task_threads, true, n2, n2 * 3, n2 * 6, this.timer);
        } else {
            this.taskRunner = new ThreadPoolAsynchronousRunner(this.num_task_threads, true, this.timer);
        }
        this.rpfact = BasicResourcePoolFactory.createNoEventSupportInstance(this.taskRunner, this.timer);
        this.authsToPools = new HashMap();
    }

    private void poolsDestroy() {
        this.poolsDestroy(true);
    }

    private synchronized void poolsDestroy(boolean bl) {
        Iterator iterator = this.authsToPools.values().iterator();
        while (iterator.hasNext()) {
            try {
                ((C3P0PooledConnectionPool)iterator.next()).close(bl);
            }
            catch (Exception exception) {
                logger.log(MLevel.WARNING, "An Exception occurred while trying to clean up a pool!", exception);
            }
        }
        this.taskRunner.close(true);
        this.timer.cancel();
        this.taskRunner = null;
        this.timer = null;
        this.rpfact = null;
        this.authsToPools = null;
    }

    public C3P0PooledConnectionPoolManager(ConnectionPoolDataSource connectionPoolDataSource, Map map, Map map2, int n, String string) throws SQLException {
        try {
            Object object;
            Object object2;
            Object object3;
            this.cpds = connectionPoolDataSource;
            this.flatPropertyOverrides = map;
            this.num_task_threads = n;
            this.parentDataSourceIdentityToken = string;
            DbAuth dbAuth = null;
            if (map != null) {
                object3 = (String)map.get("overrideDefaultUser");
                object2 = (String)map.get("overrideDefaultPassword");
                if (object3 == null) {
                    object3 = (String)map.get("user");
                    object2 = (String)map.get("password");
                }
                if (object3 != null) {
                    dbAuth = new DbAuth((String)object3, (String)object2);
                }
            }
            if (dbAuth == null) {
                dbAuth = C3P0ImplUtils.findAuth(connectionPoolDataSource);
            }
            this.defaultAuth = dbAuth;
            object3 = new HashMap();
            object2 = Introspector.getBeanInfo(connectionPoolDataSource.getClass());
            PropertyDescriptor[] propertyDescriptorArray = object2.getPropertyDescriptors();
            PropertyDescriptor propertyDescriptor = null;
            int n2 = propertyDescriptorArray.length;
            for (int i = 0; i < n2; ++i) {
                propertyDescriptor = propertyDescriptorArray[i];
                object = propertyDescriptor.getName();
                Method method = propertyDescriptor.getReadMethod();
                if (method == null) continue;
                object3.put(object, method);
            }
            this.propNamesToReadMethods = object3;
            if (map2 == null) {
                Method method = (Method)this.propNamesToReadMethods.get("userOverridesAsString");
                if (method != null) {
                    String string2 = (String)method.invoke((Object)connectionPoolDataSource, null);
                    this.userOverrides = object = C3P0ImplUtils.parseUserOverridesAsString(string2);
                } else {
                    this.userOverrides = Collections.EMPTY_MAP;
                }
            } else {
                this.userOverrides = map2;
            }
            this.poolsInit();
        }
        catch (Exception exception) {
            logger.log(MLevel.FINE, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public synchronized C3P0PooledConnectionPool getPool(String string, String string2, boolean bl) throws SQLException {
        if (bl) {
            return this.getPool(string, string2);
        }
        DbAuth dbAuth = new DbAuth(string, string2);
        C3P0PooledConnectionPool c3P0PooledConnectionPool = (C3P0PooledConnectionPool)this.authsToPools.get(dbAuth);
        if (c3P0PooledConnectionPool == null) {
            throw new SQLException("No pool has been initialized for databse user '" + string + "' with the specified password.");
        }
        return c3P0PooledConnectionPool;
    }

    public C3P0PooledConnectionPool getPool(String string, String string2) throws SQLException {
        return this.getPool(new DbAuth(string, string2));
    }

    public synchronized C3P0PooledConnectionPool getPool(DbAuth dbAuth) throws SQLException {
        C3P0PooledConnectionPool c3P0PooledConnectionPool = (C3P0PooledConnectionPool)this.authsToPools.get(dbAuth);
        if (c3P0PooledConnectionPool == null) {
            c3P0PooledConnectionPool = this.createPooledConnectionPool(dbAuth);
            this.authsToPools.put(dbAuth, c3P0PooledConnectionPool);
        }
        return c3P0PooledConnectionPool;
    }

    public synchronized Set getManagedAuths() {
        return Collections.unmodifiableSet(this.authsToPools.keySet());
    }

    public synchronized int getNumManagedAuths() {
        return this.authsToPools.size();
    }

    public C3P0PooledConnectionPool getPool() throws SQLException {
        return this.getPool(this.defaultAuth);
    }

    public synchronized int getNumIdleConnectionsAllAuths() throws SQLException {
        int n = 0;
        Iterator iterator = this.authsToPools.values().iterator();
        while (iterator.hasNext()) {
            n += ((C3P0PooledConnectionPool)iterator.next()).getNumIdleConnections();
        }
        return n;
    }

    public synchronized int getNumBusyConnectionsAllAuths() throws SQLException {
        int n = 0;
        Iterator iterator = this.authsToPools.values().iterator();
        while (iterator.hasNext()) {
            n += ((C3P0PooledConnectionPool)iterator.next()).getNumBusyConnections();
        }
        return n;
    }

    public synchronized int getNumConnectionsAllAuths() throws SQLException {
        int n = 0;
        Iterator iterator = this.authsToPools.values().iterator();
        while (iterator.hasNext()) {
            n += ((C3P0PooledConnectionPool)iterator.next()).getNumConnections();
        }
        return n;
    }

    public synchronized int getNumUnclosedOrphanedConnectionsAllAuths() throws SQLException {
        int n = 0;
        Iterator iterator = this.authsToPools.values().iterator();
        while (iterator.hasNext()) {
            n += ((C3P0PooledConnectionPool)iterator.next()).getNumUnclosedOrphanedConnections();
        }
        return n;
    }

    public synchronized int getStatementCacheNumStatementsAllUsers() throws SQLException {
        int n = 0;
        Iterator iterator = this.authsToPools.values().iterator();
        while (iterator.hasNext()) {
            n += ((C3P0PooledConnectionPool)iterator.next()).getStatementCacheNumStatements();
        }
        return n;
    }

    public synchronized int getStatementCacheNumCheckedOutStatementsAllUsers() throws SQLException {
        int n = 0;
        Iterator iterator = this.authsToPools.values().iterator();
        while (iterator.hasNext()) {
            n += ((C3P0PooledConnectionPool)iterator.next()).getStatementCacheNumCheckedOut();
        }
        return n;
    }

    public synchronized int getStatementCacheNumConnectionsWithCachedStatementsAllUsers() throws SQLException {
        int n = 0;
        Iterator iterator = this.authsToPools.values().iterator();
        while (iterator.hasNext()) {
            n += ((C3P0PooledConnectionPool)iterator.next()).getStatementCacheNumConnectionsWithCachedStatements();
        }
        return n;
    }

    public synchronized void softResetAllAuths() throws SQLException {
        Iterator iterator = this.authsToPools.values().iterator();
        while (iterator.hasNext()) {
            ((C3P0PooledConnectionPool)iterator.next()).reset();
        }
    }

    public void close() {
        this.close(true);
    }

    public synchronized void close(boolean bl) {
        if (this.authsToPools != null) {
            this.poolsDestroy(bl);
        }
    }

    protected synchronized void finalize() {
        this.close();
    }

    private Object getObject(String string, String string2) {
        String string3;
        block7: {
            Object object;
            string3 = null;
            if (string2 != null && (object = (Map)this.userOverrides.get(string2)) != null) {
                string3 = object.get(string);
            }
            if (string3 == null && this.flatPropertyOverrides != null) {
                string3 = (String)this.flatPropertyOverrides.get(string);
            }
            if (string3 == null) {
                try {
                    Object object2;
                    object = (Method)this.propNamesToReadMethods.get(string);
                    if (object != null && (object2 = ((Method)object).invoke((Object)this.cpds, null)) != null) {
                        string3 = object2.toString();
                    }
                }
                catch (Exception exception) {
                    if (!logger.isLoggable(MLevel.WARNING)) break block7;
                    logger.log(MLevel.WARNING, "An exception occurred while trying to read property '" + string + "' from ConnectionPoolDataSource: " + this.cpds + ". Default config value will be used.", exception);
                }
            }
        }
        if (string3 == null) {
            string3 = C3P0Config.getUnspecifiedUserProperty(string, null);
        }
        return string3;
    }

    private String getString(String string, String string2) {
        Object object = this.getObject(string, string2);
        return object == null ? null : object.toString();
    }

    private int getInt(String string, String string2) throws Exception {
        Object object = this.getObject(string, string2);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            return Integer.parseInt((String)object);
        }
        throw new Exception("Unexpected object found for putative int property '" + string + "': " + object);
    }

    private boolean getBoolean(String string, String string2) throws Exception {
        Object object = this.getObject(string, string2);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return BooleanUtils.parseBoolean((String)object);
        }
        throw new Exception("Unexpected object found for putative boolean property '" + string + "': " + object);
    }

    public String getAutomaticTestTable(String string) {
        return this.getString("automaticTestTable", string);
    }

    public String getPreferredTestQuery(String string) {
        return this.getString("preferredTestQuery", string);
    }

    private int getInitialPoolSize(String string) {
        try {
            return this.getInt("initialPoolSize", string);
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Could not fetch int property", exception);
            }
            return C3P0Defaults.initialPoolSize();
        }
    }

    public int getMinPoolSize(String string) {
        try {
            return this.getInt("minPoolSize", string);
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Could not fetch int property", exception);
            }
            return C3P0Defaults.minPoolSize();
        }
    }

    private int getMaxPoolSize(String string) {
        try {
            return this.getInt("maxPoolSize", string);
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Could not fetch int property", exception);
            }
            return C3P0Defaults.maxPoolSize();
        }
    }

    private int getMaxStatements(String string) {
        try {
            return this.getInt("maxStatements", string);
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Could not fetch int property", exception);
            }
            return C3P0Defaults.maxStatements();
        }
    }

    private int getMaxStatementsPerConnection(String string) {
        try {
            return this.getInt("maxStatementsPerConnection", string);
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Could not fetch int property", exception);
            }
            return C3P0Defaults.maxStatementsPerConnection();
        }
    }

    private int getAcquireIncrement(String string) {
        try {
            return this.getInt("acquireIncrement", string);
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Could not fetch int property", exception);
            }
            return C3P0Defaults.acquireIncrement();
        }
    }

    private int getAcquireRetryAttempts(String string) {
        try {
            return this.getInt("acquireRetryAttempts", string);
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Could not fetch int property", exception);
            }
            return C3P0Defaults.acquireRetryAttempts();
        }
    }

    private int getAcquireRetryDelay(String string) {
        try {
            return this.getInt("acquireRetryDelay", string);
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Could not fetch int property", exception);
            }
            return C3P0Defaults.acquireRetryDelay();
        }
    }

    private boolean getBreakAfterAcquireFailure(String string) {
        try {
            return this.getBoolean("breakAfterAcquireFailure", string);
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Could not fetch boolean property", exception);
            }
            return C3P0Defaults.breakAfterAcquireFailure();
        }
    }

    private int getCheckoutTimeout(String string) {
        try {
            return this.getInt("checkoutTimeout", string);
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Could not fetch int property", exception);
            }
            return C3P0Defaults.checkoutTimeout();
        }
    }

    private int getIdleConnectionTestPeriod(String string) {
        try {
            return this.getInt("idleConnectionTestPeriod", string);
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Could not fetch int property", exception);
            }
            return C3P0Defaults.idleConnectionTestPeriod();
        }
    }

    private int getMaxIdleTime(String string) {
        try {
            return this.getInt("maxIdleTime", string);
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Could not fetch int property", exception);
            }
            return C3P0Defaults.maxIdleTime();
        }
    }

    private int getUnreturnedConnectionTimeout(String string) {
        try {
            return this.getInt("unreturnedConnectionTimeout", string);
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Could not fetch int property", exception);
            }
            return C3P0Defaults.unreturnedConnectionTimeout();
        }
    }

    private boolean getTestConnectionOnCheckout(String string) {
        try {
            return this.getBoolean("testConnectionOnCheckout", string);
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Could not fetch boolean property", exception);
            }
            return C3P0Defaults.testConnectionOnCheckout();
        }
    }

    private boolean getTestConnectionOnCheckin(String string) {
        try {
            return this.getBoolean("testConnectionOnCheckin", string);
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Could not fetch boolean property", exception);
            }
            return C3P0Defaults.testConnectionOnCheckin();
        }
    }

    private boolean getDebugUnreturnedConnectionStackTraces(String string) {
        try {
            return this.getBoolean("debugUnreturnedConnectionStackTraces", string);
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Could not fetch boolean property", exception);
            }
            return C3P0Defaults.debugUnreturnedConnectionStackTraces();
        }
    }

    private String getConnectionTesterClassName(String string) {
        return this.getString("connectionTesterClassName", string);
    }

    private ConnectionTester getConnectionTester(String string) {
        return C3P0Registry.getConnectionTester(this.getConnectionTesterClassName(string));
    }

    private String getConnectionCustomizerClassName(String string) {
        return this.getString("connectionCustomizerClassName", string);
    }

    private ConnectionCustomizer getConnectionCustomizer(String string) throws SQLException {
        return C3P0Registry.getConnectionCustomizer(this.getConnectionCustomizerClassName(string));
    }

    private int getMaxIdleTimeExcessConnections(String string) {
        try {
            return this.getInt("maxIdleTimeExcessConnections", string);
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Could not fetch int property", exception);
            }
            return C3P0Defaults.maxIdleTimeExcessConnections();
        }
    }

    private int getMaxAdministrativeTaskTime(String string) {
        try {
            return this.getInt("maxAdministrativeTaskTime", string);
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Could not fetch int property", exception);
            }
            return C3P0Defaults.maxAdministrativeTaskTime();
        }
    }

    private int getMaxConnectionAge(String string) {
        try {
            return this.getInt("maxConnectionAge", string);
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Could not fetch int property", exception);
            }
            return C3P0Defaults.maxConnectionAge();
        }
    }

    private int getPropertyCycle(String string) {
        try {
            return this.getInt("propertyCycle", string);
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Could not fetch int property", exception);
            }
            return C3P0Defaults.propertyCycle();
        }
    }

    private C3P0PooledConnectionPool createPooledConnectionPool(DbAuth dbAuth) throws SQLException {
        String string;
        String string2 = dbAuth.getUser();
        String string3 = this.getAutomaticTestTable(string2);
        if (string3 != null) {
            string = this.initializeAutomaticTestTable(string3, dbAuth);
            if (this.getPreferredTestQuery(string2) != null && logger.isLoggable(MLevel.WARNING)) {
                logger.logp(MLevel.WARNING, C3P0PooledConnectionPoolManager.class.getName(), "createPooledConnectionPool", "[c3p0] Both automaticTestTable and preferredTestQuery have been set! Using automaticTestTable, and ignoring preferredTestQuery. Real test query is ''{0}''.", string);
            }
        } else {
            if (!this.defaultAuth.equals(dbAuth)) {
                this.ensureFirstConnectionAcquisition(dbAuth);
            }
            string = this.getPreferredTestQuery(string2);
        }
        C3P0PooledConnectionPool c3P0PooledConnectionPool = new C3P0PooledConnectionPool(this.cpds, dbAuth, this.getMinPoolSize(string2), this.getMaxPoolSize(string2), this.getInitialPoolSize(string2), this.getAcquireIncrement(string2), this.getAcquireRetryAttempts(string2), this.getAcquireRetryDelay(string2), this.getBreakAfterAcquireFailure(string2), this.getCheckoutTimeout(string2), this.getIdleConnectionTestPeriod(string2), this.getMaxIdleTime(string2), this.getMaxIdleTimeExcessConnections(string2), this.getMaxConnectionAge(string2), this.getPropertyCycle(string2), this.getUnreturnedConnectionTimeout(string2), this.getDebugUnreturnedConnectionStackTraces(string2), this.getTestConnectionOnCheckout(string2), this.getTestConnectionOnCheckin(string2), this.getMaxStatements(string2), this.getMaxStatementsPerConnection(string2), this.getConnectionTester(string2), this.getConnectionCustomizer(string2), string, this.rpfact, this.taskRunner, this.parentDataSourceIdentityToken);
        return c3P0PooledConnectionPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String initializeAutomaticTestTable(String string, DbAuth dbAuth) throws SQLException {
        String string2;
        PooledConnection pooledConnection = dbAuth.equals(this.defaultAuth) ? this.cpds.getPooledConnection() : this.cpds.getPooledConnection(dbAuth.getUser(), dbAuth.getPassword());
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        PreparedStatement preparedStatement2 = null;
        ResultSet resultSet = null;
        ResultSet resultSet2 = null;
        try {
            connection = pooledConnection.getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String string3 = databaseMetaData.getIdentifierQuoteString();
            String string4 = string3 + string + string3;
            String string5 = "SELECT * FROM " + string4;
            resultSet = databaseMetaData.getTables(null, null, string, new String[]{"TABLE"});
            boolean bl = resultSet.next();
            if (bl) {
                preparedStatement = connection.prepareStatement(string5);
                resultSet2 = preparedStatement.executeQuery();
                boolean bl2 = resultSet2.next();
                if (bl2) {
                    throw new SQLException("automatic test table '" + string + "' contains rows, and it should not! Please set this " + "parameter to the name of a table c3p0 can create on its own, " + "that is not used elsewhere in the database!");
                }
            } else {
                string2 = "CREATE TABLE " + string4 + " ( a CHAR(1) )";
                try {
                    preparedStatement2 = connection.prepareStatement(string2);
                    preparedStatement2.executeUpdate();
                }
                catch (SQLException sQLException) {
                    if (logger.isLoggable(MLevel.WARNING)) {
                        logger.log(MLevel.WARNING, "An attempt to create an automatic test table failed. Create SQL: " + string2, sQLException);
                    }
                    throw sQLException;
                }
            }
            string2 = string5;
        }
        catch (Throwable throwable) {
            ResultSetUtils.attemptClose(resultSet);
            ResultSetUtils.attemptClose(resultSet2);
            StatementUtils.attemptClose(preparedStatement);
            StatementUtils.attemptClose(preparedStatement2);
            ConnectionUtils.attemptClose(connection);
            try {
                if (pooledConnection != null) {
                    pooledConnection.close();
                }
            }
            catch (Exception exception) {
                logger.log(MLevel.WARNING, "A PooledConnection failed to close.", exception);
            }
            throw throwable;
        }
        ResultSetUtils.attemptClose(resultSet);
        ResultSetUtils.attemptClose(resultSet2);
        StatementUtils.attemptClose(preparedStatement);
        StatementUtils.attemptClose(preparedStatement2);
        ConnectionUtils.attemptClose(connection);
        try {
            if (pooledConnection != null) {
                pooledConnection.close();
            }
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, "A PooledConnection failed to close.", exception);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureFirstConnectionAcquisition(DbAuth dbAuth) throws SQLException {
        PooledConnection pooledConnection = dbAuth.equals(this.defaultAuth) ? this.cpds.getPooledConnection() : this.cpds.getPooledConnection(dbAuth.getUser(), dbAuth.getPassword());
        Connection connection = null;
        try {
            connection = pooledConnection.getConnection();
        }
        finally {
            ConnectionUtils.attemptClose(connection);
            try {
                if (pooledConnection != null) {
                    pooledConnection.close();
                }
            }
            catch (Exception exception) {
                logger.log(MLevel.WARNING, "A PooledConnection failed to close.", exception);
            }
        }
    }
}

