/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v1.db.sql.ConnectionUtils;
import com.mchange.v2.async.AsynchronousRunner;
import com.mchange.v2.async.ThreadPoolAsynchronousRunner;
import com.mchange.v2.c3p0.ConnectionCustomizer;
import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.QueryConnectionTester;
import com.mchange.v2.c3p0.SQLWarnings;
import com.mchange.v2.c3p0.UnifiedConnectionTester;
import com.mchange.v2.c3p0.WrapperConnectionPoolDataSource;
import com.mchange.v2.c3p0.impl.AbstractC3P0PooledConnection;
import com.mchange.v2.c3p0.impl.C3P0ImplUtils;
import com.mchange.v2.c3p0.impl.C3P0PooledConnection;
import com.mchange.v2.c3p0.impl.DbAuth;
import com.mchange.v2.c3p0.impl.DefaultConnectionTester;
import com.mchange.v2.c3p0.impl.NewPooledConnection;
import com.mchange.v2.c3p0.impl.WrapperConnectionPoolDataSourceBase;
import com.mchange.v2.c3p0.stmt.DoubleMaxStatementCache;
import com.mchange.v2.c3p0.stmt.GlobalMaxOnlyStatementCache;
import com.mchange.v2.c3p0.stmt.GooGooStatementCache;
import com.mchange.v2.c3p0.stmt.PerConnectionMaxOnlyStatementCache;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.resourcepool.CannotAcquireResourceException;
import com.mchange.v2.resourcepool.ResourcePool;
import com.mchange.v2.resourcepool.ResourcePoolException;
import com.mchange.v2.resourcepool.ResourcePoolFactory;
import com.mchange.v2.resourcepool.TimeoutException;
import com.mchange.v2.sql.SqlUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public final class C3P0PooledConnectionPool {
    private static final boolean ASYNCHRONOUS_CONNECTION_EVENT_LISTENER = false;
    private static final Throwable[] EMPTY_THROWABLE_HOLDER = new Throwable[1];
    static final MLogger logger = MLog.getLogger(C3P0PooledConnectionPool.class);
    final ResourcePool rp;
    final ConnectionEventListener cl = new ConnectionEventListenerImpl();
    final ConnectionTester connectionTester;
    final GooGooStatementCache scache;
    final int checkoutTimeout;
    final AsynchronousRunner sharedTaskRunner;
    final ThrowableHolderPool thp = new ThrowableHolderPool();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    C3P0PooledConnectionPool(ConnectionPoolDataSource connectionPoolDataSource, DbAuth dbAuth, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, int n7, int n8, int n9, int n10, int n11, int n12, int n13, boolean bl2, boolean bl3, boolean bl4, int n14, int n15, ConnectionTester connectionTester, ConnectionCustomizer connectionCustomizer, String string, ResourcePoolFactory resourcePoolFactory, ThreadPoolAsynchronousRunner threadPoolAsynchronousRunner, String string2) throws SQLException {
        try {
            this.scache = n14 > 0 && n15 > 0 ? new DoubleMaxStatementCache(threadPoolAsynchronousRunner, n14, n15) : (n15 > 0 ? new PerConnectionMaxOnlyStatementCache(threadPoolAsynchronousRunner, n15) : (n14 > 0 ? new GlobalMaxOnlyStatementCache(threadPoolAsynchronousRunner, n14) : null));
            this.connectionTester = connectionTester;
            this.checkoutTimeout = n7;
            this.sharedTaskRunner = threadPoolAsynchronousRunner;
            class PooledConnectionResourcePoolManager
            implements ResourcePool.Manager {
                final boolean connectionTesterIsDefault;
                final boolean c3p0PooledConnections;
                private final /* synthetic */ ConnectionTester val$connectionTester;
                private final /* synthetic */ ConnectionPoolDataSource val$cpds;
                private final /* synthetic */ ConnectionCustomizer val$connectionCustomizer;
                private final /* synthetic */ DbAuth val$auth;
                private final /* synthetic */ String val$parentDataSourceIdentityToken;
                private final /* synthetic */ boolean val$testConnectionOnCheckout;
                private final /* synthetic */ boolean val$testConnectionOnCheckin;
                private final /* synthetic */ String val$testQuery;

                PooledConnectionResourcePoolManager(ConnectionTester connectionTester, ConnectionPoolDataSource connectionPoolDataSource, ConnectionCustomizer connectionCustomizer, DbAuth dbAuth, String string, boolean bl, boolean bl2, String string2) {
                    this.val$connectionTester = connectionTester;
                    this.val$cpds = connectionPoolDataSource;
                    this.val$connectionCustomizer = connectionCustomizer;
                    this.val$auth = dbAuth;
                    this.val$parentDataSourceIdentityToken = string;
                    this.val$testConnectionOnCheckout = bl;
                    this.val$testConnectionOnCheckin = bl2;
                    this.val$testQuery = string2;
                    this.connectionTesterIsDefault = this.val$connectionTester instanceof DefaultConnectionTester;
                    this.c3p0PooledConnections = this.val$cpds instanceof WrapperConnectionPoolDataSource;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object acquireResource() throws Exception {
                    Object object;
                    PooledConnection pooledConnection;
                    if (this.val$connectionCustomizer == null) {
                        pooledConnection = this.val$auth.equals(C3P0ImplUtils.NULL_AUTH) ? this.val$cpds.getPooledConnection() : this.val$cpds.getPooledConnection(this.val$auth.getUser(), this.val$auth.getPassword());
                    } else {
                        try {
                            object = (WrapperConnectionPoolDataSourceBase)((Object)this.val$cpds);
                            pooledConnection = this.val$auth.equals(C3P0ImplUtils.NULL_AUTH) ? ((WrapperConnectionPoolDataSourceBase)object).getPooledConnection(this.val$connectionCustomizer, this.val$parentDataSourceIdentityToken) : ((WrapperConnectionPoolDataSourceBase)object).getPooledConnection(this.val$auth.getUser(), this.val$auth.getPassword(), this.val$connectionCustomizer, this.val$parentDataSourceIdentityToken);
                        }
                        catch (ClassCastException classCastException) {
                            throw SqlUtils.toSQLException("Cannot use a ConnectionCustomizer with a non-c3p0 ConnectionPoolDataSource. ConnectionPoolDataSource: " + this.val$cpds.getClass().getName(), classCastException);
                        }
                    }
                    try {
                        if (C3P0PooledConnectionPool.this.scache != null) {
                            if (this.c3p0PooledConnections) {
                                ((AbstractC3P0PooledConnection)pooledConnection).initStatementCache(C3P0PooledConnectionPool.this.scache);
                            } else {
                                logger.warning("StatementPooling not implemented for external (non-c3p0) ConnectionPoolDataSources.");
                            }
                        }
                        object = null;
                        try {
                            object = pooledConnection.getConnection();
                            SQLWarnings.logAndClearWarnings((Connection)object);
                        }
                        finally {
                            ConnectionUtils.attemptClose((Connection)object);
                        }
                        pooledConnection.addConnectionEventListener(C3P0PooledConnectionPool.this.cl);
                        PooledConnection pooledConnection2 = pooledConnection;
                        return pooledConnection2;
                    }
                    catch (Exception exception) {
                        block20: {
                            if (logger.isLoggable(MLevel.WARNING)) {
                                logger.warning("A PooledConnection was acquired, but an Exception occurred while preparing it for use. Attempting to destroy.");
                            }
                            try {
                                this.destroyResource(pooledConnection);
                            }
                            catch (Exception exception2) {
                                if (!logger.isLoggable(MLevel.WARNING)) break block20;
                                logger.log(MLevel.WARNING, "An Exception occurred while trying to close partially acquired PooledConnection.", exception2);
                            }
                        }
                        throw exception;
                    }
                    finally {
                        if (logger.isLoggable(MLevel.FINEST)) {
                            logger.finest(this + ".acquireResource() returning. ");
                        }
                    }
                }

                public void refurbishResourceOnCheckout(Object object) throws Exception {
                    if (this.val$testConnectionOnCheckout) {
                        if (logger.isLoggable(MLevel.FINER)) {
                            this.finerLoggingTestPooledConnection(object, "CHECKOUT");
                        } else {
                            this.testPooledConnection(object);
                        }
                    }
                    if (this.val$connectionCustomizer != null) {
                        Connection connection = null;
                        try {
                            connection = ((AbstractC3P0PooledConnection)object).getPhysicalConnection();
                            this.val$connectionCustomizer.onCheckOut(connection, this.val$parentDataSourceIdentityToken);
                        }
                        catch (ClassCastException classCastException) {
                            throw SqlUtils.toSQLException("Cannot use a ConnectionCustomizer with a non-c3p0 PooledConnection. PooledConnection: " + object + "; ConnectionPoolDataSource: " + this.val$cpds.getClass().getName(), classCastException);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void refurbishResourceOnCheckin(Object object) throws Exception {
                    if (this.val$connectionCustomizer != null) {
                        Connection connection2 = null;
                        try {
                            connection2 = ((AbstractC3P0PooledConnection)object).getPhysicalConnection();
                            this.val$connectionCustomizer.onCheckIn(connection2, this.val$parentDataSourceIdentityToken);
                            SQLWarnings.logAndClearWarnings(connection2);
                        }
                        catch (ClassCastException classCastException) {
                            throw SqlUtils.toSQLException("Cannot use a ConnectionCustomizer with a non-c3p0 PooledConnection. PooledConnection: " + object + "; ConnectionPoolDataSource: " + this.val$cpds.getClass().getName(), classCastException);
                        }
                    }
                    PooledConnection pooledConnection = (PooledConnection)object;
                    Connection connection = null;
                    try {
                        pooledConnection.removeConnectionEventListener(C3P0PooledConnectionPool.this.cl);
                        connection = pooledConnection.getConnection();
                        SQLWarnings.logAndClearWarnings(connection);
                    }
                    catch (Throwable throwable) {
                        ConnectionUtils.attemptClose(connection);
                        pooledConnection.addConnectionEventListener(C3P0PooledConnectionPool.this.cl);
                        throw throwable;
                    }
                    ConnectionUtils.attemptClose(connection);
                    pooledConnection.addConnectionEventListener(C3P0PooledConnectionPool.this.cl);
                    if (!this.val$testConnectionOnCheckin) return;
                    if (logger.isLoggable(MLevel.FINER)) {
                        this.finerLoggingTestPooledConnection(object, "CHECKIN");
                        return;
                    }
                    this.testPooledConnection(object);
                }

                public void refurbishIdleResource(Object object) throws Exception {
                    if (logger.isLoggable(MLevel.FINER)) {
                        this.finerLoggingTestPooledConnection(object, "IDLE CHECK");
                    } else {
                        this.testPooledConnection(object);
                    }
                }

                private void finerLoggingTestPooledConnection(Object object, String string) throws Exception {
                    logger.finer("Testing PooledConnection [" + object + "] on " + string + ".");
                    try {
                        this.testPooledConnection(object);
                        logger.finer("Test of PooledConnection [" + object + "] on " + string + " has SUCCEEDED.");
                    }
                    catch (Exception exception) {
                        logger.log(MLevel.FINER, "Test of PooledConnection [" + object + "] on " + string + " has FAILED.", exception);
                        exception.fillInStackTrace();
                        throw exception;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                private void testPooledConnection(Object object) throws Exception {
                    int n;
                    Object object2;
                    Throwable throwable;
                    block25: {
                        Connection connection;
                        Throwable[] throwableArray;
                        PooledConnection pooledConnection;
                        block27: {
                            block26: {
                                pooledConnection = (PooledConnection)object;
                                throwableArray = EMPTY_THROWABLE_HOLDER;
                                connection = null;
                                throwable = null;
                                try {
                                    block24: {
                                        try {
                                            pooledConnection.removeConnectionEventListener(C3P0PooledConnectionPool.this.cl);
                                            connection = pooledConnection.getConnection();
                                            object2 = C3P0PooledConnectionPool.this.scache != null ? (this.val$testQuery == null && this.connectionTesterIsDefault && this.c3p0PooledConnections ? ((AbstractC3P0PooledConnection)pooledConnection).getPhysicalConnection() : connection) : (this.c3p0PooledConnections ? ((AbstractC3P0PooledConnection)pooledConnection).getPhysicalConnection() : connection);
                                            if (this.val$testQuery == null) {
                                                n = this.val$connectionTester.activeCheckConnection((Connection)object2);
                                                break block24;
                                            }
                                            if (this.val$connectionTester instanceof UnifiedConnectionTester) {
                                                throwableArray = C3P0PooledConnectionPool.this.thp.getThrowableHolder();
                                                n = ((UnifiedConnectionTester)this.val$connectionTester).activeCheckConnection((Connection)object2, this.val$testQuery, throwableArray);
                                                break block24;
                                            }
                                            if (this.val$connectionTester instanceof QueryConnectionTester) {
                                                n = ((QueryConnectionTester)this.val$connectionTester).activeCheckConnection((Connection)object2, this.val$testQuery);
                                            } else {
                                                logger.warning("[c3p0] testQuery '" + this.val$testQuery + "' ignored. Please set a ConnectionTester that implements " + "com.mchange.v2.c3p0.QueryConnectionTester, or use the " + "DefaultConnectionTester, to test with the testQuery.");
                                                n = this.val$connectionTester.activeCheckConnection((Connection)object2);
                                            }
                                        }
                                        catch (Exception exception) {
                                            logger.log(MLevel.FINE, "A Connection test failed with an Exception.", exception);
                                            n = -1;
                                            throwable = exception;
                                            Object var9_10 = null;
                                            if (throwable == null) {
                                                throwable = throwableArray[0];
                                            } else if (throwableArray[0] != null && logger.isLoggable(MLevel.FINE)) {
                                                logger.log(MLevel.FINE, "Internal Connection Test Exception", throwableArray[0]);
                                            }
                                            if (throwableArray != EMPTY_THROWABLE_HOLDER) {
                                                C3P0PooledConnectionPool.this.thp.returnThrowableHolder(throwableArray);
                                            }
                                            ConnectionUtils.attemptClose(connection);
                                            pooledConnection.addConnectionEventListener(C3P0PooledConnectionPool.this.cl);
                                            break block25;
                                        }
                                    }
                                    Object var9_9 = null;
                                    if (throwable != null) break block26;
                                }
                                catch (Throwable throwable2) {
                                    Object var9_11 = null;
                                    if (throwable == null) {
                                        throwable = throwableArray[0];
                                    } else if (throwableArray[0] != null && logger.isLoggable(MLevel.FINE)) {
                                        logger.log(MLevel.FINE, "Internal Connection Test Exception", throwableArray[0]);
                                    }
                                    if (throwableArray != EMPTY_THROWABLE_HOLDER) {
                                        C3P0PooledConnectionPool.this.thp.returnThrowableHolder(throwableArray);
                                    }
                                    ConnectionUtils.attemptClose(connection);
                                    pooledConnection.addConnectionEventListener(C3P0PooledConnectionPool.this.cl);
                                    throw throwable2;
                                }
                                throwable = throwableArray[0];
                                break block27;
                            }
                            if (throwableArray[0] != null && logger.isLoggable(MLevel.FINE)) {
                                logger.log(MLevel.FINE, "Internal Connection Test Exception", throwableArray[0]);
                            }
                        }
                        if (throwableArray != EMPTY_THROWABLE_HOLDER) {
                            C3P0PooledConnectionPool.this.thp.returnThrowableHolder(throwableArray);
                        }
                        ConnectionUtils.attemptClose(connection);
                        pooledConnection.addConnectionEventListener(C3P0PooledConnectionPool.this.cl);
                    }
                    switch (n) {
                        case 0: {
                            return;
                        }
                        case -8: {
                            C3P0PooledConnectionPool.this.rp.resetPool();
                        }
                        case -1: {
                            if (throwable == null) {
                                object2 = new SQLException("Connection is invalid");
                                throw object2;
                            }
                            object2 = SqlUtils.toSQLException("Connection is invalid", throwable);
                            throw object2;
                        }
                    }
                    throw new Error("Bad Connection Tester (" + this.val$connectionTester + ") " + "returned invalid status (" + n + ").");
                }

                public void destroyResource(Object object) throws Exception {
                    try {
                        block9: {
                            if (this.val$connectionCustomizer != null) {
                                Connection connection = null;
                                try {
                                    connection = ((AbstractC3P0PooledConnection)object).getPhysicalConnection();
                                    this.val$connectionCustomizer.onDestroy(connection, this.val$parentDataSourceIdentityToken);
                                }
                                catch (ClassCastException classCastException) {
                                    throw SqlUtils.toSQLException("Cannot use a ConnectionCustomizer with a non-c3p0 PooledConnection. PooledConnection: " + object + "; ConnectionPoolDataSource: " + this.val$cpds.getClass().getName(), classCastException);
                                }
                                catch (Exception exception) {
                                    if (!logger.isLoggable(MLevel.WARNING)) break block9;
                                    logger.log(MLevel.WARNING, "An exception occurred while executing the onDestroy() method of " + this.val$connectionCustomizer + ". c3p0 will attempt to destroy the target Connection regardless, but this issue " + " should be investigated and fixed.", exception);
                                }
                            }
                        }
                        if (logger.isLoggable(MLevel.FINER)) {
                            logger.log(MLevel.FINER, "Preparing to destroy PooledConnection: " + object);
                        }
                        ((PooledConnection)object).close();
                        if (logger.isLoggable(MLevel.FINER)) {
                            logger.log(MLevel.FINER, "Successfully destroyed PooledConnection: " + object);
                        }
                    }
                    catch (Exception exception) {
                        if (logger.isLoggable(MLevel.FINER)) {
                            logger.log(MLevel.FINER, "Failed to destroy PooledConnection: " + object);
                        }
                        throw exception;
                    }
                }
            }
            PooledConnectionResourcePoolManager pooledConnectionResourcePoolManager = new PooledConnectionResourcePoolManager(connectionTester, connectionPoolDataSource, connectionCustomizer, dbAuth, string2, bl3, bl4, string);
            ResourcePoolFactory resourcePoolFactory2 = resourcePoolFactory;
            synchronized (resourcePoolFactory2) {
                resourcePoolFactory.setMin(n);
                resourcePoolFactory.setMax(n2);
                resourcePoolFactory.setStart(n3);
                resourcePoolFactory.setIncrement(n4);
                resourcePoolFactory.setIdleResourceTestPeriod(n8 * 1000);
                resourcePoolFactory.setResourceMaxIdleTime(n9 * 1000);
                resourcePoolFactory.setExcessResourceMaxIdleTime(n10 * 1000);
                resourcePoolFactory.setResourceMaxAge(n11 * 1000);
                resourcePoolFactory.setExpirationEnforcementDelay(n12 * 1000);
                resourcePoolFactory.setDestroyOverdueResourceTime(n13 * 1000);
                resourcePoolFactory.setDebugStoreCheckoutStackTrace(bl2);
                resourcePoolFactory.setAcquisitionRetryAttempts(n5);
                resourcePoolFactory.setAcquisitionRetryDelay(n6);
                resourcePoolFactory.setBreakOnAcquisitionFailure(bl);
                this.rp = resourcePoolFactory.createPool(pooledConnectionResourcePoolManager);
            }
        }
        catch (ResourcePoolException resourcePoolException) {
            throw SqlUtils.toSQLException(resourcePoolException);
        }
    }

    public PooledConnection checkoutPooledConnection() throws SQLException {
        try {
            return (PooledConnection)this.rp.checkoutResource(this.checkoutTimeout);
        }
        catch (TimeoutException timeoutException) {
            throw SqlUtils.toSQLException("An attempt by a client to checkout a Connection has timed out.", timeoutException);
        }
        catch (CannotAcquireResourceException cannotAcquireResourceException) {
            throw SqlUtils.toSQLException("Connections could not be acquired from the underlying database!", "08001", cannotAcquireResourceException);
        }
        catch (Exception exception) {
            throw SqlUtils.toSQLException(exception);
        }
    }

    public void checkinPooledConnection(PooledConnection pooledConnection) throws SQLException {
        try {
            this.rp.checkinResource(pooledConnection);
        }
        catch (ResourcePoolException resourcePoolException) {
            throw SqlUtils.toSQLException(resourcePoolException);
        }
    }

    public float getEffectivePropertyCycle() throws SQLException {
        try {
            return (float)this.rp.getEffectiveExpirationEnforcementDelay() / 1000.0f;
        }
        catch (ResourcePoolException resourcePoolException) {
            throw SqlUtils.toSQLException(resourcePoolException);
        }
    }

    public int getNumThreadsAwaitingCheckout() throws SQLException {
        try {
            return this.rp.getNumCheckoutWaiters();
        }
        catch (ResourcePoolException resourcePoolException) {
            throw SqlUtils.toSQLException(resourcePoolException);
        }
    }

    public int getStatementCacheNumStatements() {
        return this.scache == null ? 0 : this.scache.getNumStatements();
    }

    public int getStatementCacheNumCheckedOut() {
        return this.scache == null ? 0 : this.scache.getNumStatementsCheckedOut();
    }

    public int getStatementCacheNumConnectionsWithCachedStatements() {
        return this.scache == null ? 0 : this.scache.getNumConnectionsWithCachedStatements();
    }

    public String dumpStatementCacheStatus() {
        return this.scache == null ? "Statement caching disabled." : this.scache.dumpStatementCacheStatus();
    }

    public void close() throws SQLException {
        this.close(true);
    }

    public void close(boolean bl) throws SQLException {
        Exception exception = null;
        try {
            if (this.scache != null) {
                this.scache.close();
            }
        }
        catch (SQLException sQLException) {
            exception = sQLException;
        }
        try {
            this.rp.close(bl);
        }
        catch (ResourcePoolException resourcePoolException) {
            if (exception != null && logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "An Exception occurred while closing the StatementCache.", exception);
            }
            exception = resourcePoolException;
        }
        if (exception != null) {
            throw SqlUtils.toSQLException(exception);
        }
    }

    public int getNumConnections() throws SQLException {
        try {
            return this.rp.getPoolSize();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public int getNumIdleConnections() throws SQLException {
        try {
            return this.rp.getAvailableCount();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumBusyConnections() throws SQLException {
        try {
            ResourcePool resourcePool = this.rp;
            synchronized (resourcePool) {
                return this.rp.getAwaitingCheckinCount() - this.rp.getExcludedCount();
            }
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public int getNumUnclosedOrphanedConnections() throws SQLException {
        try {
            return this.rp.getExcludedCount();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public long getStartTime() throws SQLException {
        try {
            return this.rp.getStartTime();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public long getUpTime() throws SQLException {
        try {
            return this.rp.getUpTime();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public long getNumFailedCheckins() throws SQLException {
        try {
            return this.rp.getNumFailedCheckins();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public long getNumFailedCheckouts() throws SQLException {
        try {
            return this.rp.getNumFailedCheckouts();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public long getNumFailedIdleTests() throws SQLException {
        try {
            return this.rp.getNumFailedIdleTests();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public Throwable getLastCheckinFailure() throws SQLException {
        try {
            return this.rp.getLastCheckinFailure();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public Throwable getLastCheckoutFailure() throws SQLException {
        try {
            return this.rp.getLastCheckoutFailure();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public Throwable getLastIdleTestFailure() throws SQLException {
        try {
            return this.rp.getLastIdleCheckFailure();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public Throwable getLastConnectionTestFailure() throws SQLException {
        try {
            return this.rp.getLastResourceTestFailure();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public Throwable getLastAcquisitionFailure() throws SQLException {
        try {
            return this.rp.getLastAcquisitionFailure();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public void reset() throws SQLException {
        try {
            this.rp.resetPool();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    class ConnectionEventListenerImpl
    implements ConnectionEventListener {
        ConnectionEventListenerImpl() {
        }

        public void connectionClosed(ConnectionEvent connectionEvent) {
            this.doCheckinResource(connectionEvent);
        }

        private void doCheckinResource(ConnectionEvent connectionEvent) {
            try {
                C3P0PooledConnectionPool.this.rp.checkinResource(connectionEvent.getSource());
            }
            catch (Exception exception) {
                logger.log(MLevel.WARNING, "An Exception occurred while trying to check a PooledConection into a ResourcePool.", exception);
            }
        }

        public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
            PooledConnection pooledConnection;
            if (logger.isLoggable(MLevel.FINE)) {
                logger.fine("CONNECTION ERROR OCCURRED!");
            }
            int n = (pooledConnection = (PooledConnection)connectionEvent.getSource()) instanceof C3P0PooledConnection ? ((C3P0PooledConnection)pooledConnection).getConnectionStatus() : (pooledConnection instanceof NewPooledConnection ? ((NewPooledConnection)pooledConnection).getConnectionStatus() : -1);
            int n2 = n;
            this.doMarkPoolStatus(pooledConnection, n2);
        }

        private void doMarkPoolStatus(PooledConnection pooledConnection, int n) {
            try {
                switch (n) {
                    case 0: {
                        throw new RuntimeException("connectionErrorOcccurred() should only be called for errors fatal to the Connection.");
                    }
                    case -1: {
                        C3P0PooledConnectionPool.this.rp.markBroken(pooledConnection);
                        break;
                    }
                    case -8: {
                        if (logger.isLoggable(MLevel.WARNING)) {
                            logger.warning("A ConnectionTest has failed, reporting that all previously acquired Connections are likely invalid. The pool will be reset.");
                        }
                        C3P0PooledConnectionPool.this.rp.resetPool();
                        break;
                    }
                    default: {
                        throw new RuntimeException("Bad Connection Tester (" + C3P0PooledConnectionPool.this.connectionTester + ") " + "returned invalid status (" + n + ").");
                    }
                }
            }
            catch (ResourcePoolException resourcePoolException) {
                logger.log(MLevel.WARNING, "Uh oh... our resource pool is probably broken!", resourcePoolException);
            }
        }
    }

    static final class ThrowableHolderPool {
        LinkedList l = new LinkedList();

        ThrowableHolderPool() {
        }

        synchronized Throwable[] getThrowableHolder() {
            if (this.l.size() == 0) {
                return new Throwable[1];
            }
            return (Throwable[])this.l.remove(0);
        }

        synchronized void returnThrowableHolder(Throwable[] throwableArray) {
            throwableArray[0] = null;
            this.l.add(throwableArray);
        }
    }
}

