/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.lang.ByteUtils;
import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.PoolConfig;
import com.mchange.v2.c3p0.impl.C3P0Defaults;
import com.mchange.v2.c3p0.impl.DbAuth;
import com.mchange.v2.cfg.MultiPropertiesConfig;
import com.mchange.v2.encounter.EncounterCounter;
import com.mchange.v2.encounter.EqualityEncounterCounter;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.ser.SerializableUtils;
import com.mchange.v2.sql.SqlUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;

public final class C3P0ImplUtils {
    private static final boolean CONDITIONAL_LONG_TOKENS = false;
    static final MLogger logger = MLog.getLogger(C3P0ImplUtils.class);
    public static final DbAuth NULL_AUTH = new DbAuth(null, null);
    public static final Object[] NOARGS = new Object[0];
    private static final EncounterCounter ID_TOKEN_COUNTER = new EqualityEncounterCounter();
    public static String VMID_PROPKEY = "com.mchange.v2.c3p0.VMID";
    private static final String VMID_PFX;
    static String connectionTesterClassName;
    static ConnectionTester cachedTester;
    private static final String HASM_HEADER = "HexAsciiSerializedMap";
    static /* synthetic */ Class class$java$lang$String;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String generateVmId() {
        FilterOutputStream filterOutputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            byte[] byArray;
            SecureRandom secureRandom = new SecureRandom();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            filterOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                filterOutputStream.write(InetAddress.getLocalHost().getAddress());
            }
            catch (Exception exception) {
                if (logger.isLoggable(MLevel.INFO)) {
                    logger.log(MLevel.INFO, "Failed to get local InetAddress for VMID. This is unlikely to matter. At all. We'll add some extra randomness", exception);
                }
                ((DataOutputStream)filterOutputStream).write(secureRandom.nextInt());
            }
            ((DataOutputStream)filterOutputStream).writeLong(System.currentTimeMillis());
            ((DataOutputStream)filterOutputStream).write(secureRandom.nextInt());
            int n = byteArrayOutputStream.size() % 4;
            if (n > 0) {
                int n2 = 4 - n;
                byArray = new byte[n2];
                secureRandom.nextBytes(byArray);
                filterOutputStream.write(byArray);
            }
            StringBuffer stringBuffer = new StringBuffer(32);
            byArray = byteArrayOutputStream.toByteArray();
            filterInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            int n3 = byArray.length / 4;
            for (int i = 0; i < n3; ++i) {
                int n4 = ((DataInputStream)filterInputStream).readInt();
                long l = (long)n4 & 0xFFFFFFFFL;
                stringBuffer.append(Long.toString(l, 36));
            }
            String string = stringBuffer.toString();
            return string;
        }
        catch (IOException iOException) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "Bizarro! IOException while reading/writing from ByteArray-based streams? We're skipping the VMID thing. It almost certainly doesn't matter, but please report the error.", iOException);
            }
            String string = "";
            return string;
        }
        finally {
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
            }
            catch (IOException iOException) {
                logger.log(MLevel.WARNING, "Huh? Exception close()ing a byte-array bound OutputStream.", iOException);
            }
            try {
                if (filterInputStream != null) {
                    filterInputStream.close();
                }
            }
            catch (IOException iOException) {
                logger.log(MLevel.WARNING, "Huh? Exception close()ing a byte-array bound IntputStream.", iOException);
            }
        }
    }

    public static String allocateIdentityToken(Object object) {
        long l;
        if (object == null) {
            return null;
        }
        String string = Integer.toString(System.identityHashCode(object), 16);
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(VMID_PFX);
        if (ID_TOKEN_COUNTER != null && (l = ID_TOKEN_COUNTER.encounter(string)) > 0L) {
            stringBuffer.append(string);
            stringBuffer.append('#');
            stringBuffer.append(l);
        } else {
            stringBuffer.append(string);
        }
        String string2 = stringBuffer.toString().intern();
        return string2;
    }

    public static DbAuth findAuth(Object object) throws SQLException {
        if (object == null) {
            return NULL_AUTH;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            int n = propertyDescriptorArray.length;
            for (int i = 0; i < n; ++i) {
                Method method;
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                Class<?> clazz = propertyDescriptor.getPropertyType();
                String string5 = propertyDescriptor.getName();
                if (clazz != (class$java$lang$String == null ? C3P0ImplUtils.class$("java.lang.String") : class$java$lang$String) || (method = propertyDescriptor.getReadMethod()) == null) continue;
                Object object2 = method.invoke(object, NOARGS);
                String string6 = (String)object2;
                if ("user".equals(string5)) {
                    string = string6;
                    continue;
                }
                if ("password".equals(string5)) {
                    string2 = string6;
                    continue;
                }
                if ("overrideDefaultUser".equals(string5)) {
                    string3 = string6;
                    continue;
                }
                if (!"overrideDefaultPassword".equals(string5)) continue;
                string4 = string6;
            }
            if (string3 != null) {
                return new DbAuth(string3, string4);
            }
            if (string != null) {
                return new DbAuth(string, string2);
            }
            return NULL_AUTH;
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "An exception occurred while trying to extract the default authentification info from a bean.", exception);
            }
            throw SqlUtils.toSQLException(exception);
        }
    }

    static void resetTxnState(Connection connection, boolean bl, boolean bl2, boolean bl3) throws SQLException {
        if (!bl && !connection.getAutoCommit()) {
            if (!bl2 && !bl3) {
                connection.rollback();
            }
            connection.setAutoCommit(true);
        }
    }

    public static synchronized ConnectionTester defaultConnectionTester() {
        String string = PoolConfig.defaultConnectionTesterClassName();
        if (connectionTesterClassName != null && connectionTesterClassName.equals(string)) {
            return cachedTester;
        }
        try {
            cachedTester = (ConnectionTester)Class.forName(string).newInstance();
            connectionTesterClassName = cachedTester.getClass().getName();
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "Could not load ConnectionTester " + string + ", using built in default.", exception);
            }
            cachedTester = C3P0Defaults.connectionTester();
            connectionTesterClassName = cachedTester.getClass().getName();
        }
        return cachedTester;
    }

    public static boolean supportsMethod(Object object, String string, Class[] classArray) {
        try {
            return object.getClass().getMethod(string, classArray) != null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        catch (SecurityException securityException) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "We were denied access in a check of whether " + object + " supports method " + string + ". Prob means external clients have no access, returning false.", securityException);
            }
            return false;
        }
    }

    public static String createUserOverridesAsString(Map map) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(HASM_HEADER);
        stringBuffer.append('[');
        stringBuffer.append(ByteUtils.toHexAscii(SerializableUtils.toByteArray(map)));
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static Map parseUserOverridesAsString(String string) throws IOException, ClassNotFoundException {
        if (string != null) {
            String string2 = string.substring(HASM_HEADER.length() + 1, string.length() - 1);
            byte[] byArray = ByteUtils.fromHexAscii(string2);
            return Collections.unmodifiableMap((Map)SerializableUtils.fromByteArray(byArray));
        }
        return Collections.EMPTY_MAP;
    }

    private C3P0ImplUtils() {
    }

    static {
        String string = MultiPropertiesConfig.readVmConfig().getProperty(VMID_PROPKEY);
        VMID_PFX = string == null || (string = string.trim()).equals("") || string.equals("AUTO") ? C3P0ImplUtils.generateVmId() + '|' : (string.equals("NONE") ? "" : string + "|");
        connectionTesterClassName = null;
        cachedTester = null;
    }
}

