/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.lang.ThrowableUtils;
import com.mchange.v2.c3p0.C3P0Registry;
import com.mchange.v2.c3p0.PooledDataSource;
import com.mchange.v2.c3p0.cfg.C3P0Config;
import com.mchange.v2.c3p0.impl.C3P0PooledConnectionPool;
import com.mchange.v2.c3p0.impl.C3P0PooledConnectionPoolManager;
import com.mchange.v2.c3p0.impl.DbAuth;
import com.mchange.v2.c3p0.impl.PoolBackedDataSourceBase;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public abstract class AbstractPoolBackedDataSource
extends PoolBackedDataSourceBase
implements PooledDataSource {
    static final MLogger logger = MLog.getLogger(AbstractPoolBackedDataSource.class);
    static final String NO_CPDS_ERR_MSG = "Attempted to use an uninitialized PoolBackedDataSource. Please call setConnectionPoolDataSource( ... ) to initialize.";
    transient C3P0PooledConnectionPoolManager poolManager;
    transient boolean is_closed = false;
    private static final long serialVersionUID = 1L;
    private static final short VERSION = 1;

    protected AbstractPoolBackedDataSource(boolean bl) {
        super(bl);
        this.setUpPropertyEvents();
    }

    protected AbstractPoolBackedDataSource(String string) {
        this(true);
        this.initializeNamedConfig(string);
    }

    private void setUpPropertyEvents() {
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                AbstractPoolBackedDataSource.this.resetPoolManager();
            }
        };
        this.addPropertyChangeListener(propertyChangeListener);
    }

    protected void initializeNamedConfig(String string) {
        block4: {
            try {
                if (string != null) {
                    C3P0Config.bindNamedConfigToBean(this, string);
                    if (this.getDataSourceName().equals(this.getIdentityToken())) {
                        this.setDataSourceName(string);
                    }
                }
            }
            catch (Exception exception) {
                if (!logger.isLoggable(MLevel.WARNING)) break block4;
                logger.log(MLevel.WARNING, "Error binding PoolBackedDataSource to named-config '" + string + "'. Some default-config values may be used.", exception);
            }
        }
    }

    public String getDataSourceName() {
        String string = super.getDataSourceName();
        if (string == null) {
            string = this.getIdentityToken();
        }
        return string;
    }

    public Connection getConnection() throws SQLException {
        PooledConnection pooledConnection = this.getPoolManager().getPool().checkoutPooledConnection();
        return pooledConnection.getConnection();
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        PooledConnection pooledConnection = this.getPoolManager().getPool(string, string2).checkoutPooledConnection();
        return pooledConnection.getConnection();
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.assertCpds().getLogWriter();
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.assertCpds().setLogWriter(printWriter);
    }

    public int getLoginTimeout() throws SQLException {
        return this.assertCpds().getLoginTimeout();
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.assertCpds().setLoginTimeout(n);
    }

    public int getNumConnections() throws SQLException {
        return this.getPoolManager().getPool().getNumConnections();
    }

    public int getNumIdleConnections() throws SQLException {
        return this.getPoolManager().getPool().getNumIdleConnections();
    }

    public int getNumBusyConnections() throws SQLException {
        return this.getPoolManager().getPool().getNumBusyConnections();
    }

    public int getNumUnclosedOrphanedConnections() throws SQLException {
        return this.getPoolManager().getPool().getNumUnclosedOrphanedConnections();
    }

    public int getNumConnectionsDefaultUser() throws SQLException {
        return this.getNumConnections();
    }

    public int getNumIdleConnectionsDefaultUser() throws SQLException {
        return this.getNumIdleConnections();
    }

    public int getNumBusyConnectionsDefaultUser() throws SQLException {
        return this.getNumBusyConnections();
    }

    public int getNumUnclosedOrphanedConnectionsDefaultUser() throws SQLException {
        return this.getNumUnclosedOrphanedConnections();
    }

    public int getStatementCacheNumStatementsDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getStatementCacheNumStatements();
    }

    public int getStatementCacheNumCheckedOutDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getStatementCacheNumCheckedOut();
    }

    public int getStatementCacheNumConnectionsWithCachedStatementsDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getStatementCacheNumConnectionsWithCachedStatements();
    }

    public float getEffectivePropertyCycleDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getEffectivePropertyCycle();
    }

    public long getStartTimeMillisDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getStartTime();
    }

    public long getUpTimeMillisDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getUpTime();
    }

    public long getNumFailedCheckinsDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getNumFailedCheckins();
    }

    public long getNumFailedCheckoutsDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getNumFailedCheckouts();
    }

    public long getNumFailedIdleTestsDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getNumFailedIdleTests();
    }

    public int getNumThreadsAwaitingCheckoutDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getNumThreadsAwaitingCheckout();
    }

    public int getThreadPoolSize() throws SQLException {
        return this.getPoolManager().getThreadPoolSize();
    }

    public int getThreadPoolNumActiveThreads() throws SQLException {
        return this.getPoolManager().getThreadPoolNumActiveThreads();
    }

    public int getThreadPoolNumIdleThreads() throws SQLException {
        return this.getPoolManager().getThreadPoolNumIdleThreads();
    }

    public int getThreadPoolNumTasksPending() throws SQLException {
        return this.getPoolManager().getThreadPoolNumTasksPending();
    }

    public String sampleThreadPoolStackTraces() throws SQLException {
        return this.getPoolManager().getThreadPoolStackTraces();
    }

    public String sampleThreadPoolStatus() throws SQLException {
        return this.getPoolManager().getThreadPoolStatus();
    }

    public String sampleStatementCacheStatusDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().dumpStatementCacheStatus();
    }

    public String sampleStatementCacheStatus(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).dumpStatementCacheStatus();
    }

    public Throwable getLastAcquisitionFailureDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getLastAcquisitionFailure();
    }

    public Throwable getLastCheckinFailureDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getLastCheckinFailure();
    }

    public Throwable getLastCheckoutFailureDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getLastCheckoutFailure();
    }

    public Throwable getLastIdleTestFailureDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getLastIdleTestFailure();
    }

    public Throwable getLastConnectionTestFailureDefaultUser() throws SQLException {
        return this.getPoolManager().getPool().getLastConnectionTestFailure();
    }

    public Throwable getLastAcquisitionFailure(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getLastAcquisitionFailure();
    }

    public Throwable getLastCheckinFailure(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getLastCheckinFailure();
    }

    public Throwable getLastCheckoutFailure(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getLastCheckoutFailure();
    }

    public Throwable getLastIdleTestFailure(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getLastIdleTestFailure();
    }

    public Throwable getLastConnectionTestFailure(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getLastConnectionTestFailure();
    }

    public int getNumThreadsAwaitingCheckout(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getNumThreadsAwaitingCheckout();
    }

    public String sampleLastAcquisitionFailureStackTraceDefaultUser() throws SQLException {
        Throwable throwable = this.getLastAcquisitionFailureDefaultUser();
        return throwable == null ? null : ThrowableUtils.extractStackTrace(throwable);
    }

    public String sampleLastCheckinFailureStackTraceDefaultUser() throws SQLException {
        Throwable throwable = this.getLastCheckinFailureDefaultUser();
        return throwable == null ? null : ThrowableUtils.extractStackTrace(throwable);
    }

    public String sampleLastCheckoutFailureStackTraceDefaultUser() throws SQLException {
        Throwable throwable = this.getLastCheckoutFailureDefaultUser();
        return throwable == null ? null : ThrowableUtils.extractStackTrace(throwable);
    }

    public String sampleLastIdleTestFailureStackTraceDefaultUser() throws SQLException {
        Throwable throwable = this.getLastIdleTestFailureDefaultUser();
        return throwable == null ? null : ThrowableUtils.extractStackTrace(throwable);
    }

    public String sampleLastConnectionTestFailureStackTraceDefaultUser() throws SQLException {
        Throwable throwable = this.getLastConnectionTestFailureDefaultUser();
        return throwable == null ? null : ThrowableUtils.extractStackTrace(throwable);
    }

    public String sampleLastAcquisitionFailureStackTrace(String string, String string2) throws SQLException {
        Throwable throwable = this.getLastAcquisitionFailure(string, string2);
        return throwable == null ? null : ThrowableUtils.extractStackTrace(throwable);
    }

    public String sampleLastCheckinFailureStackTrace(String string, String string2) throws SQLException {
        Throwable throwable = this.getLastCheckinFailure(string, string2);
        return throwable == null ? null : ThrowableUtils.extractStackTrace(throwable);
    }

    public String sampleLastCheckoutFailureStackTrace(String string, String string2) throws SQLException {
        Throwable throwable = this.getLastCheckoutFailure(string, string2);
        return throwable == null ? null : ThrowableUtils.extractStackTrace(throwable);
    }

    public String sampleLastIdleTestFailureStackTrace(String string, String string2) throws SQLException {
        Throwable throwable = this.getLastIdleTestFailure(string, string2);
        return throwable == null ? null : ThrowableUtils.extractStackTrace(throwable);
    }

    public String sampleLastConnectionTestFailureStackTrace(String string, String string2) throws SQLException {
        Throwable throwable = this.getLastConnectionTestFailure(string, string2);
        return throwable == null ? null : ThrowableUtils.extractStackTrace(throwable);
    }

    public void softResetDefaultUser() throws SQLException {
        this.getPoolManager().getPool().reset();
    }

    public int getNumConnections(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getNumConnections();
    }

    public int getNumIdleConnections(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getNumIdleConnections();
    }

    public int getNumBusyConnections(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getNumBusyConnections();
    }

    public int getNumUnclosedOrphanedConnections(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getNumUnclosedOrphanedConnections();
    }

    public int getStatementCacheNumStatements(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getStatementCacheNumStatements();
    }

    public int getStatementCacheNumCheckedOut(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getStatementCacheNumCheckedOut();
    }

    public int getStatementCacheNumConnectionsWithCachedStatements(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getStatementCacheNumConnectionsWithCachedStatements();
    }

    public float getEffectivePropertyCycle(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getEffectivePropertyCycle();
    }

    public long getStartTimeMillis(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getStartTime();
    }

    public long getUpTimeMillis(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getUpTime();
    }

    public long getNumFailedCheckins(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getNumFailedCheckins();
    }

    public long getNumFailedCheckouts(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getNumFailedCheckouts();
    }

    public long getNumFailedIdleTests(String string, String string2) throws SQLException {
        return this.assertAuthPool(string, string2).getNumFailedIdleTests();
    }

    public void softReset(String string, String string2) throws SQLException {
        this.assertAuthPool(string, string2).reset();
    }

    public int getNumBusyConnectionsAllUsers() throws SQLException {
        return this.getPoolManager().getNumBusyConnectionsAllAuths();
    }

    public int getNumIdleConnectionsAllUsers() throws SQLException {
        return this.getPoolManager().getNumIdleConnectionsAllAuths();
    }

    public int getNumConnectionsAllUsers() throws SQLException {
        return this.getPoolManager().getNumConnectionsAllAuths();
    }

    public int getNumUnclosedOrphanedConnectionsAllUsers() throws SQLException {
        return this.getPoolManager().getNumUnclosedOrphanedConnectionsAllAuths();
    }

    public int getStatementCacheNumStatementsAllUsers() throws SQLException {
        return this.getPoolManager().getStatementCacheNumStatementsAllUsers();
    }

    public int getStatementCacheNumCheckedOutStatementsAllUsers() throws SQLException {
        return this.getPoolManager().getStatementCacheNumCheckedOutStatementsAllUsers();
    }

    public synchronized int getStatementCacheNumConnectionsWithCachedStatementsAllUsers() throws SQLException {
        return this.getPoolManager().getStatementCacheNumConnectionsWithCachedStatementsAllUsers();
    }

    public void softResetAllUsers() throws SQLException {
        this.getPoolManager().softResetAllAuths();
    }

    public int getNumUserPools() throws SQLException {
        return this.getPoolManager().getNumManagedAuths();
    }

    public Collection getAllUsers() throws SQLException {
        LinkedList<String> linkedList = new LinkedList<String>();
        Set set = this.getPoolManager().getManagedAuths();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            linkedList.add(((DbAuth)iterator.next()).getUser());
        }
        return Collections.unmodifiableList(linkedList);
    }

    public synchronized void hardReset() {
        this.resetPoolManager();
    }

    public synchronized void close() {
        this.resetPoolManager();
        this.is_closed = true;
        C3P0Registry.markClosed(this);
        if (logger.isLoggable(MLevel.FINEST)) {
            logger.log(MLevel.FINEST, this.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(this)) + " has been closed. ", new Exception("DEBUG STACK TRACE for PoolBackedDataSource.close()."));
        }
    }

    public void close(boolean bl) {
        this.close();
    }

    public synchronized void resetPoolManager() {
        this.resetPoolManager(true);
    }

    public synchronized void resetPoolManager(boolean bl) {
        if (this.poolManager != null) {
            this.poolManager.close(bl);
            this.poolManager = null;
        }
    }

    private synchronized ConnectionPoolDataSource assertCpds() throws SQLException {
        if (this.is_closed) {
            throw new SQLException(this + " has been closed() -- you can no longer use it.");
        }
        ConnectionPoolDataSource connectionPoolDataSource = this.getConnectionPoolDataSource();
        if (connectionPoolDataSource == null) {
            throw new SQLException(NO_CPDS_ERR_MSG);
        }
        return connectionPoolDataSource;
    }

    private synchronized C3P0PooledConnectionPoolManager getPoolManager() throws SQLException {
        if (this.poolManager == null) {
            ConnectionPoolDataSource connectionPoolDataSource = this.assertCpds();
            this.poolManager = new C3P0PooledConnectionPoolManager(connectionPoolDataSource, null, null, this.getNumHelperThreads(), this.getIdentityToken());
            if (logger.isLoggable(MLevel.INFO)) {
                logger.info("Initializing c3p0 pool... " + this.toString());
            }
        }
        return this.poolManager;
    }

    private C3P0PooledConnectionPool assertAuthPool(String string, String string2) throws SQLException {
        C3P0PooledConnectionPool c3P0PooledConnectionPool = this.getPoolManager().getPool(string, string2, false);
        if (c3P0PooledConnectionPool == null) {
            throw new SQLException("No pool has been yet been established for Connections authenticated by user '" + string + "' with the password provided. [Use getConnection( username, password ) " + "to initialize such a pool.]");
        }
        return c3P0PooledConnectionPool;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeShort(1);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        short s = objectInputStream.readShort();
        switch (s) {
            case 1: {
                this.setUpPropertyEvents();
                break;
            }
            default: {
                throw new IOException("Unsupported Serialized Version: " + s);
            }
        }
    }
}

