/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.cfg;

import com.mchange.v2.c3p0.cfg.C3P0Config;
import com.mchange.v2.c3p0.cfg.NamedScope;
import com.mchange.v2.c3p0.impl.C3P0Defaults;
import com.mchange.v2.cfg.MultiPropertiesConfig;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;

public final class C3P0ConfigUtils {
    public static final String PROPS_FILE_RSRC_PATH = "/c3p0.properties";
    public static final String PROPS_FILE_PROP_PFX = "c3p0.";
    public static final int PROPS_FILE_PROP_PFX_LEN = 5;
    private static final String[] MISSPELL_PFXS = new String[]{"/c3pO", "/c3po", "/C3P0", "/C3PO"};
    static final MLogger logger = MLog.getLogger(C3P0ConfigUtils.class);

    public static HashMap extractHardcodedC3P0Defaults(boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            Method[] methodArray = C3P0Defaults.class.getMethods();
            int n = methodArray.length;
            for (int i = 0; i < n; ++i) {
                Method method = methodArray[i];
                int n2 = method.getModifiers();
                if ((n2 & 1) == 0 || (n2 & 8) == 0 || method.getParameterTypes().length != 0) continue;
                if (bl) {
                    Object object = method.invoke(null, null);
                    if (object == null) continue;
                    hashMap.put(method.getName(), String.valueOf(object));
                    continue;
                }
                hashMap.put(method.getName(), method.invoke(null, null));
            }
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, "Failed to extract hardcoded default config!?", exception);
        }
        return hashMap;
    }

    public static HashMap extractHardcodedC3P0Defaults() {
        return C3P0ConfigUtils.extractHardcodedC3P0Defaults(true);
    }

    public static HashMap extractC3P0PropertiesResources() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Properties properties = C3P0ConfigUtils.findAllC3P0Properties();
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)properties.get(string);
            if (!string.startsWith(PROPS_FILE_PROP_PFX)) continue;
            hashMap.put(string.substring(5).trim(), string2.trim());
        }
        return hashMap;
    }

    public static C3P0Config configFromFlatDefaults(HashMap hashMap) {
        NamedScope namedScope = new NamedScope();
        namedScope.props.putAll(hashMap);
        HashMap hashMap2 = new HashMap();
        return new C3P0Config(namedScope, hashMap2);
    }

    public static String getPropFileConfigProperty(String string) {
        return MultiPropertiesConfig.readVmConfig().getProperty(string);
    }

    private static Properties findResourceProperties() {
        return MultiPropertiesConfig.readVmConfig().getPropertiesByResourcePath(PROPS_FILE_RSRC_PATH);
    }

    private static Properties findAllC3P0Properties() {
        return MultiPropertiesConfig.readVmConfig().getPropertiesByPrefix("c3p0");
    }

    static Properties findAllC3P0SystemProperties() {
        Properties properties = new Properties();
        SecurityException securityException = null;
        try {
            Iterator iterator = C3P0Defaults.getKnownProperties().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = PROPS_FILE_PROP_PFX + string;
                String string3 = System.getProperty(string2);
                if (string3 == null || string3.trim().length() <= 0) continue;
                properties.put(string, string3);
            }
        }
        catch (SecurityException securityException2) {
            securityException = securityException2;
        }
        return properties;
    }

    private C3P0ConfigUtils() {
    }

    static {
        if (logger.isLoggable(MLevel.WARNING) && C3P0ConfigUtils.class.getResource(PROPS_FILE_RSRC_PATH) == null) {
            for (int i = 0; i < MISSPELL_PFXS.length; ++i) {
                String string = MISSPELL_PFXS[i] + ".properties";
                if ((class$com$mchange$v2$c3p0$cfg$C3P0ConfigUtils == null ? C3P0ConfigUtils.class$("com.mchange.v2.c3p0.cfg.C3P0ConfigUtils") : class$com$mchange$v2$c3p0$cfg$C3P0ConfigUtils).getResource(MISSPELL_PFXS[i] + ".properties") == null) continue;
                logger.warning("POSSIBLY MISSPELLED c3p0.properties CONFIG RESOURCE FOUND. Please ensure the file name is c3p0.properties, all lower case, with the digit 0 (NOT the letter O) in c3p0. It should be placed  in the top level of c3p0's effective classpath.");
                break;
            }
        }
    }
}

