/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.cfg;

import com.mchange.v1.lang.BooleanUtils;
import com.mchange.v2.beans.BeansUtils;
import com.mchange.v2.c3p0.cfg.C3P0ConfigFinder;
import com.mchange.v2.c3p0.cfg.C3P0ConfigUtils;
import com.mchange.v2.c3p0.cfg.DefaultC3P0ConfigFinder;
import com.mchange.v2.c3p0.cfg.NamedScope;
import com.mchange.v2.c3p0.impl.C3P0Defaults;
import com.mchange.v2.c3p0.impl.C3P0ImplUtils;
import com.mchange.v2.cfg.MultiPropertiesConfig;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class C3P0Config {
    public static final String CFG_FINDER_CLASSNAME_KEY = "com.mchange.v2.c3p0.cfg.finder";
    public static final String DEFAULT_CONFIG_NAME = "default";
    public static final C3P0Config MAIN;
    static final MLogger logger;
    static final Class[] SUOAS_ARGS;
    static final Collection SKIP_BIND_PROPS;
    NamedScope defaultConfig;
    HashMap configNamesToNamedScopes;

    private static void warnOnUnknownProperties(C3P0Config c3P0Config) {
        C3P0Config.warnOnUnknownProperties(c3P0Config.defaultConfig);
        Iterator iterator = c3P0Config.configNamesToNamedScopes.values().iterator();
        while (iterator.hasNext()) {
            C3P0Config.warnOnUnknownProperties((NamedScope)iterator.next());
        }
    }

    private static void warnOnUnknownProperties(NamedScope namedScope) {
        C3P0Config.warnOnUnknownProperties(namedScope.props);
        Iterator iterator = namedScope.userNamesToOverrides.values().iterator();
        while (iterator.hasNext()) {
            C3P0Config.warnOnUnknownProperties((Map)iterator.next());
        }
    }

    private static void warnOnUnknownProperties(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (C3P0Defaults.isKnownProperty(string) || !logger.isLoggable(MLevel.WARNING)) continue;
            logger.log(MLevel.WARNING, "Unknown c3p0-config property: " + string);
        }
    }

    public static String getUnspecifiedUserProperty(String string, String string2) {
        String string3 = null;
        if (string2 == null) {
            string3 = (String)C3P0Config.MAIN.defaultConfig.props.get(string);
        } else {
            NamedScope namedScope = (NamedScope)C3P0Config.MAIN.configNamesToNamedScopes.get(string2);
            if (namedScope != null) {
                string3 = (String)namedScope.props.get(string);
            } else {
                logger.warning("named-config with name '" + string2 + "' does not exist. Using default-config for property '" + string + "'.");
            }
            if (string3 == null) {
                string3 = (String)C3P0Config.MAIN.defaultConfig.props.get(string);
            }
        }
        return string3;
    }

    public static Map getUnspecifiedUserProperties(String string) {
        HashMap hashMap = new HashMap();
        hashMap.putAll(C3P0Config.MAIN.defaultConfig.props);
        if (string != null) {
            NamedScope namedScope = (NamedScope)C3P0Config.MAIN.configNamesToNamedScopes.get(string);
            if (namedScope != null) {
                hashMap.putAll(namedScope.props);
            } else {
                logger.warning("named-config with name '" + string + "' does not exist. Using default-config.");
            }
        }
        return hashMap;
    }

    public static Map getUserOverrides(String string) {
        HashMap hashMap = new HashMap();
        NamedScope namedScope = null;
        if (string != null) {
            namedScope = (NamedScope)C3P0Config.MAIN.configNamesToNamedScopes.get(string);
        }
        hashMap.putAll(C3P0Config.MAIN.defaultConfig.userNamesToOverrides);
        if (namedScope != null) {
            hashMap.putAll(namedScope.userNamesToOverrides);
        }
        return hashMap.isEmpty() ? null : hashMap;
    }

    public static String getUserOverridesAsString(String string) throws IOException {
        Map map = C3P0Config.getUserOverrides(string);
        if (map == null) {
            return null;
        }
        return C3P0ImplUtils.createUserOverridesAsString(map).intern();
    }

    public static void bindNamedConfigToBean(Object object, String string) throws IntrospectionException {
        block3: {
            Map map = C3P0Config.getUnspecifiedUserProperties(string);
            BeansUtils.overwriteAccessiblePropertiesFromMap(map, object, false, SKIP_BIND_PROPS, true, MLevel.FINEST, MLevel.WARNING, false);
            try {
                Method method = object.getClass().getMethod("setUserOverridesAsString", SUOAS_ARGS);
                method.invoke(object, C3P0Config.getUserOverridesAsString(string));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (Exception exception) {
                if (!logger.isLoggable(MLevel.WARNING)) break block3;
                logger.log(MLevel.WARNING, "An exception occurred while trying to bind user overrides for named config '" + string + "'. Only default user configs " + "will be used.", exception);
            }
        }
    }

    public static String initializeUserOverridesAsString() {
        try {
            return C3P0Config.getUserOverridesAsString(null);
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "Error initializing default user overrides. User overrides may be ignored.", exception);
            }
            return null;
        }
    }

    public static String initializeStringPropertyVar(String string, String string2) {
        String string3 = C3P0Config.getUnspecifiedUserProperty(string, null);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public static int initializeIntPropertyVar(String string, int n) {
        boolean bl = false;
        int n2 = -1;
        String string2 = C3P0Config.getUnspecifiedUserProperty(string, null);
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2.trim());
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                logger.info("'" + string2 + "' is not a legal value for property '" + string + "'. Using default value: " + n);
            }
        }
        if (!bl) {
            n2 = n;
        }
        return n2;
    }

    public static boolean initializeBooleanPropertyVar(String string, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = C3P0Config.getUnspecifiedUserProperty(string, null);
        if (string2 != null) {
            try {
                bl3 = BooleanUtils.parseBoolean(string2.trim());
                bl2 = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.info("'" + string2 + "' is not a legal value for property '" + string + "'. Using default value: " + bl);
            }
        }
        if (!bl2) {
            bl3 = bl;
        }
        return bl3;
    }

    C3P0Config(NamedScope namedScope, HashMap hashMap) {
        this.defaultConfig = namedScope;
        this.configNamesToNamedScopes = hashMap;
    }

    static {
        C3P0Config c3P0Config;
        C3P0ConfigFinder c3P0ConfigFinder;
        block7: {
            logger = MLog.getLogger(C3P0Config.class);
            String string = MultiPropertiesConfig.readVmConfig().getProperty(CFG_FINDER_CLASSNAME_KEY);
            c3P0ConfigFinder = null;
            try {
                if (string != null) {
                    c3P0ConfigFinder = (C3P0ConfigFinder)Class.forName(string).newInstance();
                }
            }
            catch (Exception exception) {
                if (!logger.isLoggable(MLevel.WARNING)) break block7;
                logger.log(MLevel.WARNING, "Could not load specified C3P0ConfigFinder class'" + string + "'.", exception);
            }
        }
        try {
            if (c3P0ConfigFinder == null) {
                Class.forName("org.w3c.dom.Node");
                Class.forName("com.mchange.v2.c3p0.cfg.C3P0ConfigXmlUtils");
                c3P0ConfigFinder = new DefaultC3P0ConfigFinder();
            }
            c3P0Config = c3P0ConfigFinder.findConfig();
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "XML configuration disabled! Verify that standard XML libs are available.", exception);
            }
            HashMap hashMap = C3P0ConfigUtils.extractHardcodedC3P0Defaults();
            hashMap.putAll(C3P0ConfigUtils.extractC3P0PropertiesResources());
            c3P0Config = C3P0ConfigUtils.configFromFlatDefaults(hashMap);
        }
        MAIN = c3P0Config;
        C3P0Config.warnOnUnknownProperties(MAIN);
        SUOAS_ARGS = new Class[]{String.class};
        SKIP_BIND_PROPS = Arrays.asList("loginTimeout", "properties");
    }
}

