/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0;

import com.mchange.v2.c3p0.ConnectionCustomizer;
import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.cfg.C3P0Config;
import com.mchange.v2.c3p0.impl.C3P0ImplUtils;
import com.mchange.v2.c3p0.impl.C3P0PooledConnection;
import com.mchange.v2.c3p0.impl.NewPooledConnection;
import com.mchange.v2.c3p0.impl.WrapperConnectionPoolDataSourceBase;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;

public final class WrapperConnectionPoolDataSource
extends WrapperConnectionPoolDataSourceBase
implements ConnectionPoolDataSource {
    static final MLogger logger = MLog.getLogger(WrapperConnectionPoolDataSource.class);
    ConnectionTester connectionTester;
    Map userOverrides;

    public WrapperConnectionPoolDataSource(boolean bl) {
        block2: {
            super(bl);
            this.connectionTester = C3P0ImplUtils.defaultConnectionTester();
            this.setUpPropertyListeners();
            try {
                this.userOverrides = C3P0ImplUtils.parseUserOverridesAsString(this.getUserOverridesAsString());
            }
            catch (Exception exception) {
                if (!logger.isLoggable(MLevel.WARNING)) break block2;
                logger.log(MLevel.WARNING, "Failed to parse stringified userOverrides. " + this.getUserOverridesAsString(), exception);
            }
        }
    }

    public WrapperConnectionPoolDataSource() {
        this(true);
    }

    private void setUpPropertyListeners() {
        VetoableChangeListener vetoableChangeListener = new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                String string = propertyChangeEvent.getPropertyName();
                Object object = propertyChangeEvent.getNewValue();
                if ("connectionTesterClassName".equals(string)) {
                    try {
                        WrapperConnectionPoolDataSource.this.recreateConnectionTester((String)object);
                    }
                    catch (Exception exception) {
                        if (logger.isLoggable(MLevel.WARNING)) {
                            logger.log(MLevel.WARNING, "Failed to create ConnectionTester of class " + object, exception);
                        }
                        throw new PropertyVetoException("Could not instantiate connection tester class with name '" + object + "'.", propertyChangeEvent);
                    }
                }
                if ("userOverridesAsString".equals(string)) {
                    try {
                        WrapperConnectionPoolDataSource.this.userOverrides = C3P0ImplUtils.parseUserOverridesAsString((String)object);
                    }
                    catch (Exception exception) {
                        if (logger.isLoggable(MLevel.WARNING)) {
                            logger.log(MLevel.WARNING, "Failed to parse stringified userOverrides. " + object, exception);
                        }
                        throw new PropertyVetoException("Failed to parse stringified userOverrides. " + object, propertyChangeEvent);
                    }
                }
            }
        };
        this.addVetoableChangeListener(vetoableChangeListener);
    }

    public WrapperConnectionPoolDataSource(String string) {
        block3: {
            this();
            try {
                if (string != null) {
                    C3P0Config.bindNamedConfigToBean(this, string);
                }
            }
            catch (Exception exception) {
                if (!logger.isLoggable(MLevel.WARNING)) break block3;
                logger.log(MLevel.WARNING, "Error binding WrapperConnectionPoolDataSource to named-config '" + string + "'. Some default-config values may be used.", exception);
            }
        }
    }

    public PooledConnection getPooledConnection() throws SQLException {
        return this.getPooledConnection((ConnectionCustomizer)null, null);
    }

    protected PooledConnection getPooledConnection(ConnectionCustomizer connectionCustomizer, String string) throws SQLException {
        DataSource dataSource = this.getNestedDataSource();
        if (dataSource == null) {
            throw new SQLException("No standard DataSource has been set beneath this wrapper! [ nestedDataSource == null ]");
        }
        Connection connection = dataSource.getConnection();
        if (connection == null) {
            throw new SQLException("An (unpooled) DataSource returned null from its getConnection() method! DataSource: " + this.getNestedDataSource());
        }
        if (this.isUsesTraditionalReflectiveProxies()) {
            return new C3P0PooledConnection(connection, this.connectionTester, this.isAutoCommitOnClose(), this.isForceIgnoreUnresolvedTransactions(), connectionCustomizer, string);
        }
        return new NewPooledConnection(connection, this.connectionTester, this.isAutoCommitOnClose(), this.isForceIgnoreUnresolvedTransactions(), this.getPreferredTestQuery(), connectionCustomizer, string);
    }

    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        return this.getPooledConnection(string, string2, null, null);
    }

    protected PooledConnection getPooledConnection(String string, String string2, ConnectionCustomizer connectionCustomizer, String string3) throws SQLException {
        DataSource dataSource = this.getNestedDataSource();
        if (dataSource == null) {
            throw new SQLException("No standard DataSource has been set beneath this wrapper! [ nestedDataSource == null ]");
        }
        Connection connection = dataSource.getConnection(string, string2);
        if (connection == null) {
            throw new SQLException("An (unpooled) DataSource returned null from its getConnection() method! DataSource: " + this.getNestedDataSource());
        }
        if (this.isUsesTraditionalReflectiveProxies()) {
            return new C3P0PooledConnection(connection, this.connectionTester, this.isAutoCommitOnClose(), this.isForceIgnoreUnresolvedTransactions(), connectionCustomizer, string3);
        }
        return new NewPooledConnection(connection, this.connectionTester, this.isAutoCommitOnClose(), this.isForceIgnoreUnresolvedTransactions(), this.getPreferredTestQuery(), connectionCustomizer, string3);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.getNestedDataSource().getLogWriter();
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.getNestedDataSource().setLogWriter(printWriter);
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.getNestedDataSource().setLoginTimeout(n);
    }

    public int getLoginTimeout() throws SQLException {
        return this.getNestedDataSource().getLoginTimeout();
    }

    public String getUser() {
        try {
            return C3P0ImplUtils.findAuth(this.getNestedDataSource()).getUser();
        }
        catch (SQLException sQLException) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "An Exception occurred while trying to find the 'user' property from our nested DataSource. Defaulting to no specified username.", sQLException);
            }
            return null;
        }
    }

    public String getPassword() {
        try {
            return C3P0ImplUtils.findAuth(this.getNestedDataSource()).getPassword();
        }
        catch (SQLException sQLException) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "An Exception occurred while trying to find the 'password' property from our nested DataSource. Defaulting to no specified password.", sQLException);
            }
            return null;
        }
    }

    public Map getUserOverrides() {
        return this.userOverrides;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }

    protected String extraToStringInfo() {
        if (this.userOverrides != null) {
            return "; userOverrides: " + this.userOverrides.toString();
        }
        return null;
    }

    private synchronized void recreateConnectionTester(String string) throws Exception {
        ConnectionTester connectionTester;
        this.connectionTester = string != null ? (connectionTester = (ConnectionTester)Class.forName(string).newInstance()) : C3P0ImplUtils.defaultConnectionTester();
    }
}

