/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0;

import com.mchange.v2.c3p0.cfg.C3P0Config;
import com.mchange.v2.c3p0.impl.DriverManagerDataSourceBase;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;

public final class DriverManagerDataSource
extends DriverManagerDataSourceBase
implements DataSource {
    static final MLogger logger = MLog.getLogger(DriverManagerDataSource.class);
    Driver driver;
    boolean driver_class_loaded = false;
    private static final long serialVersionUID = 1L;
    private static final short VERSION = 1;

    public DriverManagerDataSource() {
        this(true);
    }

    public DriverManagerDataSource(boolean bl) {
        super(bl);
        this.setUpPropertyListeners();
        String string = C3P0Config.initializeStringPropertyVar("user", null);
        String string2 = C3P0Config.initializeStringPropertyVar("password", null);
        if (string != null) {
            this.setUser(string);
        }
        if (string2 != null) {
            this.setPassword(string2);
        }
    }

    private void setUpPropertyListeners() {
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object = propertyChangeEvent.getNewValue();
                if ("driverClass".equals(propertyChangeEvent.getPropertyName())) {
                    DriverManagerDataSource.this.setDriverClassLoaded(false);
                }
            }
        };
        this.addPropertyChangeListener(propertyChangeListener);
    }

    private synchronized boolean isDriverClassLoaded() {
        return this.driver_class_loaded;
    }

    private synchronized void setDriverClassLoaded(boolean bl) {
        this.driver_class_loaded = bl;
    }

    private void ensureDriverLoaded() throws SQLException {
        block4: {
            try {
                if (!this.isDriverClassLoaded()) {
                    if (this.driverClass != null) {
                        Class.forName(this.driverClass);
                    }
                    this.setDriverClassLoaded(true);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!logger.isLoggable(MLevel.WARNING)) break block4;
                logger.log(MLevel.WARNING, "Could not load driverClass " + this.driverClass, classNotFoundException);
            }
        }
    }

    public Connection getConnection() throws SQLException {
        this.ensureDriverLoaded();
        Connection connection = this.driver().connect(this.jdbcUrl, this.properties);
        if (connection == null) {
            throw new SQLException("Apparently, jdbc URL '" + this.jdbcUrl + "' is not valid for the underlying " + "driver [" + this.driver() + "].");
        }
        return connection;
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        this.ensureDriverLoaded();
        Connection connection = this.driver().connect(this.jdbcUrl, this.overrideProps(string, string2));
        if (connection == null) {
            throw new SQLException("Apparently, jdbc URL '" + this.jdbcUrl + "' is not valid for the underlying " + "driver [" + this.driver() + "].");
        }
        return connection;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return DriverManager.getLogWriter();
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        DriverManager.setLogWriter(printWriter);
    }

    public int getLoginTimeout() throws SQLException {
        return DriverManager.getLoginTimeout();
    }

    public void setLoginTimeout(int n) throws SQLException {
        DriverManager.setLoginTimeout(n);
    }

    public synchronized void setJdbcUrl(String string) {
        super.setJdbcUrl(string);
        this.clearDriver();
    }

    public synchronized void setUser(String string) {
        String string2 = this.getUser();
        if (!DriverManagerDataSource.eqOrBothNull(string, string2)) {
            if (string != null) {
                this.properties.put("user", string);
            } else {
                this.properties.remove("user");
            }
            this.pcs.firePropertyChange("user", string2, string);
        }
    }

    public synchronized String getUser() {
        return this.properties.getProperty("user");
    }

    public synchronized void setPassword(String string) {
        String string2 = this.getPassword();
        if (!DriverManagerDataSource.eqOrBothNull(string, string2)) {
            if (string != null) {
                this.properties.put("password", string);
            } else {
                this.properties.remove("password");
            }
            this.pcs.firePropertyChange("password", string2, string);
        }
    }

    public synchronized String getPassword() {
        return this.properties.getProperty("password");
    }

    private final Properties overrideProps(String string, String string2) {
        Properties properties = (Properties)this.properties.clone();
        if (string != null) {
            properties.put("user", string);
        } else {
            properties.remove("user");
        }
        if (string2 != null) {
            properties.put("password", string2);
        } else {
            properties.remove("password");
        }
        return properties;
    }

    private synchronized Driver driver() throws SQLException {
        if (this.driver == null) {
            this.driver = DriverManager.getDriver(this.jdbcUrl);
        }
        return this.driver;
    }

    private synchronized void clearDriver() {
        this.driver = null;
    }

    private static boolean eqOrBothNull(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeShort(1);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        short s = objectInputStream.readShort();
        switch (s) {
            case 1: {
                this.setUpPropertyListeners();
                break;
            }
            default: {
                throw new IOException("Unsupported Serialized Version: " + s);
            }
        }
    }
}

