/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0;

import com.mchange.v2.beans.BeansUtils;
import com.mchange.v2.c3p0.DriverManagerDataSource;
import com.mchange.v2.c3p0.PoolBackedDataSource;
import com.mchange.v2.c3p0.PoolConfig;
import com.mchange.v2.c3p0.PooledDataSource;
import com.mchange.v2.c3p0.WrapperConnectionPoolDataSource;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.sql.SqlUtils;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;

public final class DataSources {
    static final MLogger logger = MLog.getLogger(DataSources.class);
    static final Set WRAPPER_CXN_POOL_DATA_SOURCE_OVERWRITE_PROPS;
    static final Set POOL_BACKED_DATA_SOURCE_OVERWRITE_PROPS;

    public static DataSource unpooledDataSource() throws SQLException {
        DriverManagerDataSource driverManagerDataSource = new DriverManagerDataSource();
        return driverManagerDataSource;
    }

    public static DataSource unpooledDataSource(String string) throws SQLException {
        DriverManagerDataSource driverManagerDataSource = new DriverManagerDataSource();
        driverManagerDataSource.setJdbcUrl(string);
        return driverManagerDataSource;
    }

    public static DataSource unpooledDataSource(String string, String string2, String string3) throws SQLException {
        Properties properties = new Properties();
        properties.put("user", string2);
        properties.put("password", string3);
        return DataSources.unpooledDataSource(string, properties);
    }

    public static DataSource unpooledDataSource(String string, Properties properties) throws SQLException {
        DriverManagerDataSource driverManagerDataSource = new DriverManagerDataSource();
        driverManagerDataSource.setJdbcUrl(string);
        driverManagerDataSource.setProperties(properties);
        return driverManagerDataSource;
    }

    public static DataSource pooledDataSource(DataSource dataSource) throws SQLException {
        return DataSources.pooledDataSource(dataSource, null, null);
    }

    public static DataSource pooledDataSource(DataSource dataSource, int n) throws SQLException {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("maxStatements", new Integer(n));
        return DataSources.pooledDataSource(dataSource, null, hashMap);
    }

    public static DataSource pooledDataSource(DataSource dataSource, PoolConfig poolConfig) throws SQLException {
        try {
            WrapperConnectionPoolDataSource wrapperConnectionPoolDataSource = new WrapperConnectionPoolDataSource();
            wrapperConnectionPoolDataSource.setNestedDataSource(dataSource);
            BeansUtils.overwriteSpecificAccessibleProperties(poolConfig, wrapperConnectionPoolDataSource, WRAPPER_CXN_POOL_DATA_SOURCE_OVERWRITE_PROPS);
            PoolBackedDataSource poolBackedDataSource = new PoolBackedDataSource();
            poolBackedDataSource.setConnectionPoolDataSource(wrapperConnectionPoolDataSource);
            BeansUtils.overwriteSpecificAccessibleProperties(poolConfig, poolBackedDataSource, POOL_BACKED_DATA_SOURCE_OVERWRITE_PROPS);
            return poolBackedDataSource;
        }
        catch (Exception exception) {
            SQLException sQLException = SqlUtils.toSQLException("Exception configuring pool-backed DataSource: " + exception, exception);
            if (logger.isLoggable(MLevel.FINE) && exception != sQLException) {
                logger.log(MLevel.FINE, "Converted exception to throwable SQLException", exception);
            }
            throw sQLException;
        }
    }

    public static DataSource pooledDataSource(DataSource dataSource, String string) throws SQLException {
        return DataSources.pooledDataSource(dataSource, string, null);
    }

    public static DataSource pooledDataSource(DataSource dataSource, Map map) throws SQLException {
        return DataSources.pooledDataSource(dataSource, null, map);
    }

    public static DataSource pooledDataSource(DataSource dataSource, String string, Map map) throws SQLException {
        try {
            WrapperConnectionPoolDataSource wrapperConnectionPoolDataSource = new WrapperConnectionPoolDataSource(string);
            wrapperConnectionPoolDataSource.setNestedDataSource(dataSource);
            if (map != null) {
                BeansUtils.overwriteAccessiblePropertiesFromMap(map, wrapperConnectionPoolDataSource, false, null, true, MLevel.WARNING, MLevel.WARNING, false);
            }
            PoolBackedDataSource poolBackedDataSource = new PoolBackedDataSource(string);
            poolBackedDataSource.setConnectionPoolDataSource(wrapperConnectionPoolDataSource);
            if (map != null) {
                BeansUtils.overwriteAccessiblePropertiesFromMap(map, poolBackedDataSource, false, null, true, MLevel.WARNING, MLevel.WARNING, false);
            }
            return poolBackedDataSource;
        }
        catch (Exception exception) {
            SQLException sQLException = SqlUtils.toSQLException("Exception configuring pool-backed DataSource: " + exception, exception);
            if (logger.isLoggable(MLevel.FINE) && exception != sQLException) {
                logger.log(MLevel.FINE, "Converted exception to throwable SQLException", exception);
            }
            throw sQLException;
        }
    }

    public static DataSource pooledDataSource(DataSource dataSource, Properties properties) throws SQLException {
        Properties properties2 = new Properties();
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = properties.getProperty(string);
            String string3 = string.startsWith("c3p0.") ? string.substring(5) : string;
            properties2.put(string3, string2);
        }
        return DataSources.pooledDataSource(dataSource, null, properties2);
    }

    public static void destroy(DataSource dataSource) throws SQLException {
        DataSources.destroy(dataSource, false);
    }

    public static void forceDestroy(DataSource dataSource) throws SQLException {
        DataSources.destroy(dataSource, true);
    }

    private static void destroy(DataSource dataSource, boolean bl) throws SQLException {
        ConnectionPoolDataSource connectionPoolDataSource;
        if (dataSource instanceof PoolBackedDataSource && (connectionPoolDataSource = ((PoolBackedDataSource)dataSource).getConnectionPoolDataSource()) instanceof WrapperConnectionPoolDataSource) {
            DataSources.destroy(((WrapperConnectionPoolDataSource)connectionPoolDataSource).getNestedDataSource(), bl);
        }
        if (dataSource instanceof PooledDataSource) {
            ((PooledDataSource)dataSource).close(bl);
        }
    }

    private DataSources() {
    }

    static {
        String[] stringArray = new String[]{"checkoutTimeout", "acquireIncrement", "acquireRetryAttempts", "acquireRetryDelay", "autoCommitOnClose", "connectionTesterClassName", "forceIgnoreUnresolvedTransactions", "idleConnectionTestPeriod", "initialPoolSize", "maxIdleTime", "maxPoolSize", "maxStatements", "maxStatementsPerConnection", "minPoolSize", "propertyCycle", "breakAfterAcquireFailure", "testConnectionOnCheckout", "testConnectionOnCheckin", "usesTraditionalReflectiveProxies", "preferredTestQuery", "automaticTestTable", "factoryClassLocation"};
        WRAPPER_CXN_POOL_DATA_SOURCE_OVERWRITE_PROPS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(stringArray)));
        stringArray = new String[]{"numHelperThreads", "factoryClassLocation"};
        POOL_BACKED_DATA_SOURCE_OVERWRITE_PROPS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(stringArray)));
    }
}

