/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0;

import com.mchange.v2.beans.BeansUtils;
import com.mchange.v2.c3p0.DriverManagerDataSource;
import com.mchange.v2.c3p0.PooledDataSource;
import com.mchange.v2.c3p0.WrapperConnectionPoolDataSource;
import com.mchange.v2.c3p0.impl.AbstractPoolBackedDataSource;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.naming.Referenceable;
import javax.sql.DataSource;

public final class ComboPooledDataSource
extends AbstractPoolBackedDataSource
implements PooledDataSource,
Serializable,
Referenceable {
    static final MLogger logger = MLog.getLogger(ComboPooledDataSource.class);
    static final Set TO_STRING_IGNORE_PROPS = new HashSet<String>(Arrays.asList("connection", "lastCheckinFailureDefaultUser", "lastCheckoutFailureDefaultUser", "lastConnectionTestFailureDefaultUser", "lastIdleTestFailureDefaultUser", "logWriter", "loginTimeout", "numBusyConnections", "numBusyConnectionsAllUsers", "numBusyConnectionsDefaultUser", "numConnections", "numConnectionsAllUsers", "numConnectionsDefaultUser", "numFailedCheckinsDefaultUser", "numFailedCheckoutsDefaultUser", "numFailedIdleTestsDefaultUser", "numIdleConnections", "numIdleConnectionsAllUsers", "numIdleConnectionsDefaultUser", "numUnclosedOrphanedConnections", "numUnclosedOrphanedConnectionsAllUsers", "numUnclosedOrphanedConnectionsDefaultUser", "numUserPools", "effectivePropertyCycleDefaultUser", "startTimeMillisDefaultUser", "statementCacheNumCheckedOutDefaultUser", "statementCacheNumCheckedOutStatementsAllUsers", "statementCacheNumConnectionsWithCachedStatementsAllUsers", "statementCacheNumConnectionsWithCachedStatementsDefaultUser", "statementCacheNumStatementsAllUsers", "statementCacheNumStatementsDefaultUser", "threadPoolSize", "threadPoolNumActiveThreads", "threadPoolNumIdleThreads", "threadPoolNumTasksPending", "threadPoolStackTraces", "threadPoolStatus", "overrideDefaultUser", "overrideDefaultPassword", "password", "reference", "upTimeMillisDefaultUser", "user", "userOverridesAsString", "allUsers", "connectionPoolDataSource"));
    transient DriverManagerDataSource dmds = new DriverManagerDataSource();
    transient WrapperConnectionPoolDataSource wcpds = new WrapperConnectionPoolDataSource();
    private static final long serialVersionUID = 1L;
    private static final short VERSION = 1;

    public ComboPooledDataSource() {
        this(true);
    }

    public ComboPooledDataSource(boolean bl) {
        super(bl);
        this.wcpds.setNestedDataSource(this.dmds);
        try {
            this.setConnectionPoolDataSource(this.wcpds);
        }
        catch (PropertyVetoException propertyVetoException) {
            logger.log(MLevel.WARNING, "Hunh??? This can't happen. We haven't set up any listeners to veto the property change yet!", propertyVetoException);
            throw new RuntimeException("Hunh??? This can't happen. We haven't set up any listeners to veto the property change yet! " + propertyVetoException);
        }
        this.setUpPropertyEvents();
    }

    private void setUpPropertyEvents() {
        VetoableChangeListener vetoableChangeListener = new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                String string = propertyChangeEvent.getPropertyName();
                Object object = propertyChangeEvent.getNewValue();
                if ("connectionPoolDataSource".equals(string)) {
                    if (object instanceof WrapperConnectionPoolDataSource) {
                        DataSource dataSource = ((WrapperConnectionPoolDataSource)object).getNestedDataSource();
                        if (!(dataSource instanceof DriverManagerDataSource)) {
                            throw new PropertyVetoException("ComboPooledDataSource requires that its unpooled DataSource  be set at all times, and that it be a com.mchange.v2.c3p0.DriverManagerDataSource. Bad: " + dataSource, propertyChangeEvent);
                        }
                    } else {
                        throw new PropertyVetoException("ComboPooledDataSource requires that its ConnectionPoolDataSource  be set at all times, and that it be a com.mchange.v2.c3p0.WrapperConnectionPoolDataSource. Bad: " + object, propertyChangeEvent);
                    }
                }
            }
        };
        this.addVetoableChangeListener(vetoableChangeListener);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ComboPooledDataSource.this.updateLocalVarsFromCpdsProp();
            }
        };
        this.addPropertyChangeListener(propertyChangeListener);
    }

    private void updateLocalVarsFromCpdsProp() {
        this.wcpds = (WrapperConnectionPoolDataSource)this.getConnectionPoolDataSource();
        this.dmds = (DriverManagerDataSource)this.wcpds.getNestedDataSource();
    }

    public ComboPooledDataSource(String string) {
        this();
        this.initializeNamedConfig(string);
    }

    public String getDescription() {
        return this.dmds.getDescription();
    }

    public void setDescription(String string) {
        this.dmds.setDescription(string);
    }

    public String getDriverClass() {
        return this.dmds.getDriverClass();
    }

    public void setDriverClass(String string) throws PropertyVetoException {
        this.dmds.setDriverClass(string);
    }

    public String getJdbcUrl() {
        return this.dmds.getJdbcUrl();
    }

    public void setJdbcUrl(String string) {
        this.dmds.setJdbcUrl(string);
        this.resetPoolManager(false);
    }

    public Properties getProperties() {
        return this.dmds.getProperties();
    }

    public void setProperties(Properties properties) {
        this.dmds.setProperties(properties);
        this.resetPoolManager(false);
    }

    public String getUser() {
        return this.dmds.getUser();
    }

    public void setUser(String string) {
        this.dmds.setUser(string);
        this.resetPoolManager(false);
    }

    public String getPassword() {
        return this.dmds.getPassword();
    }

    public void setPassword(String string) {
        this.dmds.setPassword(string);
        this.resetPoolManager(false);
    }

    public int getCheckoutTimeout() {
        return this.wcpds.getCheckoutTimeout();
    }

    public void setCheckoutTimeout(int n) {
        this.wcpds.setCheckoutTimeout(n);
        this.resetPoolManager(false);
    }

    public int getAcquireIncrement() {
        return this.wcpds.getAcquireIncrement();
    }

    public void setAcquireIncrement(int n) {
        this.wcpds.setAcquireIncrement(n);
        this.resetPoolManager(false);
    }

    public int getAcquireRetryAttempts() {
        return this.wcpds.getAcquireRetryAttempts();
    }

    public void setAcquireRetryAttempts(int n) {
        this.wcpds.setAcquireRetryAttempts(n);
        this.resetPoolManager(false);
    }

    public int getAcquireRetryDelay() {
        return this.wcpds.getAcquireRetryDelay();
    }

    public void setAcquireRetryDelay(int n) {
        this.wcpds.setAcquireRetryDelay(n);
        this.resetPoolManager(false);
    }

    public boolean isAutoCommitOnClose() {
        return this.wcpds.isAutoCommitOnClose();
    }

    public void setAutoCommitOnClose(boolean bl) {
        this.wcpds.setAutoCommitOnClose(bl);
        this.resetPoolManager(false);
    }

    public String getConnectionTesterClassName() {
        return this.wcpds.getConnectionTesterClassName();
    }

    public void setConnectionTesterClassName(String string) throws PropertyVetoException {
        this.wcpds.setConnectionTesterClassName(string);
        this.resetPoolManager(false);
    }

    public String getAutomaticTestTable() {
        return this.wcpds.getAutomaticTestTable();
    }

    public void setAutomaticTestTable(String string) {
        this.wcpds.setAutomaticTestTable(string);
        this.resetPoolManager(false);
    }

    public boolean isForceIgnoreUnresolvedTransactions() {
        return this.wcpds.isForceIgnoreUnresolvedTransactions();
    }

    public void setForceIgnoreUnresolvedTransactions(boolean bl) {
        this.wcpds.setForceIgnoreUnresolvedTransactions(bl);
        this.resetPoolManager(false);
    }

    public int getIdleConnectionTestPeriod() {
        return this.wcpds.getIdleConnectionTestPeriod();
    }

    public void setIdleConnectionTestPeriod(int n) {
        this.wcpds.setIdleConnectionTestPeriod(n);
        this.resetPoolManager(false);
    }

    public int getInitialPoolSize() {
        return this.wcpds.getInitialPoolSize();
    }

    public void setInitialPoolSize(int n) {
        this.wcpds.setInitialPoolSize(n);
        this.resetPoolManager(false);
    }

    public int getMaxIdleTime() {
        return this.wcpds.getMaxIdleTime();
    }

    public void setMaxIdleTime(int n) {
        this.wcpds.setMaxIdleTime(n);
        this.resetPoolManager(false);
    }

    public int getMaxPoolSize() {
        return this.wcpds.getMaxPoolSize();
    }

    public void setMaxPoolSize(int n) {
        this.wcpds.setMaxPoolSize(n);
        this.resetPoolManager(false);
    }

    public int getMaxStatements() {
        return this.wcpds.getMaxStatements();
    }

    public void setMaxStatements(int n) {
        this.wcpds.setMaxStatements(n);
        this.resetPoolManager(false);
    }

    public int getMaxStatementsPerConnection() {
        return this.wcpds.getMaxStatementsPerConnection();
    }

    public void setMaxStatementsPerConnection(int n) {
        this.wcpds.setMaxStatementsPerConnection(n);
        this.resetPoolManager(false);
    }

    public int getMinPoolSize() {
        return this.wcpds.getMinPoolSize();
    }

    public void setMinPoolSize(int n) {
        this.wcpds.setMinPoolSize(n);
        this.resetPoolManager(false);
    }

    public String getOverrideDefaultUser() {
        return this.wcpds.getOverrideDefaultUser();
    }

    public void setOverrideDefaultUser(String string) {
        this.wcpds.setOverrideDefaultUser(string);
        this.resetPoolManager(false);
    }

    public String getOverrideDefaultPassword() {
        return this.wcpds.getOverrideDefaultPassword();
    }

    public void setOverrideDefaultPassword(String string) {
        this.wcpds.setOverrideDefaultPassword(string);
        this.resetPoolManager(false);
    }

    public int getPropertyCycle() {
        return this.wcpds.getPropertyCycle();
    }

    public void setPropertyCycle(int n) {
        this.wcpds.setPropertyCycle(n);
        this.resetPoolManager(false);
    }

    public boolean isBreakAfterAcquireFailure() {
        return this.wcpds.isBreakAfterAcquireFailure();
    }

    public void setBreakAfterAcquireFailure(boolean bl) {
        this.wcpds.setBreakAfterAcquireFailure(bl);
        this.resetPoolManager(false);
    }

    public boolean isTestConnectionOnCheckout() {
        return this.wcpds.isTestConnectionOnCheckout();
    }

    public void setTestConnectionOnCheckout(boolean bl) {
        this.wcpds.setTestConnectionOnCheckout(bl);
        this.resetPoolManager(false);
    }

    public boolean isTestConnectionOnCheckin() {
        return this.wcpds.isTestConnectionOnCheckin();
    }

    public void setTestConnectionOnCheckin(boolean bl) {
        this.wcpds.setTestConnectionOnCheckin(bl);
        this.resetPoolManager(false);
    }

    public boolean isUsesTraditionalReflectiveProxies() {
        return this.wcpds.isUsesTraditionalReflectiveProxies();
    }

    public void setUsesTraditionalReflectiveProxies(boolean bl) {
        this.wcpds.setUsesTraditionalReflectiveProxies(bl);
        this.resetPoolManager(false);
    }

    public String getPreferredTestQuery() {
        return this.wcpds.getPreferredTestQuery();
    }

    public void setPreferredTestQuery(String string) {
        this.wcpds.setPreferredTestQuery(string);
        this.resetPoolManager(false);
    }

    public String getUserOverridesAsString() {
        return this.wcpds.getUserOverridesAsString();
    }

    public void setUserOverridesAsString(String string) throws PropertyVetoException {
        this.wcpds.setUserOverridesAsString(string);
        this.resetPoolManager(false);
    }

    public int getMaxAdministrativeTaskTime() {
        return this.wcpds.getMaxAdministrativeTaskTime();
    }

    public void setMaxAdministrativeTaskTime(int n) {
        this.wcpds.setMaxAdministrativeTaskTime(n);
        this.resetPoolManager(false);
    }

    public int getMaxIdleTimeExcessConnections() {
        return this.wcpds.getMaxIdleTimeExcessConnections();
    }

    public void setMaxIdleTimeExcessConnections(int n) {
        this.wcpds.setMaxIdleTimeExcessConnections(n);
        this.resetPoolManager(false);
    }

    public int getMaxConnectionAge() {
        return this.wcpds.getMaxConnectionAge();
    }

    public void setMaxConnectionAge(int n) {
        this.wcpds.setMaxConnectionAge(n);
        this.resetPoolManager(false);
    }

    public String getConnectionCustomizerClassName() {
        return this.wcpds.getConnectionCustomizerClassName();
    }

    public void setConnectionCustomizerClassName(String string) {
        this.wcpds.setConnectionCustomizerClassName(string);
        this.resetPoolManager(false);
    }

    public int getUnreturnedConnectionTimeout() {
        return this.wcpds.getUnreturnedConnectionTimeout();
    }

    public void setUnreturnedConnectionTimeout(int n) {
        this.wcpds.setUnreturnedConnectionTimeout(n);
        this.resetPoolManager(false);
    }

    public boolean isDebugUnreturnedConnectionStackTraces() {
        return this.wcpds.isDebugUnreturnedConnectionStackTraces();
    }

    public void setDebugUnreturnedConnectionStackTraces(boolean bl) {
        this.wcpds.setDebugUnreturnedConnectionStackTraces(bl);
        this.resetPoolManager(false);
    }

    public String getFactoryClassLocation() {
        return super.getFactoryClassLocation();
    }

    public void setFactoryClassLocation(String string) {
        this.dmds.setFactoryClassLocation(string);
        this.wcpds.setFactoryClassLocation(string);
        super.setFactoryClassLocation(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" [ ");
        try {
            BeansUtils.appendPropNamesAndValues(stringBuffer, this, TO_STRING_IGNORE_PROPS);
        }
        catch (Exception exception) {
            stringBuffer.append(exception.toString());
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeShort(1);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        short s = objectInputStream.readShort();
        switch (s) {
            case 1: {
                this.updateLocalVarsFromCpdsProp();
                this.setUpPropertyEvents();
                break;
            }
            default: {
                throw new IOException("Unsupported Serialized Version: " + s);
            }
        }
    }
}

