/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0;

import com.mchange.v2.c3p0.ConnectionCustomizer;
import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.PooledDataSource;
import com.mchange.v2.c3p0.cfg.C3P0ConfigUtils;
import com.mchange.v2.c3p0.impl.C3P0Defaults;
import com.mchange.v2.c3p0.impl.IdentityTokenized;
import com.mchange.v2.c3p0.impl.IdentityTokenizedCoalesceChecker;
import com.mchange.v2.c3p0.management.ManagementCoordinator;
import com.mchange.v2.c3p0.management.NullManagementCoordinator;
import com.mchange.v2.coalesce.CoalesceChecker;
import com.mchange.v2.coalesce.Coalescer;
import com.mchange.v2.coalesce.CoalescerFactory;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.sql.SqlUtils;
import com.mchange.v2.util.DoubleWeakHashMap;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class C3P0Registry {
    private static final String MC_PARAM = "com.mchange.v2.c3p0.management.ManagementCoordinator";
    static final MLogger logger = MLog.getLogger(C3P0Registry.class);
    static boolean banner_printed = false;
    static boolean registry_mbean_registered = false;
    private static CoalesceChecker CC = IdentityTokenizedCoalesceChecker.INSTANCE;
    private static Coalescer idtCoalescer = CoalescerFactory.createCoalescer(CC, true, false);
    private static Map tokensToTokenized = new DoubleWeakHashMap();
    private static HashSet unclosedPooledDataSources = new HashSet();
    private static Map classNamesToConnectionTesters = Collections.synchronizedMap(new HashMap());
    private static Map classNamesToConnectionCustomizers = Collections.synchronizedMap(new HashMap());
    private static ManagementCoordinator mc;

    public static ConnectionTester getConnectionTester(String string) {
        try {
            ConnectionTester connectionTester = (ConnectionTester)classNamesToConnectionTesters.get(string);
            if (connectionTester == null) {
                connectionTester = (ConnectionTester)Class.forName(string).newInstance();
                classNamesToConnectionTesters.put(string, connectionTester);
            }
            return connectionTester;
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "Could not create for find ConnectionTester with class name '" + string + "'. Using default.", exception);
            }
            return C3P0Defaults.connectionTester();
        }
    }

    public static ConnectionCustomizer getConnectionCustomizer(String string) throws SQLException {
        if (string == null) {
            return null;
        }
        try {
            ConnectionCustomizer connectionCustomizer = (ConnectionCustomizer)classNamesToConnectionCustomizers.get(string);
            if (connectionCustomizer == null) {
                connectionCustomizer = (ConnectionCustomizer)Class.forName(string).newInstance();
                classNamesToConnectionCustomizers.put(string, connectionCustomizer);
            }
            return connectionCustomizer;
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "Could not create for find ConnectionCustomizer with class name '" + string + "'.", exception);
            }
            throw SqlUtils.toSQLException(exception);
        }
    }

    private static void banner() {
        if (!banner_printed) {
            if (logger.isLoggable(MLevel.INFO)) {
                logger.info("Initializing c3p0-0.9.1.1 [built 15-March-2007 01:32:31; debug? true; trace: 10]");
            }
            banner_printed = true;
        }
    }

    private static void attemptRegisterRegistryMBean() {
        if (!registry_mbean_registered) {
            mc.attemptManageC3P0Registry();
            registry_mbean_registered = true;
        }
    }

    private static boolean isIncorporated(IdentityTokenized identityTokenized) {
        return tokensToTokenized.keySet().contains(identityTokenized.getIdentityToken());
    }

    private static void incorporate(IdentityTokenized identityTokenized) {
        tokensToTokenized.put(identityTokenized.getIdentityToken(), identityTokenized);
        if (identityTokenized instanceof PooledDataSource) {
            unclosedPooledDataSources.add(identityTokenized);
            mc.attemptManagePooledDataSource((PooledDataSource)((Object)identityTokenized));
        }
    }

    public static synchronized IdentityTokenized reregister(IdentityTokenized identityTokenized) {
        if (identityTokenized instanceof PooledDataSource) {
            C3P0Registry.banner();
            C3P0Registry.attemptRegisterRegistryMBean();
        }
        if (identityTokenized.getIdentityToken() == null) {
            throw new RuntimeException("[c3p0 issue] The identityToken of a registered object should be set prior to registration.");
        }
        IdentityTokenized identityTokenized2 = (IdentityTokenized)idtCoalescer.coalesce(identityTokenized);
        if (!C3P0Registry.isIncorporated(identityTokenized2)) {
            C3P0Registry.incorporate(identityTokenized2);
        }
        return identityTokenized2;
    }

    public static synchronized void markClosed(PooledDataSource pooledDataSource) {
        unclosedPooledDataSources.remove(pooledDataSource);
        mc.attemptUnmanagePooledDataSource(pooledDataSource);
        if (unclosedPooledDataSources.isEmpty()) {
            mc.attemptUnmanageC3P0Registry();
            registry_mbean_registered = false;
        }
    }

    public static synchronized Set getPooledDataSources() {
        return (Set)unclosedPooledDataSources.clone();
    }

    public static synchronized Set pooledDataSourcesByName(String string) {
        HashSet<PooledDataSource> hashSet = new HashSet<PooledDataSource>();
        Iterator iterator = unclosedPooledDataSources.iterator();
        while (iterator.hasNext()) {
            PooledDataSource pooledDataSource = (PooledDataSource)iterator.next();
            if (!pooledDataSource.getDataSourceName().equals(string)) continue;
            hashSet.add(pooledDataSource);
        }
        return hashSet;
    }

    public static synchronized PooledDataSource pooledDataSourceByName(String string) {
        Iterator iterator = unclosedPooledDataSources.iterator();
        while (iterator.hasNext()) {
            PooledDataSource pooledDataSource = (PooledDataSource)iterator.next();
            if (!pooledDataSource.getDataSourceName().equals(string)) continue;
            return pooledDataSource;
        }
        return null;
    }

    public static synchronized Set allIdentityTokens() {
        Set set = Collections.unmodifiableSet(tokensToTokenized.keySet());
        return set;
    }

    public static synchronized Set allIdentityTokenized() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(tokensToTokenized.values());
        return Collections.unmodifiableSet(hashSet);
    }

    public static synchronized Set allPooledDataSources() {
        Set set = Collections.unmodifiableSet(unclosedPooledDataSources);
        return set;
    }

    public static synchronized int getNumPooledDataSources() {
        return unclosedPooledDataSources.size();
    }

    public static synchronized int getNumPoolsAllDataSources() throws SQLException {
        int n = 0;
        Iterator iterator = unclosedPooledDataSources.iterator();
        while (iterator.hasNext()) {
            PooledDataSource pooledDataSource = (PooledDataSource)iterator.next();
            n += pooledDataSource.getNumUserPools();
        }
        return n;
    }

    public synchronized int getNumThreadsAllThreadPools() throws SQLException {
        int n = 0;
        Iterator iterator = unclosedPooledDataSources.iterator();
        while (iterator.hasNext()) {
            PooledDataSource pooledDataSource = (PooledDataSource)iterator.next();
            n += pooledDataSource.getNumHelperThreads();
        }
        return n;
    }

    static {
        classNamesToConnectionTesters.put(C3P0Defaults.connectionTesterClassName(), C3P0Defaults.connectionTester());
        String string = C3P0ConfigUtils.getPropFileConfigProperty(MC_PARAM);
        if (string != null) {
            try {
                mc = (ManagementCoordinator)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                if (logger.isLoggable(MLevel.WARNING)) {
                    logger.log(MLevel.WARNING, "Could not instantiate user-specified ManagementCoordinator " + string + ". Using NullManagementCoordinator (c3p0 JMX management disabled!)", exception);
                }
                mc = new NullManagementCoordinator();
            }
        } else {
            try {
                Class.forName("java.lang.management.ManagementFactory");
                mc = (ManagementCoordinator)Class.forName("com.mchange.v2.c3p0.management.ActiveManagementCoordinator").newInstance();
            }
            catch (Exception exception) {
                if (logger.isLoggable(MLevel.INFO)) {
                    logger.log(MLevel.INFO, "jdk1.5 management interfaces unavailable... JMX support disabled.", exception);
                }
                mc = new NullManagementCoordinator();
            }
        }
    }
}

