/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public abstract class ValidationUtils {
    private static Log logger = LogFactory.getLog((Class)(class$org$springframework$validation$ValidationUtils == null ? (class$org$springframework$validation$ValidationUtils = ValidationUtils.class$("org.springframework.validation.ValidationUtils")) : class$org$springframework$validation$ValidationUtils));
    static /* synthetic */ Class class$org$springframework$validation$ValidationUtils;

    public static void invokeValidator(Validator validator, Object object, Errors errors) {
        Assert.notNull((Object)validator, (String)"Validator must not be null");
        Assert.notNull((Object)errors, (String)"Errors object must not be null");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Invoking validator [" + validator + "]"));
        }
        if (object != null && !validator.supports(object.getClass())) {
            throw new IllegalArgumentException("Validator " + validator.getClass() + " does not support " + object.getClass());
        }
        validator.validate(object, errors);
        if (logger.isDebugEnabled()) {
            if (errors.hasErrors()) {
                logger.debug((Object)("Validator found " + errors.getErrorCount() + " errors"));
            } else {
                logger.debug((Object)"Validator found no errors");
            }
        }
    }

    public static void rejectIfEmpty(Errors errors, String string, String string2) {
        ValidationUtils.rejectIfEmpty(errors, string, string2, null, null);
    }

    public static void rejectIfEmpty(Errors errors, String string, String string2, String string3) {
        ValidationUtils.rejectIfEmpty(errors, string, string2, null, string3);
    }

    public static void rejectIfEmpty(Errors errors, String string, String string2, Object[] objectArray, String string3) {
        Assert.notNull((Object)errors, (String)"Errors object must not be null");
        Object object = errors.getFieldValue(string);
        if (object == null || !StringUtils.hasLength((String)object.toString())) {
            errors.rejectValue(string, string2, objectArray, string3);
        }
    }

    public static void rejectIfEmptyOrWhitespace(Errors errors, String string, String string2) {
        ValidationUtils.rejectIfEmptyOrWhitespace(errors, string, string2, null, null);
    }

    public static void rejectIfEmptyOrWhitespace(Errors errors, String string, String string2, String string3) {
        ValidationUtils.rejectIfEmptyOrWhitespace(errors, string, string2, null, string3);
    }

    public static void rejectIfEmptyOrWhitespace(Errors errors, String string, String string2, Object[] objectArray, String string3) {
        Assert.notNull((Object)errors, (String)"Errors object must not be null");
        Object object = errors.getFieldValue(string);
        if (object == null || !StringUtils.hasText((String)object.toString())) {
            errors.rejectValue(string, string2, objectArray, string3);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

