/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import org.springframework.beans.PropertyAccessException;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.validation.BindingErrorProcessor;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;

public class DefaultBindingErrorProcessor
implements BindingErrorProcessor {
    public static final String MISSING_FIELD_ERROR_CODE = "required";

    public void processMissingFieldError(String string, BindingResult bindingResult) {
        String[] stringArray = bindingResult.resolveMessageCodes(MISSING_FIELD_ERROR_CODE, string);
        Object[] objectArray = this.getArgumentsForBindError(bindingResult.getObjectName(), string);
        bindingResult.addError(new FieldError(bindingResult.getObjectName(), string, "", true, stringArray, objectArray, "Field '" + string + "' is required"));
    }

    public void processPropertyAccessException(PropertyAccessException propertyAccessException, BindingResult bindingResult) {
        String string = propertyAccessException.getPropertyChangeEvent().getPropertyName();
        Object object = propertyAccessException.getPropertyChangeEvent().getNewValue();
        String[] stringArray = bindingResult.resolveMessageCodes(propertyAccessException.getErrorCode(), string);
        Object[] objectArray = this.getArgumentsForBindError(bindingResult.getObjectName(), string);
        bindingResult.addError(new FieldError(bindingResult.getObjectName(), string, object, true, stringArray, objectArray, propertyAccessException.getLocalizedMessage()));
    }

    protected Object[] getArgumentsForBindError(String string, String string2) {
        String[] stringArray = new String[]{string + "." + string2, string2};
        String string3 = string2;
        return new Object[]{new DefaultMessageSourceResolvable(stringArray, string3)};
    }
}

