/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import java.beans.PropertyEditor;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyAccessException;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.PropertyBatchUpdateException;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.AbstractPropertyBindingResult;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingErrorProcessor;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DefaultBindingErrorProcessor;
import org.springframework.validation.DirectFieldBindingResult;
import org.springframework.validation.MessageCodesResolver;

public class DataBinder
implements PropertyEditorRegistry {
    public static final String DEFAULT_OBJECT_NAME = "target";
    protected static final Log logger = LogFactory.getLog((Class)(class$org$springframework$validation$DataBinder == null ? (class$org$springframework$validation$DataBinder = DataBinder.class$("org.springframework.validation.DataBinder")) : class$org$springframework$validation$DataBinder));
    private final Object target;
    private final String objectName;
    private AbstractPropertyBindingResult bindingResult;
    private BindException bindException;
    private boolean ignoreUnknownFields = true;
    private boolean ignoreInvalidFields = false;
    private String[] allowedFields;
    private String[] disallowedFields;
    private String[] requiredFields;
    private BindingErrorProcessor bindingErrorProcessor = new DefaultBindingErrorProcessor();
    static /* synthetic */ Class class$org$springframework$validation$DataBinder;

    public DataBinder(Object object) {
        this(object, DEFAULT_OBJECT_NAME);
    }

    public DataBinder(Object object, String string) {
        Assert.notNull((Object)object, (String)"Target must not be null");
        this.target = object;
        this.objectName = string;
    }

    public Object getTarget() {
        return this.target;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void initBeanPropertyAccess() {
        Assert.isNull((Object)this.bindingResult, (String)"DataBinder is already initialized - call initBeanPropertyAccess before any other configuration methods");
        this.bindingResult = new BeanPropertyBindingResult(this.getTarget(), this.getObjectName());
    }

    public void initDirectFieldAccess() {
        Assert.isNull((Object)this.bindingResult, (String)"DataBinder is already initialized - call initDirectFieldAccess before any other configuration methods");
        this.bindingResult = new DirectFieldBindingResult(this.getTarget(), this.getObjectName());
    }

    protected AbstractPropertyBindingResult getInternalBindingResult() {
        if (this.bindingResult == null) {
            this.initBeanPropertyAccess();
        }
        return this.bindingResult;
    }

    protected ConfigurablePropertyAccessor getPropertyAccessor() {
        return this.getInternalBindingResult().getPropertyAccessor();
    }

    public BindingResult getBindingResult() {
        return this.getInternalBindingResult();
    }

    public BindException getErrors() {
        if (this.bindException == null) {
            this.bindException = new BindException(this.getBindingResult());
        }
        return this.bindException;
    }

    public void setIgnoreUnknownFields(boolean bl) {
        this.ignoreUnknownFields = bl;
    }

    public boolean isIgnoreUnknownFields() {
        return this.ignoreUnknownFields;
    }

    public void setIgnoreInvalidFields(boolean bl) {
        this.ignoreInvalidFields = bl;
    }

    public boolean isIgnoreInvalidFields() {
        return this.ignoreInvalidFields;
    }

    public void setAllowedFields(String[] stringArray) {
        this.allowedFields = PropertyAccessorUtils.canonicalPropertyNames((String[])stringArray);
    }

    public String[] getAllowedFields() {
        return this.allowedFields;
    }

    public void setDisallowedFields(String[] stringArray) {
        this.disallowedFields = PropertyAccessorUtils.canonicalPropertyNames((String[])stringArray);
    }

    public String[] getDisallowedFields() {
        return this.disallowedFields;
    }

    public void setRequiredFields(String[] stringArray) {
        this.requiredFields = PropertyAccessorUtils.canonicalPropertyNames((String[])stringArray);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DataBinder requires binding of required fields [" + StringUtils.arrayToCommaDelimitedString((Object[])stringArray) + "]"));
        }
    }

    public String[] getRequiredFields() {
        return this.requiredFields;
    }

    public void setExtractOldValueForEditor(boolean bl) {
        this.getPropertyAccessor().setExtractOldValueForEditor(bl);
    }

    public void registerCustomEditor(Class clazz, PropertyEditor propertyEditor) {
        this.getPropertyAccessor().registerCustomEditor(clazz, propertyEditor);
    }

    public void registerCustomEditor(Class clazz, String string, PropertyEditor propertyEditor) {
        this.getPropertyAccessor().registerCustomEditor(clazz, string, propertyEditor);
    }

    public PropertyEditor findCustomEditor(Class clazz, String string) {
        return this.getPropertyAccessor().findCustomEditor(clazz, string);
    }

    public void setMessageCodesResolver(MessageCodesResolver messageCodesResolver) {
        this.getInternalBindingResult().setMessageCodesResolver(messageCodesResolver);
    }

    public void setBindingErrorProcessor(BindingErrorProcessor bindingErrorProcessor) {
        this.bindingErrorProcessor = bindingErrorProcessor;
    }

    public BindingErrorProcessor getBindingErrorProcessor() {
        return this.bindingErrorProcessor;
    }

    public void bind(PropertyValues propertyValues) {
        MutablePropertyValues mutablePropertyValues = propertyValues instanceof MutablePropertyValues ? (MutablePropertyValues)propertyValues : new MutablePropertyValues(propertyValues);
        this.doBind(mutablePropertyValues);
    }

    protected void doBind(MutablePropertyValues mutablePropertyValues) {
        this.checkAllowedFields(mutablePropertyValues);
        this.checkRequiredFields(mutablePropertyValues);
        this.applyPropertyValues(mutablePropertyValues);
    }

    protected void checkAllowedFields(MutablePropertyValues mutablePropertyValues) {
        PropertyValue[] propertyValueArray = mutablePropertyValues.getPropertyValues();
        for (int i = 0; i < propertyValueArray.length; ++i) {
            PropertyValue propertyValue = propertyValueArray[i];
            String string = PropertyAccessorUtils.canonicalPropertyName((String)propertyValue.getName());
            if (this.isAllowed(string)) continue;
            mutablePropertyValues.removePropertyValue(propertyValue);
            this.getBindingResult().recordSuppressedField(string);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Field [" + string + "] has been removed from PropertyValues " + "and will not be bound, because it has not been found in the list of allowed fields"));
        }
    }

    protected boolean isAllowed(String string) {
        Object[] objectArray = this.getAllowedFields();
        Object[] objectArray2 = this.getDisallowedFields();
        return !(!ObjectUtils.isEmpty((Object[])objectArray) && !PatternMatchUtils.simpleMatch((String[])objectArray, (String)string) || !ObjectUtils.isEmpty((Object[])objectArray2) && PatternMatchUtils.simpleMatch((String[])objectArray2, (String)string));
    }

    protected void checkRequiredFields(MutablePropertyValues mutablePropertyValues) {
        Object[] objectArray = this.getRequiredFields();
        if (!ObjectUtils.isEmpty((Object[])objectArray)) {
            String string;
            Object object;
            int n;
            HashMap<String, PropertyValue> hashMap = new HashMap<String, PropertyValue>();
            PropertyValue[] propertyValueArray = mutablePropertyValues.getPropertyValues();
            for (n = 0; n < propertyValueArray.length; ++n) {
                object = propertyValueArray[n];
                string = PropertyAccessorUtils.canonicalPropertyName((String)object.getName());
                hashMap.put(string, (PropertyValue)object);
            }
            for (n = 0; n < objectArray.length; ++n) {
                object = objectArray[n];
                string = (PropertyValue)hashMap.get(object);
                if (string != null && string.getValue() != null && (!(string.getValue() instanceof String) || StringUtils.hasText((String)((String)string.getValue())))) continue;
                this.getBindingErrorProcessor().processMissingFieldError((String)object, this.getInternalBindingResult());
                if (string == null) continue;
                mutablePropertyValues.removePropertyValue((PropertyValue)string);
                hashMap.remove(object);
            }
        }
    }

    protected void applyPropertyValues(MutablePropertyValues mutablePropertyValues) {
        try {
            this.getPropertyAccessor().setPropertyValues((PropertyValues)mutablePropertyValues, this.isIgnoreUnknownFields(), this.isIgnoreInvalidFields());
        }
        catch (PropertyBatchUpdateException propertyBatchUpdateException) {
            PropertyAccessException[] propertyAccessExceptionArray = propertyBatchUpdateException.getPropertyAccessExceptions();
            for (int i = 0; i < propertyAccessExceptionArray.length; ++i) {
                this.getBindingErrorProcessor().processPropertyAccessException(propertyAccessExceptionArray[i], this.getInternalBindingResult());
            }
        }
    }

    public Map close() throws BindException {
        if (this.getBindingResult().hasErrors()) {
            throw new BindException(this.getBindingResult());
        }
        return this.getBindingResult().getModel();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

