/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.validation.BindingResult;

public abstract class BindingResultUtils {
    public static BindingResult getBindingResult(Map map, String string) {
        Assert.notNull((Object)map, (String)"Model map must not be null");
        Assert.notNull((Object)string, (String)"Name must not be null");
        Object v = map.get(BindingResult.MODEL_KEY_PREFIX + string);
        if (v != null && !(v instanceof BindingResult)) {
            throw new IllegalStateException("BindingResult attribute is not of type BindingResult: " + v);
        }
        return (BindingResult)v;
    }

    public static BindingResult getRequiredBindingResult(Map map, String string) {
        BindingResult bindingResult = BindingResultUtils.getBindingResult(map, string);
        if (bindingResult == null) {
            throw new IllegalStateException("No BindingResult attribute found for name '" + string + "'- have you exposed the correct model?");
        }
        return bindingResult;
    }
}

