/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import java.io.Serializable;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.util.Assert;
import org.springframework.validation.AbstractPropertyBindingResult;

public class BeanPropertyBindingResult
extends AbstractPropertyBindingResult
implements Serializable {
    private final Object target;
    private transient BeanWrapper beanWrapper;

    public BeanPropertyBindingResult(Object object, String string) {
        super(string);
        Assert.notNull((Object)object, (String)"Target bean must not be null");
        this.target = object;
    }

    public final Object getTarget() {
        return this.target;
    }

    public final ConfigurablePropertyAccessor getPropertyAccessor() {
        if (this.beanWrapper == null) {
            this.beanWrapper = this.createBeanWrapper();
            this.beanWrapper.setExtractOldValueForEditor(true);
        }
        return this.beanWrapper;
    }

    protected BeanWrapper createBeanWrapper() {
        return new BeanWrapperImpl(this.getTarget());
    }
}

