/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DefaultMessageCodesResolver;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.validation.ObjectError;

public abstract class AbstractBindingResult
implements BindingResult,
Serializable {
    private final List errors = new LinkedList();
    private final String objectName;
    private MessageCodesResolver messageCodesResolver = new DefaultMessageCodesResolver();
    private String nestedPath = "";
    private final Stack nestedPathStack = new Stack();
    private Set suppressedFields = new HashSet();

    protected AbstractBindingResult(String string) {
        this.objectName = string;
    }

    public void setMessageCodesResolver(MessageCodesResolver messageCodesResolver) {
        this.messageCodesResolver = messageCodesResolver;
    }

    public MessageCodesResolver getMessageCodesResolver() {
        return this.messageCodesResolver;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setNestedPath(String string) {
        this.doSetNestedPath(string);
        this.nestedPathStack.clear();
    }

    public String getNestedPath() {
        return this.nestedPath;
    }

    public void pushNestedPath(String string) {
        this.nestedPathStack.push(this.getNestedPath());
        this.doSetNestedPath(this.getNestedPath() + string);
    }

    public void popNestedPath() throws IllegalArgumentException {
        try {
            String string = (String)this.nestedPathStack.pop();
            this.doSetNestedPath(string);
        }
        catch (EmptyStackException emptyStackException) {
            throw new IllegalStateException("Cannot pop nested path: no nested path on stack");
        }
    }

    protected void doSetNestedPath(String string) {
        if (string == null) {
            string = "";
        }
        if ((string = this.canonicalFieldName(string)).length() > 0 && !string.endsWith(".")) {
            string = string + ".";
        }
        this.nestedPath = string;
    }

    protected String fixedField(String string) {
        if (StringUtils.hasLength((String)string)) {
            return this.getNestedPath() + this.canonicalFieldName(string);
        }
        String string2 = this.getNestedPath();
        return string2.endsWith(".") ? string2.substring(0, string2.length() - ".".length()) : string2;
    }

    public void reject(String string) {
        this.reject(string, null, null);
    }

    public void reject(String string, String string2) {
        this.reject(string, null, string2);
    }

    public void reject(String string, Object[] objectArray, String string2) {
        this.addError(new ObjectError(this.getObjectName(), this.resolveMessageCodes(string), objectArray, string2));
    }

    public void rejectValue(String string, String string2) {
        this.rejectValue(string, string2, null, null);
    }

    public void rejectValue(String string, String string2, String string3) {
        this.rejectValue(string, string2, null, string3);
    }

    public void rejectValue(String string, String string2, Object[] objectArray, String string3) {
        if ("".equals(this.getNestedPath()) && !StringUtils.hasLength((String)string)) {
            this.reject(string2, objectArray, string3);
            return;
        }
        String string4 = this.fixedField(string);
        Object object = this.getActualFieldValue(string4);
        FieldError fieldError = new FieldError(this.getObjectName(), string4, object, false, this.resolveMessageCodes(string2, string), objectArray, string3);
        this.addError(fieldError);
    }

    public String[] resolveMessageCodes(String string) {
        return this.getMessageCodesResolver().resolveMessageCodes(string, this.getObjectName());
    }

    public String[] resolveMessageCodes(String string, String string2) {
        String string3 = this.fixedField(string2);
        Class clazz = this.getFieldType(string3);
        return this.getMessageCodesResolver().resolveMessageCodes(string, this.getObjectName(), string3, clazz);
    }

    public void addError(ObjectError objectError) {
        this.errors.add(objectError);
    }

    public void addAllErrors(Errors errors) {
        if (!errors.getObjectName().equals(this.getObjectName())) {
            throw new IllegalArgumentException("Errors object needs to have same object name");
        }
        this.errors.addAll(errors.getAllErrors());
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public int getErrorCount() {
        return this.errors.size();
    }

    public List getAllErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public boolean hasGlobalErrors() {
        return this.getGlobalErrorCount() > 0;
    }

    public int getGlobalErrorCount() {
        return this.getGlobalErrors().size();
    }

    public List getGlobalErrors() {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.errors.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof FieldError) continue;
            linkedList.add(e);
        }
        return Collections.unmodifiableList(linkedList);
    }

    public ObjectError getGlobalError() {
        Iterator iterator = this.errors.iterator();
        while (iterator.hasNext()) {
            ObjectError objectError = (ObjectError)iterator.next();
            if (objectError instanceof FieldError) continue;
            return objectError;
        }
        return null;
    }

    public boolean hasFieldErrors() {
        return this.getFieldErrorCount() > 0;
    }

    public int getFieldErrorCount() {
        return this.getFieldErrors().size();
    }

    public List getFieldErrors() {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.errors.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof FieldError)) continue;
            linkedList.add(e);
        }
        return Collections.unmodifiableList(linkedList);
    }

    public FieldError getFieldError() {
        Iterator iterator = this.errors.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof FieldError)) continue;
            return (FieldError)e;
        }
        return null;
    }

    public boolean hasFieldErrors(String string) {
        return this.getFieldErrorCount(string) > 0;
    }

    public int getFieldErrorCount(String string) {
        return this.getFieldErrors(string).size();
    }

    public List getFieldErrors(String string) {
        LinkedList linkedList = new LinkedList();
        String string2 = this.fixedField(string);
        Iterator iterator = this.errors.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof FieldError) || !this.isMatchingFieldError(string2, (FieldError)e)) continue;
            linkedList.add(e);
        }
        return Collections.unmodifiableList(linkedList);
    }

    public FieldError getFieldError(String string) {
        String string2 = this.fixedField(string);
        Iterator iterator = this.errors.iterator();
        while (iterator.hasNext()) {
            FieldError fieldError;
            Object e = iterator.next();
            if (!(e instanceof FieldError) || !this.isMatchingFieldError(string2, fieldError = (FieldError)e)) continue;
            return fieldError;
        }
        return null;
    }

    protected boolean isMatchingFieldError(String string, FieldError fieldError) {
        return string.equals(fieldError.getField()) || string.endsWith("*") && fieldError.getField().startsWith(string.substring(0, string.length() - 1));
    }

    public Object getFieldValue(String string) {
        FieldError fieldError = this.getFieldError(string);
        Object object = null;
        object = fieldError != null ? fieldError.getRejectedValue() : this.getActualFieldValue(this.fixedField(string));
        if (fieldError == null || !fieldError.isBindingFailure()) {
            object = this.formatFieldValue(string, object);
        }
        return object;
    }

    public Class getFieldType(String string) {
        Object object = this.getActualFieldValue(string);
        if (object != null) {
            return object.getClass();
        }
        return null;
    }

    public Map getModel() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(BindingResult.MODEL_KEY_PREFIX + this.getObjectName(), this);
        hashMap.put(this.getObjectName(), this.getTarget());
        return hashMap;
    }

    public PropertyEditorRegistry getPropertyEditorRegistry() {
        throw new UnsupportedOperationException("[" + this.getClass().getName() + "] does not support a PropertyEditorRegistry");
    }

    public void recordSuppressedField(String string) {
        this.suppressedFields.add(string);
    }

    public String[] getSuppressedFields() {
        return StringUtils.toStringArray((Collection)this.suppressedFields);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append(": ").append(this.getErrorCount()).append(" errors");
        Iterator iterator = this.getAllErrors().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append('\n').append(iterator.next());
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BindingResult)) {
            return false;
        }
        BindingResult bindingResult = (BindingResult)object;
        return this.getObjectName().equals(bindingResult.getObjectName()) && this.getTarget().equals(bindingResult.getTarget()) && ((Object)this.getAllErrors()).equals(bindingResult.getAllErrors());
    }

    public int hashCode() {
        return this.getObjectName().hashCode() * 29 + this.getTarget().hashCode();
    }

    public abstract Object getTarget();

    protected String canonicalFieldName(String string) {
        return string;
    }

    protected abstract Object getActualFieldValue(String var1);

    protected Object formatFieldValue(String string, Object object) {
        return object;
    }
}

