/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ui.context.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.ui.context.HierarchicalThemeSource;
import org.springframework.ui.context.ThemeSource;
import org.springframework.ui.context.support.DelegatingThemeSource;
import org.springframework.ui.context.support.ResourceBundleThemeSource;

public abstract class UiApplicationContextUtils {
    public static final String THEME_SOURCE_BEAN_NAME = "themeSource";
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$ui$context$support$UiApplicationContextUtils == null ? (class$org$springframework$ui$context$support$UiApplicationContextUtils = UiApplicationContextUtils.class$("org.springframework.ui.context.support.UiApplicationContextUtils")) : class$org$springframework$ui$context$support$UiApplicationContextUtils));
    static /* synthetic */ Class class$org$springframework$ui$context$support$UiApplicationContextUtils;
    static /* synthetic */ Class class$org$springframework$ui$context$ThemeSource;

    public static ThemeSource initThemeSource(ApplicationContext applicationContext) {
        if (applicationContext.containsLocalBean(THEME_SOURCE_BEAN_NAME)) {
            HierarchicalThemeSource hierarchicalThemeSource;
            ThemeSource themeSource = (ThemeSource)applicationContext.getBean(THEME_SOURCE_BEAN_NAME, class$org$springframework$ui$context$ThemeSource == null ? (class$org$springframework$ui$context$ThemeSource = UiApplicationContextUtils.class$("org.springframework.ui.context.ThemeSource")) : class$org$springframework$ui$context$ThemeSource);
            if (applicationContext.getParent() instanceof ThemeSource && themeSource instanceof HierarchicalThemeSource && (hierarchicalThemeSource = (HierarchicalThemeSource)themeSource).getParentThemeSource() == null) {
                hierarchicalThemeSource.setParentThemeSource((ThemeSource)((Object)applicationContext.getParent()));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Using ThemeSource [" + themeSource + "]"));
            }
            return themeSource;
        }
        HierarchicalThemeSource hierarchicalThemeSource = null;
        if (applicationContext.getParent() instanceof ThemeSource) {
            hierarchicalThemeSource = new DelegatingThemeSource();
            hierarchicalThemeSource.setParentThemeSource((ThemeSource)((Object)applicationContext.getParent()));
        } else {
            hierarchicalThemeSource = new ResourceBundleThemeSource();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Unable to locate ThemeSource with name 'themeSource': using default [" + hierarchicalThemeSource + "]"));
        }
        return hierarchicalThemeSource;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

