/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ui.context.support;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.HierarchicalMessageSource;
import org.springframework.context.MessageSource;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.ui.context.HierarchicalThemeSource;
import org.springframework.ui.context.Theme;
import org.springframework.ui.context.ThemeSource;
import org.springframework.ui.context.support.SimpleTheme;

public class ResourceBundleThemeSource
implements HierarchicalThemeSource {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ThemeSource parentThemeSource;
    private String basenamePrefix = "";
    private final Map themeCache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParentThemeSource(ThemeSource themeSource) {
        this.parentThemeSource = themeSource;
        Map map = this.themeCache;
        synchronized (map) {
            Iterator iterator = this.themeCache.values().iterator();
            while (iterator.hasNext()) {
                this.initParent((Theme)iterator.next());
            }
        }
    }

    public ThemeSource getParentThemeSource() {
        return this.parentThemeSource;
    }

    public void setBasenamePrefix(String string) {
        this.basenamePrefix = string != null ? string : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Theme getTheme(String string) {
        if (string == null) {
            return null;
        }
        Map map = this.themeCache;
        synchronized (map) {
            Theme theme = (Theme)this.themeCache.get(string);
            if (theme == null) {
                String string2 = this.basenamePrefix + string;
                MessageSource messageSource = this.createMessageSource(string2);
                theme = new SimpleTheme(string, messageSource);
                this.initParent(theme);
                this.themeCache.put(string, theme);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Theme created: name '" + string + "', basename [" + string2 + "]"));
                }
            }
            return theme;
        }
    }

    protected MessageSource createMessageSource(String string) {
        ResourceBundleMessageSource resourceBundleMessageSource = new ResourceBundleMessageSource();
        resourceBundleMessageSource.setBasename(string);
        return resourceBundleMessageSource;
    }

    protected void initParent(Theme theme) {
        if (theme.getMessageSource() instanceof HierarchicalMessageSource) {
            Theme theme2;
            HierarchicalMessageSource hierarchicalMessageSource = (HierarchicalMessageSource)theme.getMessageSource();
            if (this.getParentThemeSource() != null && hierarchicalMessageSource.getParentMessageSource() == null && (theme2 = this.getParentThemeSource().getTheme(theme.getName())) != null) {
                hierarchicalMessageSource.setParentMessageSource(theme2.getMessageSource());
            }
        }
    }
}

