/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.timer;

import java.util.Timer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.JdkVersion;
import org.springframework.scheduling.timer.ScheduledTimerTask;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class TimerFactoryBean
implements FactoryBean,
BeanNameAware,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ScheduledTimerTask[] scheduledTimerTasks;
    private boolean daemon = false;
    private String beanName;
    private Timer timer;
    static /* synthetic */ Class class$java$util$Timer;

    public void setScheduledTimerTasks(ScheduledTimerTask[] scheduledTimerTaskArray) {
        this.scheduledTimerTasks = scheduledTimerTaskArray;
    }

    public void setDaemon(boolean bl) {
        this.daemon = bl;
    }

    public void setBeanName(String string) {
        this.beanName = string;
    }

    public void afterPropertiesSet() {
        this.logger.info((Object)"Initializing Timer");
        this.timer = this.createTimer(this.beanName, this.daemon);
        if (!ObjectUtils.isEmpty((Object[])this.scheduledTimerTasks)) {
            this.registerTasks(this.scheduledTimerTasks, this.timer);
        }
    }

    protected Timer createTimer(String string, boolean bl) {
        Timer timer = this.createTimer(bl);
        if (timer != null) {
            return timer;
        }
        if (StringUtils.hasText((String)string) && JdkVersion.isAtLeastJava15()) {
            return new Timer(string, bl);
        }
        return new Timer(bl);
    }

    protected Timer createTimer(boolean bl) {
        return null;
    }

    protected void registerTasks(ScheduledTimerTask[] scheduledTimerTaskArray, Timer timer) {
        for (int i = 0; i < scheduledTimerTaskArray.length; ++i) {
            ScheduledTimerTask scheduledTimerTask = scheduledTimerTaskArray[i];
            if (scheduledTimerTask.isOneTimeTask()) {
                timer.schedule(scheduledTimerTask.getTimerTask(), scheduledTimerTask.getDelay());
                continue;
            }
            if (scheduledTimerTask.isFixedRate()) {
                timer.scheduleAtFixedRate(scheduledTimerTask.getTimerTask(), scheduledTimerTask.getDelay(), scheduledTimerTask.getPeriod());
                continue;
            }
            timer.schedule(scheduledTimerTask.getTimerTask(), scheduledTimerTask.getDelay(), scheduledTimerTask.getPeriod());
        }
    }

    public Object getObject() {
        return this.timer;
    }

    public Class getObjectType() {
        return class$java$util$Timer == null ? (class$java$util$Timer = TimerFactoryBean.class$("java.util.Timer")) : class$java$util$Timer;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        this.logger.info((Object)"Cancelling Timer");
        this.timer.cancel();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

