/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.timer;

import java.util.TimerTask;
import org.springframework.scheduling.timer.DelegatingTimerTask;

public class ScheduledTimerTask {
    private TimerTask timerTask;
    private long delay = 0L;
    private long period = -1L;
    private boolean fixedRate = false;

    public ScheduledTimerTask() {
    }

    public ScheduledTimerTask(TimerTask timerTask) {
        this.timerTask = timerTask;
    }

    public ScheduledTimerTask(TimerTask timerTask, long l) {
        this.timerTask = timerTask;
        this.delay = l;
    }

    public ScheduledTimerTask(TimerTask timerTask, long l, long l2, boolean bl) {
        this.timerTask = timerTask;
        this.delay = l;
        this.period = l2;
        this.fixedRate = bl;
    }

    public ScheduledTimerTask(Runnable runnable) {
        this.setRunnable(runnable);
    }

    public ScheduledTimerTask(Runnable runnable, long l) {
        this.setRunnable(runnable);
        this.delay = l;
    }

    public ScheduledTimerTask(Runnable runnable, long l, long l2, boolean bl) {
        this.setRunnable(runnable);
        this.delay = l;
        this.period = l2;
        this.fixedRate = bl;
    }

    public void setRunnable(Runnable runnable) {
        this.timerTask = new DelegatingTimerTask(runnable);
    }

    public void setTimerTask(TimerTask timerTask) {
        this.timerTask = timerTask;
    }

    public TimerTask getTimerTask() {
        return this.timerTask;
    }

    public void setDelay(long l) {
        this.delay = l;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setPeriod(long l) {
        this.period = l;
    }

    public long getPeriod() {
        return this.period;
    }

    public boolean isOneTimeTask() {
        return this.period <= 0L;
    }

    public void setFixedRate(boolean bl) {
        this.fixedRate = bl;
    }

    public boolean isFixedRate() {
        return this.fixedRate;
    }
}

