/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.support;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.support.ArgumentConvertingMethodInvoker;
import org.springframework.util.ClassUtils;

public class MethodInvokingRunnable
extends ArgumentConvertingMethodInvoker
implements Runnable,
BeanClassLoaderAware,
InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    protected Class resolveClassName(String string) throws ClassNotFoundException {
        return ClassUtils.forName((String)string, (ClassLoader)this.beanClassLoader);
    }

    public void afterPropertiesSet() throws ClassNotFoundException, NoSuchMethodException {
        this.prepare();
    }

    public void run() {
        try {
            this.invoke();
        }
        catch (InvocationTargetException invocationTargetException) {
            this.logger.warn((Object)this.getInvocationFailureMessage(), (Throwable)invocationTargetException);
        }
        catch (Throwable throwable) {
            this.logger.warn((Object)this.getInvocationFailureMessage(), throwable);
        }
    }

    protected String getInvocationFailureMessage() {
        return "Invocation of method '" + this.getTargetMethod() + "' on target class [" + this.getTargetClass() + "] failed";
    }
}

