/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.concurrent;

import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.scheduling.concurrent.ScheduledExecutorTask;
import org.springframework.scheduling.support.DelegatingExceptionProofRunnable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class ScheduledExecutorFactoryBean
implements FactoryBean,
BeanNameAware,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private int poolSize = 1;
    private ThreadFactory threadFactory = Executors.defaultThreadFactory();
    private RejectedExecutionHandler rejectedExecutionHandler = new ThreadPoolExecutor.AbortPolicy();
    private boolean exposeUnconfigurableExecutor = false;
    private ScheduledExecutorTask[] scheduledExecutorTasks;
    private boolean continueScheduledExecutionAfterException = false;
    private String beanName;
    private ScheduledExecutorService executor;

    public void setPoolSize(int n) {
        Assert.isTrue((n > 0 ? 1 : 0) != 0, (String)"'poolSize' must be 1 or higher");
        this.poolSize = n;
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory != null ? threadFactory : Executors.defaultThreadFactory();
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        this.rejectedExecutionHandler = rejectedExecutionHandler != null ? rejectedExecutionHandler : new ThreadPoolExecutor.AbortPolicy();
    }

    public void setExposeUnconfigurableExecutor(boolean bl) {
        this.exposeUnconfigurableExecutor = bl;
    }

    public void setScheduledExecutorTasks(ScheduledExecutorTask[] scheduledExecutorTaskArray) {
        this.scheduledExecutorTasks = scheduledExecutorTaskArray;
    }

    public void setContinueScheduledExecutionAfterException(boolean bl) {
        this.continueScheduledExecutionAfterException = bl;
    }

    public void setBeanName(String string) {
        this.beanName = string;
    }

    public void afterPropertiesSet() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Initializing ScheduledExecutorService" + (this.beanName != null ? " '" + this.beanName + "'" : "")));
        }
        ScheduledExecutorService scheduledExecutorService = this.createExecutor(this.poolSize, this.threadFactory, this.rejectedExecutionHandler);
        if (!ObjectUtils.isEmpty((Object[])this.scheduledExecutorTasks)) {
            this.registerTasks(this.scheduledExecutorTasks, scheduledExecutorService);
        }
        this.executor = this.exposeUnconfigurableExecutor ? Executors.unconfigurableScheduledExecutorService(scheduledExecutorService) : scheduledExecutorService;
    }

    protected ScheduledExecutorService createExecutor(int n, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        return new ScheduledThreadPoolExecutor(n, threadFactory, rejectedExecutionHandler);
    }

    protected void registerTasks(ScheduledExecutorTask[] scheduledExecutorTaskArray, ScheduledExecutorService scheduledExecutorService) {
        for (int i = 0; i < scheduledExecutorTaskArray.length; ++i) {
            ScheduledExecutorTask scheduledExecutorTask = scheduledExecutorTaskArray[i];
            Runnable runnable = this.getRunnableToSchedule(scheduledExecutorTask);
            if (scheduledExecutorTask.isOneTimeTask()) {
                scheduledExecutorService.schedule(runnable, scheduledExecutorTask.getDelay(), scheduledExecutorTask.getTimeUnit());
                continue;
            }
            if (scheduledExecutorTask.isFixedRate()) {
                scheduledExecutorService.scheduleAtFixedRate(runnable, scheduledExecutorTask.getDelay(), scheduledExecutorTask.getPeriod(), scheduledExecutorTask.getTimeUnit());
                continue;
            }
            scheduledExecutorService.scheduleWithFixedDelay(runnable, scheduledExecutorTask.getDelay(), scheduledExecutorTask.getPeriod(), scheduledExecutorTask.getTimeUnit());
        }
    }

    protected Runnable getRunnableToSchedule(ScheduledExecutorTask scheduledExecutorTask) {
        if (this.continueScheduledExecutionAfterException) {
            return new DelegatingExceptionProofRunnable(scheduledExecutorTask.getRunnable());
        }
        return scheduledExecutorTask.getRunnable();
    }

    public Object getObject() {
        return this.executor;
    }

    public Class getObjectType() {
        return this.executor != null ? this.executor.getClass() : ScheduledExecutorService.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Shutting down ScheduledExecutorService" + (this.beanName != null ? " '" + this.beanName + "'" : "")));
        }
        this.executor.shutdown();
    }
}

