/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.commonj;

import commonj.work.Work;
import commonj.work.WorkException;
import commonj.work.WorkItem;
import commonj.work.WorkListener;
import commonj.work.WorkManager;
import commonj.work.WorkRejectedException;
import java.util.Collection;
import javax.naming.NamingException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.jndi.JndiLocatorSupport;
import org.springframework.scheduling.SchedulingException;
import org.springframework.scheduling.SchedulingTaskExecutor;
import org.springframework.scheduling.commonj.DelegatingWork;
import org.springframework.util.Assert;

public class WorkManagerTaskExecutor
extends JndiLocatorSupport
implements SchedulingTaskExecutor,
WorkManager,
InitializingBean {
    private WorkManager workManager;
    private String workManagerName;
    private WorkListener workListener;
    static /* synthetic */ Class class$commonj$work$WorkManager;

    public void setWorkManager(WorkManager workManager) {
        this.workManager = workManager;
    }

    public void setWorkManagerName(String string) {
        this.workManagerName = string;
    }

    public void setWorkListener(WorkListener workListener) {
        this.workListener = workListener;
    }

    public void afterPropertiesSet() throws NamingException {
        if (this.workManager == null) {
            if (this.workManagerName == null) {
                throw new IllegalArgumentException("Either 'workManager' or 'workManagerName' must be specified");
            }
            this.workManager = (WorkManager)this.lookup(this.workManagerName, class$commonj$work$WorkManager == null ? (class$commonj$work$WorkManager = WorkManagerTaskExecutor.class$("commonj.work.WorkManager")) : class$commonj$work$WorkManager);
        }
    }

    public void execute(Runnable runnable) {
        Assert.state((this.workManager != null ? 1 : 0) != 0, (String)"No WorkManager specified");
        DelegatingWork delegatingWork = new DelegatingWork(runnable);
        try {
            if (this.workListener != null) {
                this.workManager.schedule((Work)delegatingWork, this.workListener);
            } else {
                this.workManager.schedule((Work)delegatingWork);
            }
        }
        catch (WorkRejectedException workRejectedException) {
            throw new TaskRejectedException("CommonJ WorkManager did not accept task: " + runnable, (Throwable)workRejectedException);
        }
        catch (WorkException workException) {
            throw new SchedulingException("Could not schedule task on CommonJ WorkManager", workException);
        }
    }

    public boolean prefersShortLivedTasks() {
        return true;
    }

    public WorkItem schedule(Work work) throws WorkException, IllegalArgumentException {
        return this.workManager.schedule(work);
    }

    public WorkItem schedule(Work work, WorkListener workListener) throws WorkException, IllegalArgumentException {
        return this.workManager.schedule(work, workListener);
    }

    public boolean waitForAll(Collection collection, long l) throws InterruptedException, IllegalArgumentException {
        return this.workManager.waitForAll(collection, l);
    }

    public Collection waitForAny(Collection collection, long l) throws InterruptedException, IllegalArgumentException {
        return this.workManager.waitForAny(collection, l);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

