/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.commonj;

import commonj.timers.Timer;
import commonj.timers.TimerManager;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.naming.NamingException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.Lifecycle;
import org.springframework.jndi.JndiLocatorSupport;
import org.springframework.scheduling.commonj.ScheduledTimerListener;

public class TimerManagerFactoryBean
extends JndiLocatorSupport
implements FactoryBean,
InitializingBean,
DisposableBean,
Lifecycle {
    private TimerManager timerManager;
    private String timerManagerName;
    private boolean shared = false;
    private ScheduledTimerListener[] scheduledTimerListeners;
    private final List timers = new LinkedList();
    static /* synthetic */ Class class$commonj$timers$TimerManager;

    public void setTimerManager(TimerManager timerManager) {
        this.timerManager = timerManager;
    }

    public void setTimerManagerName(String string) {
        this.timerManagerName = string;
    }

    public void setShared(boolean bl) {
        this.shared = bl;
    }

    public void setScheduledTimerListeners(ScheduledTimerListener[] scheduledTimerListenerArray) {
        this.scheduledTimerListeners = scheduledTimerListenerArray;
    }

    public void afterPropertiesSet() throws NamingException {
        if (this.timerManager == null) {
            if (this.timerManagerName == null) {
                throw new IllegalArgumentException("Either 'timerManager' or 'timerManagerName' must be specified");
            }
            this.timerManager = (TimerManager)this.lookup(this.timerManagerName, class$commonj$timers$TimerManager == null ? (class$commonj$timers$TimerManager = TimerManagerFactoryBean.class$("commonj.timers.TimerManager")) : class$commonj$timers$TimerManager);
        }
        for (int i = 0; i < this.scheduledTimerListeners.length; ++i) {
            ScheduledTimerListener scheduledTimerListener = this.scheduledTimerListeners[i];
            Timer timer = null;
            timer = scheduledTimerListener.isOneTimeTask() ? this.timerManager.schedule(scheduledTimerListener.getTimerListener(), scheduledTimerListener.getDelay()) : (scheduledTimerListener.isFixedRate() ? this.timerManager.scheduleAtFixedRate(scheduledTimerListener.getTimerListener(), scheduledTimerListener.getDelay(), scheduledTimerListener.getPeriod()) : this.timerManager.schedule(scheduledTimerListener.getTimerListener(), scheduledTimerListener.getDelay(), scheduledTimerListener.getPeriod()));
            this.timers.add(timer);
        }
    }

    public Object getObject() {
        return this.timerManager;
    }

    public Class getObjectType() {
        return this.timerManager != null ? this.timerManager.getClass() : (class$commonj$timers$TimerManager == null ? (class$commonj$timers$TimerManager = TimerManagerFactoryBean.class$("commonj.timers.TimerManager")) : class$commonj$timers$TimerManager);
    }

    public boolean isSingleton() {
        return true;
    }

    public void start() {
        if (!this.shared) {
            this.timerManager.resume();
        }
    }

    public void stop() {
        if (!this.shared) {
            this.timerManager.suspend();
        }
    }

    public boolean isRunning() {
        return !this.timerManager.isSuspending() && !this.timerManager.isStopping();
    }

    public void destroy() {
        Iterator iterator = this.timers.iterator();
        while (iterator.hasNext()) {
            Timer timer = (Timer)iterator.next();
            try {
                timer.cancel();
            }
            catch (Throwable throwable) {
                this.logger.warn((Object)"Could not cancel CommonJ Timer", throwable);
            }
        }
        this.timers.clear();
        if (!this.shared) {
            this.timerManager.stop();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

