/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.commonj;

import commonj.timers.TimerListener;
import org.springframework.scheduling.commonj.DelegatingTimerListener;

public class ScheduledTimerListener {
    private TimerListener timerListener;
    private long delay = 0L;
    private long period = -1L;
    private boolean fixedRate = false;

    public ScheduledTimerListener() {
    }

    public ScheduledTimerListener(TimerListener timerListener) {
        this.timerListener = timerListener;
    }

    public ScheduledTimerListener(TimerListener timerListener, long l) {
        this.timerListener = timerListener;
        this.delay = l;
    }

    public ScheduledTimerListener(TimerListener timerListener, long l, long l2, boolean bl) {
        this.timerListener = timerListener;
        this.delay = l;
        this.period = l2;
        this.fixedRate = bl;
    }

    public ScheduledTimerListener(Runnable runnable) {
        this.setRunnable(runnable);
    }

    public ScheduledTimerListener(Runnable runnable, long l) {
        this.setRunnable(runnable);
        this.delay = l;
    }

    public ScheduledTimerListener(Runnable runnable, long l, long l2, boolean bl) {
        this.setRunnable(runnable);
        this.delay = l;
        this.period = l2;
        this.fixedRate = bl;
    }

    public void setRunnable(Runnable runnable) {
        this.timerListener = new DelegatingTimerListener(runnable);
    }

    public void setTimerListener(TimerListener timerListener) {
        this.timerListener = timerListener;
    }

    public TimerListener getTimerListener() {
        return this.timerListener;
    }

    public void setDelay(long l) {
        this.delay = l;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setPeriod(long l) {
        this.period = l;
    }

    public long getPeriod() {
        return this.period;
    }

    public boolean isOneTimeTask() {
        return this.period < 0L;
    }

    public void setFixedRate(boolean bl) {
        this.fixedRate = bl;
    }

    public boolean isFixedRate() {
        return this.fixedRate;
    }
}

