/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.backportconcurrent;

import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionException;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.scheduling.SchedulingTaskExecutor;

public class ConcurrentTaskExecutor
implements SchedulingTaskExecutor,
Executor {
    private Executor concurrentExecutor;

    public ConcurrentTaskExecutor() {
        this.setConcurrentExecutor(null);
    }

    public ConcurrentTaskExecutor(Executor executor) {
        this.setConcurrentExecutor(executor);
    }

    public void setConcurrentExecutor(Executor executor) {
        this.concurrentExecutor = executor != null ? executor : Executors.newSingleThreadExecutor();
    }

    public Executor getConcurrentExecutor() {
        return this.concurrentExecutor;
    }

    public void execute(Runnable runnable) {
        try {
            this.concurrentExecutor.execute(runnable);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            throw new TaskRejectedException("Executor [" + this.concurrentExecutor + "] did not accept task: " + runnable, (Throwable)rejectedExecutionException);
        }
    }

    public boolean prefersShortLivedTasks() {
        return true;
    }
}

