/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jndi;

import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jndi.JndiCallback;
import org.springframework.jndi.TypeMismatchNamingException;

public class JndiTemplate {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Properties environment;

    public JndiTemplate() {
    }

    public JndiTemplate(Properties properties) {
        this.environment = properties;
    }

    public void setEnvironment(Properties properties) {
        this.environment = properties;
    }

    public Properties getEnvironment() {
        return this.environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(JndiCallback jndiCallback) throws NamingException {
        Context context = this.createInitialContext();
        try {
            Object object = jndiCallback.doInContext(context);
            return object;
        }
        finally {
            try {
                context.close();
            }
            catch (NamingException namingException) {
                this.logger.debug((Object)"Could not close JNDI InitialContext", (Throwable)namingException);
            }
        }
    }

    protected Context createInitialContext() throws NamingException {
        return new InitialContext(this.getEnvironment());
    }

    public Object lookup(final String string) throws NamingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Looking up JNDI object with name [" + string + "]"));
        }
        return this.execute(new JndiCallback(){

            public Object doInContext(Context context) throws NamingException {
                Object object = context.lookup(string);
                if (object == null) {
                    throw new NameNotFoundException("JNDI object with [" + string + "] not found: JNDI implementation returned null");
                }
                return object;
            }
        });
    }

    public Object lookup(String string, Class clazz) throws NamingException {
        Object object = this.lookup(string);
        if (clazz != null && !clazz.isInstance(object)) {
            throw new TypeMismatchNamingException(string, clazz, object != null ? object.getClass() : null);
        }
        return object;
    }

    public void bind(final String string, final Object object) throws NamingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Binding JNDI object with name [" + string + "]"));
        }
        this.execute(new JndiCallback(){

            public Object doInContext(Context context) throws NamingException {
                context.bind(string, object);
                return null;
            }
        });
    }

    public void rebind(final String string, final Object object) throws NamingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Rebinding JNDI object with name [" + string + "]"));
        }
        this.execute(new JndiCallback(){

            public Object doInContext(Context context) throws NamingException {
                context.rebind(string, object);
                return null;
            }
        });
    }

    public void unbind(final String string) throws NamingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Unbinding JNDI object with name [" + string + "]"));
        }
        this.execute(new JndiCallback(){

            public Object doInContext(Context context) throws NamingException {
                context.unbind(string);
                return null;
            }
        });
    }
}

